/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.service.GeneralSecurityRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ServiceInterface;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.polyscope.security.impl.cybersecurity.service.validation.IPSubnetValidator;
import com.ur.polyscope.security.impl.cybersecurity.service.validation.PortRangeValidator;
import com.ur.polyscope.security.impl.cybersecurity.service.validation.ValidatorException;
import com.ur.polyscope.security.impl.cybersecurity.ui.AbstractSecurityPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

@Singleton
public class GeneralSettingsPanel
extends AbstractSecurityPanel {
    private static final String UPDATING_INBOUND_ERROR = "Error in updating inbound settings";
    private static final String INBOUND_VALIDATION_ERROR = "Validation error in updating inbound settings";
    private static final String MAGIC_FILES_TOGGLE_NAME = GeneralSettingsPanel.class.getSimpleName() + ".magicFilesToggle";
    private static final String USB_PORTS_TOGGLE_NAME = GeneralSettingsPanel.class.getSimpleName() + ".usbPortsToggle";
    private static final String RESTRICT_FIELD_NAME = GeneralSettingsPanel.class.getSimpleName() + ".restrictTextField";
    private static final String DISABLE_PORTS_TEXT_FIELD = GeneralSettingsPanel.class.getSimpleName() + ".disablePortsTextField";
    private final GeneralSecurityRepository generalSecurityRepository;
    private final IPSubnetValidator ipSubnetValidator;
    private final PortRangeValidator portRangeValidator;
    private JTextField restrictTextField;
    private JTextField disablePortsTextField;
    private OnOffSwitch magicFilesToggle;
    private OnOffSwitch usbPortsToggle;

    @Inject
    public GeneralSettingsPanel(ViewContext viewContext, RequireAdminPasswordFooter passwordFooter, GeneralSecurityRepository generalSecurityRepository, ErrorDialogCreator errorDialogCreator, AdminLock adminLock, IPSubnetValidator ipSubnetValidator, PortRangeValidator portRangeValidator) {
        super(passwordFooter, viewContext, adminLock, errorDialogCreator);
        this.generalSecurityRepository = generalSecurityRepository;
        this.ipSubnetValidator = ipSubnetValidator;
        this.portRangeValidator = portRangeValidator;
    }

    @Override
    void initComponents() {
        this.setName(GeneralSettingsPanel.class.getSimpleName());
        this.setLayout(new BorderLayout());
        this.setAlignmentX(0.0f);
        this.setBackground(BACKGROUND_COLOR);
        this.add(this.createCard(this.textResource.miscSettings(), this.createMiscSettingPanel()), "North");
        this.add(this.createCard(this.textResource.miscInbound(), this.createInboundPanel()), "Center");
        this.assignHelpIDs();
    }

    private void assignHelpIDs() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:security_general");
    }

    @Override
    void update() {
        try {
            URAdminState state = this.generalSecurityRepository.getState();
            this.update(state);
        }
        catch (SecurityException ex) {
            this.handleError(ex.getCause(), this.textResource.uradminReadTitle(), this.textResource.uradminReadProblem(), "Error reading URAdmin state");
        }
    }

    @Override
    List<JComponent> getLockableComponents() {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        result.add((JComponent)this.magicFilesToggle);
        result.add((JComponent)this.usbPortsToggle);
        result.add(this.restrictTextField);
        result.add(this.disablePortsTextField);
        return result;
    }

    private JPanel createMiscSettingPanel() {
        this.magicFilesToggle = new OnOffSwitch(this.textResource.miscRunMagicFiles());
        this.magicFilesToggle.setName(MAGIC_FILES_TOGGLE_NAME);
        this.magicFilesToggle.addActionListener(event -> {
            try {
                URAdminState state = this.generalSecurityRepository.setRunMagicFiles(this.magicFilesToggle.isSelected());
                this.update(state);
            }
            catch (SecurityException se) {
                this.handleError(se, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.miscAutorun()), "Error updating magic files setting");
            }
        });
        FormBuilder builder = this.viewContext.createFormBuilder().spacer().end().buttonRow((JComponent)this.magicFilesToggle, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end();
        this.usbPortsToggle = new OnOffSwitch(this.textResource.miscUsbPorts());
        if (FeatureToggle.isActive((String)"systemPassword")) {
            this.usbPortsToggle.setName(USB_PORTS_TOGGLE_NAME);
            this.usbPortsToggle.addActionListener(event -> {
                try {
                    URAdminState state = this.generalSecurityRepository.setUsbPortsEnablement(this.usbPortsToggle.isSelected());
                    this.update(state);
                }
                catch (SecurityException se) {
                    this.handleError(se, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.miscPortAccess()), "Error updating magic files setting");
                }
            });
        }
        JPanel result = builder.getPanel();
        result.setBorder(BorderFactory.createMatteBorder(0, 0, 5, 0, G5LookAndFeel.BETWEEN_CARD_COLOR));
        return result;
    }

    private JPanel createInboundPanel() {
        this.restrictTextField = new JTextField();
        this.restrictTextField.setName(RESTRICT_FIELD_NAME);
        this.restrictTextField.setFocusable(false);
        this.addRestrictFieldTextPicker(this.restrictTextField);
        this.disablePortsTextField = new JTextField();
        this.disablePortsTextField.setName(DISABLE_PORTS_TEXT_FIELD);
        this.disablePortsTextField.setFocusable(false);
        this.addPortsFieldTextPicker(this.disablePortsTextField);
        JPanel inboundPanel = this.viewContext.createFormBuilder().label(this.textResource.miscRestrictNetworkAccess(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.restrictTextField, new FormBuilder.PanelConstraints[0]).end().spacer(2).end().label(this.textResource.miscDisableNetworkAccess(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.disablePortsTextField, new FormBuilder.PanelConstraints[0]).end().getPanel();
        inboundPanel.setBorder(this.createSideAndTopSpacedBorder());
        return inboundPanel;
    }

    private void addPortsFieldTextPicker(final JTextField textField) {
        TextFieldUtils.bindTextPicker((JComponent)textField, (TextHolder)new TextHolder(){

            public String getText() {
                return textField.getText();
            }

            public void setText(String s) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        GeneralSettingsPanel.this.portRangeValidator.validate(s);
                        URAdminState state = GeneralSettingsPanel.this.generalSecurityRepository.setDisabledPorts(s);
                        GeneralSettingsPanel.this.update(state);
                    }
                    catch (SecurityException se) {
                        GeneralSettingsPanel.this.handleError(se, GeneralSettingsPanel.this.textResource.uradminWriteTitle(), GeneralSettingsPanel.this.textResource.uradminWriteProblem(GeneralSettingsPanel.this.textResource.miscInbound()), GeneralSettingsPanel.UPDATING_INBOUND_ERROR);
                    }
                    catch (ValidatorException ve) {
                        GeneralSettingsPanel.this.handleError(ve, GeneralSettingsPanel.this.textResource.uradminWriteTitle(), ve.getMessage(), GeneralSettingsPanel.INBOUND_VALIDATION_ERROR);
                    }
                });
            }
        });
    }

    private void addRestrictFieldTextPicker(final JTextField textField) {
        TextFieldUtils.bindTextPicker((JComponent)textField, (TextHolder)new TextHolder(){

            public String getText() {
                return textField.getText();
            }

            public void setText(String s) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        GeneralSettingsPanel.this.ipSubnetValidator.validate(s);
                        URAdminState state = GeneralSettingsPanel.this.generalSecurityRepository.setRestrictedSubnet(s);
                        GeneralSettingsPanel.this.update(state);
                    }
                    catch (SecurityException se) {
                        GeneralSettingsPanel.this.handleError(se, GeneralSettingsPanel.this.textResource.uradminWriteTitle(), GeneralSettingsPanel.this.textResource.uradminWriteProblem(GeneralSettingsPanel.this.textResource.miscInbound()), GeneralSettingsPanel.UPDATING_INBOUND_ERROR);
                    }
                    catch (ValidatorException ve) {
                        GeneralSettingsPanel.this.handleError(ve, GeneralSettingsPanel.this.textResource.uradminWriteTitle(), ve.getMessage(), GeneralSettingsPanel.INBOUND_VALIDATION_ERROR);
                    }
                });
            }
        });
    }

    private Border createSideAndTopSpacedBorder() {
        return BorderFactory.createEmptyBorder(20, 10, 0, 10);
    }

    private void update(URAdminState state) {
        this.magicFilesToggle.setSelected(state.isAutorunEnabled());
        this.usbPortsToggle.setSelected(state.isUsbEnabled());
        ServiceInterface serviceInterface = state.getFirewall().getServiceInterface();
        if (serviceInterface != null) {
            this.restrictTextField.setText(serviceInterface.getRestrictedSubnet());
            this.disablePortsTextField.setText(serviceInterface.getBlockedPorts());
        } else {
            this.restrictTextField.setText("");
            this.disablePortsTextField.setText("");
        }
    }

    public OnOffSwitch usbPortToggle() {
        return this.usbPortsToggle;
    }
}

