/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyUtils;
import java.awt.FontMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.table.DefaultTableCellRenderer;

class SSHKeyCellRenderer
extends DefaultTableCellRenderer {
    private static final int MAX_CELL_WIDTH = 500;
    private static final String TRUNCATION_TEXT = "...";
    private static final Map<String, String> TRUNCATED_TEXT_CACHE = new ConcurrentHashMap<String, String>();
    private final FontMetrics fontMetrics = this.getFontMetrics(this.getFont());

    SSHKeyCellRenderer() {
    }

    @Override
    public void setText(String text) {
        super.setText(this.computeIfAbsent(text));
    }

    private String computeIfAbsent(String text) {
        String textToSet;
        if (TRUNCATED_TEXT_CACHE.containsKey(text)) {
            textToSet = TRUNCATED_TEXT_CACHE.get(text);
        } else {
            textToSet = SSHKeyUtils.truncateKeyIfNecessary(text, this.fontMetrics, TRUNCATION_TEXT, 500);
            TRUNCATED_TEXT_CACHE.put(text, textToSet);
        }
        return textToSet;
    }
}

