/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public final class SSHKeyUtils {
    private SSHKeyUtils() {
    }

    static List<SSHKey> parseSSHKeys(List<String> rawKeys) {
        ArrayList<SSHKey> list = new ArrayList<SSHKey>();
        for (String rawKey : rawKeys) {
            SSHKey key = SSHKeyUtils.parseSSHKey(rawKey);
            if (key == null) continue;
            list.add(SSHKeyUtils.parseSSHKey(rawKey));
        }
        return list;
    }

    static SSHKey parseSSHKey(String rawKey) {
        String key = rawKey.trim();
        int keyTypeIndex = SSHKeyUtils.findIndexOfKeyType(key);
        if (key.isEmpty() || key.startsWith("#") || keyTypeIndex < 0) {
            return null;
        }
        String result = key.substring(keyTypeIndex);
        return SSHKeyUtils.createSSHKey(result);
    }

    static String truncateKeyIfNecessary(String key, FontMetrics fontMetrics, String truncationText, int maxWidth) {
        if (key == null || fontMetrics == null) {
            return "";
        }
        if (fontMetrics.stringWidth(key) <= maxWidth) {
            return key;
        }
        return SSHKeyUtils.truncateText(key, fontMetrics, truncationText, maxWidth);
    }

    private static SSHKey createSSHKey(String parsedKey) {
        String[] splitKey = parsedKey.split("\\s+");
        SSHKeyType keyType = SSHKeyType.inferTypeFromString(splitKey[0]);
        if (splitKey.length == 2) {
            return new SSHKey(keyType, splitKey[1], "");
        }
        return new SSHKey(keyType, splitKey[1], splitKey[2]);
    }

    private static String truncateText(String text, FontMetrics metrics, String truncationText, int maxWidth) {
        int half = text.length() / 2;
        String inputPart1 = text.substring(0, half);
        String inputPart2 = text.substring(half + 1);
        int currentWidth = metrics.stringWidth(truncationText);
        int count = 0;
        StringBuilder resultPart1 = new StringBuilder();
        StringBuilder resultPart2 = new StringBuilder();
        while (currentWidth <= maxWidth) {
            int w2;
            char c1 = inputPart1.charAt(count);
            char c2 = inputPart2.charAt(inputPart2.length() - 1 - count);
            int w1 = metrics.charWidth(c1);
            if ((currentWidth += w1 + (w2 = metrics.charWidth(c2))) <= maxWidth) {
                resultPart1.append(c1);
                resultPart2.insert(0, c2);
            }
            ++count;
        }
        resultPart1.append(truncationText).append((CharSequence)resultPart2);
        return resultPart1.toString();
    }

    private static int findIndexOfKeyType(String input) {
        SSHKeyType keyType = SSHKeyType.inferTypeFromString(input);
        if (keyType == null) {
            return -1;
        }
        return input.indexOf(keyType.getName());
    }

    public static class SSHKey {
        private final SSHKeyType keyType;
        private final String key;
        private final String comment;

        public SSHKey(SSHKeyType keyType, String key, String comment) {
            this.keyType = keyType;
            this.key = key;
            this.comment = comment;
        }

        public SSHKeyType getKeyType() {
            return this.keyType;
        }

        public String getKey() {
            return this.key;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return (this.keyType.getName() + " " + this.key + " " + this.comment).trim();
        }
    }

    public static enum SSHKeyType {
        SK_ECDA_SHA2_NISTP256_OPENSSH("sk-ecdsa-sha2-nistp256@openssh.com"),
        ECDSA_SHA2_NISTP256("ecdsa-sha2-nistp256"),
        ECDSA_SHA2_NISTP384("ecdsa-sha2-nistp384"),
        ECDSA_SHA2_NISTP521("ecdsa-sha2-nistp521"),
        SK_SSH_ED25519_OPENSSH("sk-ssh-ed25519@openssh.com"),
        SSH_ED25519("ssh-ed25519"),
        SSH_DSS("ssh-dss"),
        SSH_RSA("ssh-rsa");

        private final String name;

        private SSHKeyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SSHKeyType inferTypeFromString(String input) {
            for (SSHKeyType keyType : SSHKeyType.values()) {
                if (!input.contains(keyType.getName())) continue;
                return keyType;
            }
            return null;
        }
    }
}

