/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyUtils;
import com.ur.polyscope.security.internal.TextResource;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class SSHKeysDataModel
extends AbstractTableModel {
    public static final int LABEL_COLUMN = 0;
    public static final int KEY_TYPE_COLUMN = 1;
    public static final int KEY_COLUMN = 2;
    private Object[][] data = new Object[0][];
    private final String[] headers;

    public SSHKeysDataModel(TextResource textResource) {
        this.headers = new String[]{textResource.label(), textResource.keyType(), textResource.key()};
    }

    public void setSshKeys(List<SSHKeyUtils.SSHKey> sshKeys) {
        this.data = this.toDataArray(sshKeys);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.headers[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
        }
        throw new IllegalStateException("No such column " + columnIndex);
    }

    private Object[][] toDataArray(List<SSHKeyUtils.SSHKey> sshKeys) {
        Object[][] result = new Object[sshKeys.size()][this.getColumnCount()];
        for (int i = 0; i < sshKeys.size(); ++i) {
            Object[] row = result[i];
            SSHKeyUtils.SSHKey sshKey = sshKeys.get(i);
            row[0] = sshKey.getComment();
            row[1] = sshKey.getKeyType().getName();
            row[2] = sshKey.getKey();
        }
        return result;
    }
}

