/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.disk.Directories;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.service.SecureShellRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.model.AuthenticationMethod;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.polyscope.security.impl.cybersecurity.ui.AbstractSecurityPanel;
import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyCellRenderer;
import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyFileFilter;
import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyTableHeaderRenderer;
import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeyUtils;
import com.ur.polyscope.security.impl.cybersecurity.ui.SSHKeysDataModel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

@Singleton
public class SecureShellPanel
extends AbstractSecurityPanel {
    private static final String ENABLE_ACCESS_CHECKBOX_NAME = SecureShellPanel.class.getSimpleName() + ".enableAccessCheckbox";
    private static final String ALLOW_PORT_FORWARD_CHECKBOX_NAME = SecureShellPanel.class.getSimpleName() + ".allowPOrtForwarCheckbox";
    private static final String PASSWORD_BUTTON_NAME = SecureShellPanel.class.getSimpleName() + ".passwordButton";
    private static final String KEY_BUTTON_NAME = SecureShellPanel.class.getSimpleName() + ".keyButton";
    private static final String BOTH_BUTTON_NAME = SecureShellPanel.class.getSimpleName() + ".bothButton";
    private static final String SSH_KEY_TABLE_NAME = SecureShellPanel.class.getSimpleName() + ".sshKeyTable";
    private static final String SSH_ADD_BUTTON_NAME = SecureShellPanel.class.getSimpleName() + ".sshAddButton";
    private static final String SSH_REMOVE_BUTTON_NAME = SecureShellPanel.class.getSimpleName() + ".sshRemoveButton";
    private final SecureShellRepository secureShellRepository;
    private final FilePersistence filePersistence;
    private final FileManagerConfiguration keyFileSelector;
    private SSHKeysDataModel dataModel;
    private JRadioButton passwordButton;
    private JRadioButton keyButton;
    private JRadioButton bothButton;
    private JCheckBox enableAccessCheckbox;
    private JCheckBox allowPortForwardCheckbox;
    private JTable sshKeysTable;
    private JButton removeButton;
    private JButton addButton;
    private JScrollPane keysPane;
    private JPanel authPanel;

    @Inject
    public SecureShellPanel(SecureShellRepository secureShellRepository, RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, FilePersistence filePersistence, ErrorDialogCreator errorDialogCreator, AdminLock adminLock) {
        super(passwordFooter, viewContext, adminLock, errorDialogCreator);
        this.secureShellRepository = secureShellRepository;
        this.filePersistence = filePersistence;
        this.keyFileSelector = new FileManagerConfiguration(this.textResource.sshKeyFilesTitle(), FileManagerConfiguration.Access.RESTRICTED, Directories.programs(), new URFileFilter[]{new SSHKeyFileFilter(this.textResource)});
    }

    @Override
    void update() {
        try {
            this.updateValues(this.secureShellRepository.getState());
        }
        catch (SecurityException e) {
            this.handleError(e, this.textResource.uradminReadTitle(), this.textResource.uradminReadProblem(), "Error reading URAdmin state");
        }
        this.addActionListeners();
    }

    @Override
    void cleanup() {
        super.cleanup();
        this.removeActionListeners();
    }

    private void removeActionListeners() {
        this.removeActionListeners(this.enableAccessCheckbox);
        this.removeActionListeners(this.allowPortForwardCheckbox);
        this.removeActionListeners(this.passwordButton);
        this.removeActionListeners(this.keyButton);
        this.removeActionListeners(this.bothButton);
    }

    @Override
    void initComponents() {
        this.setName(SecureShellPanel.class.getSimpleName());
        this.setLayout(new BorderLayout());
        this.setAlignmentX(0.0f);
        this.setBackground(BACKGROUND_COLOR);
        this.add(this.createCard(this.textResource.sshSettings(), this.createSSHPanel()), "North");
        this.add(this.createCard(this.textResource.sshAuthentication(), this.createAuthPanel()), "Center");
        this.assignHelpIDs();
    }

    private void assignHelpIDs() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:security_shell");
    }

    @Override
    List<JComponent> getLockableComponents() {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        result.add(this.enableAccessCheckbox);
        result.add(this.allowPortForwardCheckbox);
        result.add(this.passwordButton);
        result.add(this.keyButton);
        result.add(this.bothButton);
        result.add(this.addButton);
        result.add(this.removeButton);
        return result;
    }

    @Override
    public void doUnlock() {
        super.doUnlock();
        this.updateRemoveButton(this.sshKeysTable.getSelectedRow() >= 0);
    }

    @Override
    public void doLock() {
        super.doLock();
        this.updateRemoveButton(false);
    }

    private JPanel createSSHPanel() {
        this.enableAccessCheckbox = new JCheckBox(this.textResource.sshEnableAccess());
        this.enableAccessCheckbox.setName(ENABLE_ACCESS_CHECKBOX_NAME);
        this.allowPortForwardCheckbox = new JCheckBox(this.textResource.sshAllowForwarding());
        this.allowPortForwardCheckbox.setName(ALLOW_PORT_FORWARD_CHECKBOX_NAME);
        return this.viewContext.createFormBuilder().component((JComponent)this.enableAccessCheckbox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.allowPortForwardCheckbox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().getPanel();
    }

    private JPanel createAuthPanel() {
        this.setupAuthButtons();
        this.setupSSHKeysTable();
        this.setupAddRemoveButtons();
        return this.viewContext.createFormBuilder().component((JComponent)this.authPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().label(HTML.html((String)HTML.fontBold((String)this.textResource.sshManageKeys())), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.keysPane, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end(6).end().buttonRow((JComponent)this.addButton, (JComponent)this.removeButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().getPanel();
    }

    private void setupAddRemoveButtons() {
        this.addButton = new JButton(this.textResource.add());
        this.addButton.setName(SSH_ADD_BUTTON_NAME);
        this.addButton.addActionListener(e -> {
            SSHKeyFileContainer fileContainer = new SSHKeyFileContainer();
            this.filePersistence.openFile((FileContainer)fileContainer, this.keyFileSelector);
        });
        this.removeButton = new JButton(this.textResource.remove());
        this.removeButton.setName(SSH_REMOVE_BUTTON_NAME);
        this.updateRemoveButton(false);
        this.removeButton.addActionListener(event -> {
            int selectedRow = this.sshKeysTable.getSelectedRow();
            if (selectedRow >= 0) {
                try {
                    URAdminState state = this.secureShellRepository.removeSSHKey(selectedRow);
                    this.updateSSHTableDataModel(state.getSshState());
                }
                catch (SecurityException e) {
                    this.handleError(e, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.sshKeys()), "Error reading URAdmin state");
                }
            }
        });
    }

    private void setupSSHKeysTable() {
        this.dataModel = new SSHKeysDataModel(this.textResource);
        this.sshKeysTable = new JTable();
        this.sshKeysTable.setName(SSH_KEY_TABLE_NAME);
        this.sshKeysTable.setModel(this.dataModel);
        this.sshKeysTable.getTableHeader().setDefaultRenderer(new SSHKeyTableHeaderRenderer());
        this.sshKeysTable.setShowHorizontalLines(false);
        this.sshKeysTable.setShowVerticalLines(false);
        this.sshKeysTable.setRowSorter(null);
        this.sshKeysTable.setSelectionMode(0);
        this.sshKeysTable.setPreferredScrollableViewportSize(this.sshKeysTable.getPreferredSize());
        this.sshKeysTable.setFillsViewportHeight(true);
        this.sshKeysTable.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.sshKeysTable.setRowHeight(25);
        this.sshKeysTable.setAutoResizeMode(3);
        this.sshKeysTable.getSelectionModel().addListSelectionListener(e -> this.updateRemoveButton(true));
        this.sshKeysTable.setDefaultRenderer(String.class, new SSHKeyCellRenderer());
        this.keysPane = new JScrollPane();
        this.keysPane.setViewportView(this.sshKeysTable);
        this.keysPane.setBorder(BorderFactory.createMatteBorder(5, 0, 4, 0, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setLabelColumnWidth();
        this.setKeyTypeColumnWidth();
        this.setKeyColumnWidth();
    }

    private void setLabelColumnWidth() {
        int columnWidth = 205;
        TableColumn column = this.sshKeysTable.getColumnModel().getColumn(0);
        this.setColumnWidth(column, columnWidth);
    }

    private void setKeyTypeColumnWidth() {
        int columnWidth = 205;
        TableColumn column = this.sshKeysTable.getColumnModel().getColumn(1);
        this.setColumnWidth(column, columnWidth);
    }

    private void setKeyColumnWidth() {
        int columnWidth = 500;
        TableColumn column = this.sshKeysTable.getColumnModel().getColumn(2);
        column.setMinWidth(columnWidth);
    }

    private void setColumnWidth(TableColumn column, int columnWidth) {
        column.setMinWidth(columnWidth);
        column.setMaxWidth(columnWidth);
        column.setPreferredWidth(columnWidth);
    }

    private void setupAuthButtons() {
        this.passwordButton = new JRadioButton(this.textResource.sshAuthPasswordBased());
        this.passwordButton.setName(PASSWORD_BUTTON_NAME);
        this.keyButton = new JRadioButton(this.textResource.sshAuthKeyBased());
        this.keyButton.setName(KEY_BUTTON_NAME);
        this.bothButton = new JRadioButton(this.textResource.sshAuthBoth());
        this.bothButton.setName(BOTH_BUTTON_NAME);
        ButtonGroup authButtonGroup = new ButtonGroup();
        authButtonGroup.add(this.passwordButton);
        authButtonGroup.add(this.keyButton);
        authButtonGroup.add(this.bothButton);
        this.authPanel = new JPanel();
        this.authPanel.setLayout(new FlowLayout(3));
        this.authPanel.add(this.passwordButton);
        this.authPanel.add(this.keyButton);
        this.authPanel.add(this.bothButton);
    }

    private void addActionListeners() {
        this.enableAccessCheckbox.addActionListener(event -> {
            try {
                URAdminState state = this.secureShellRepository.setEnableSSHAccess(this.enableAccessCheckbox.isSelected());
                this.removeActionListeners();
                this.updateValues(state);
                this.addActionListeners();
            }
            catch (SecurityException e) {
                this.handleError(e, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.sshAccess()), "Error toggling SSH");
            }
        });
        this.allowPortForwardCheckbox.addActionListener(event -> {
            try {
                URAdminState state = this.secureShellRepository.setAllowPortForwarding(this.allowPortForwardCheckbox.isSelected());
                this.removeActionListeners();
                this.updateValues(state);
                this.addActionListeners();
            }
            catch (SecurityException e) {
                this.handleError(e, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.sshPortForward()), "Error updating port forwarding setting");
            }
        });
        this.setupAuthButton(this.passwordButton, AuthenticationMethod.PASSWORD_BASED);
        this.setupAuthButton(this.keyButton, AuthenticationMethod.KEY_BASED);
        this.setupAuthButton(this.bothButton, AuthenticationMethod.BOTH);
    }

    private void setupAuthButton(JRadioButton button, AuthenticationMethod authenticationMethod) {
        button.addActionListener(event -> {
            try {
                URAdminState state = this.secureShellRepository.setAuthenticationMethod(authenticationMethod);
                this.removeActionListeners();
                this.updateValues(state);
                this.addActionListeners();
            }
            catch (SecurityException e) {
                this.handleError(e, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.sshAuthentication()), "Error updating authentication method setting");
            }
        });
    }

    private void updateValues(URAdminState currentState) {
        SSHState sshState = currentState.getSshState();
        this.enableAccessCheckbox.setSelected(sshState.isEnabled());
        this.allowPortForwardCheckbox.setSelected(sshState.isAllowPortForwarding());
        switch (sshState.getAuthenticationMethod()) {
            case PASSWORD_BASED: {
                this.passwordButton.setSelected(true);
                break;
            }
            case KEY_BASED: {
                this.keyButton.setSelected(true);
                break;
            }
            case BOTH: {
                this.bothButton.setSelected(true);
            }
        }
        List<SSHKeyUtils.SSHKey> sshKeys = SSHKeyUtils.parseSSHKeys(sshState.getSshKeys());
        this.dataModel.setSshKeys(sshKeys);
    }

    private void updateSSHTableDataModel(SSHState sshState) {
        List<SSHKeyUtils.SSHKey> sshKeys = SSHKeyUtils.parseSSHKeys(sshState.getSshKeys());
        this.dataModel.setSshKeys(sshKeys);
        this.updateRemoveButton(this.sshKeysTable.getSelectedRow() >= 0);
    }

    private void updateRemoveButton(boolean enabled) {
        this.removeButton.setEnabled(enabled && !this.adminLock.isLocked());
    }

    private void removeActionListeners(AbstractButton button) {
        for (ActionListener actionListener : button.getActionListeners()) {
            button.removeActionListener(actionListener);
        }
    }

    private class SSHKeyFileContainer
    extends PerformingFileContainer {
        private SSHKeyFileContainer() {
        }

        public boolean perform() {
            if (this.hasFileSelected()) {
                File keyFile = this.getFile();
                try {
                    URAdminState state = SecureShellPanel.this.secureShellRepository.addSSHKeysFromFile(keyFile);
                    SecureShellPanel.this.updateSSHTableDataModel(state.getSshState());
                }
                catch (SecurityException e) {
                    SecureShellPanel.this.handleError(e, SecureShellPanel.this.textResource.sshUnableToReadFileTitle(), SecureShellPanel.this.textResource.sshUnableToReadFile(), "Unable to add SSH keys from file");
                    return false;
                }
            }
            return super.perform();
        }
    }
}

