/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.service.ServicesRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.model.Firewall;
import com.ur.polyscope.security.impl.cybersecurity.service.model.FirewallService;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.polyscope.security.impl.cybersecurity.ui.AbstractSecurityPanel;
import com.ur.polyscope.security.impl.cybersecurity.ui.ServicesTableHeaderRenderer;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@Singleton
public class ServicesSettingsPanel
extends AbstractSecurityPanel {
    private static final String TOGGLE_BUTTON_NAME = ServicesSettingsPanel.class.getSimpleName() + ".toggleButton";
    private static final String SERVICE_TABLE_NAME = ServicesSettingsPanel.class.getSimpleName() + ".serviceTable";
    private static final int STATUS_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int ID_COLUMN = 2;
    private final ServicesRepository servicesRepository;
    private ServicesDataModel dataModel;
    private JTable servicesTable;
    private JButton toggleButton;
    private JLabel serviceDescriptionLabel;
    private JLabel descriptionLabel;
    private JPanel togglePanel;
    private JScrollPane scrollPane;

    @Inject
    public ServicesSettingsPanel(ViewContext viewContext, RequireAdminPasswordFooter passwordFooter, ServicesRepository servicesRepository, ErrorDialogCreator errorDialogCreator, AdminLock adminLock) {
        super(passwordFooter, viewContext, adminLock, errorDialogCreator);
        this.servicesRepository = servicesRepository;
    }

    @Override
    void initComponents() {
        this.setName(ServicesSettingsPanel.class.getSimpleName());
        this.setLayout(new BorderLayout());
        this.setAlignmentX(0.0f);
        this.setBackground(BACKGROUND_COLOR);
        this.dataModel = new ServicesDataModel();
        this.add(this.createCard(this.textResource.servicesSettings(), this.createServicesList()), "Center");
        this.assignHelpIDs();
    }

    private void assignHelpIDs() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:security_services");
    }

    @Override
    void update() {
        try {
            this.updateDataModel(this.servicesRepository.getState().getFirewall());
        }
        catch (SecurityException e) {
            this.handleError(e, this.textResource.uradminReadTitle(), this.textResource.uradminReadProblem(), "Error reading URAdmin state");
        }
    }

    @Override
    List<JComponent> getLockableComponents() {
        return new ArrayList<JComponent>(Collections.singletonList(this.toggleButton));
    }

    @Override
    public void doUnlock() {
        super.doUnlock();
        this.updateToggleButton(this.getSelectedService());
    }

    @Override
    public void doLock() {
        super.doLock();
        this.updateToggleButton(this.getSelectedService());
    }

    private JPanel createServicesList() {
        this.setupDescriptionRow();
        this.updateToggleButton(null);
        this.setupServicesTable();
        this.setupScrollPane();
        return this.viewContext.createFormBuilder().label(this.textResource.servicesAdvisory(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().spacer().end().label(this.textResource.servicesTableDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.scrollPane, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(11).label(this.descriptionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).label(this.serviceDescriptionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).component((JComponent)this.togglePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
    }

    private void setupScrollPane() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.servicesTable);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel corner = new JPanel();
        corner.setBackground(Color.WHITE);
        corner.setOpaque(true);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
        this.scrollPane.getVerticalScrollBar().setBackground(Color.WHITE);
        this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private void setupDescriptionRow() {
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setHorizontalTextPosition(0);
        this.descriptionLabel.setVerticalTextPosition(0);
        this.serviceDescriptionLabel = new JLabel();
        this.serviceDescriptionLabel.setHorizontalTextPosition(0);
        this.serviceDescriptionLabel.setVerticalTextPosition(0);
        this.toggleButton = new JButton();
        this.toggleButton.setName(TOGGLE_BUTTON_NAME);
        this.toggleButton.addActionListener(event -> {
            FirewallService selectedService = this.getSelectedService();
            if (selectedService != null) {
                int selectedServiceIndex = this.getSelectedRow();
                try {
                    URAdminState state = this.servicesRepository.toggleServiceStatus(selectedService.getId(), !selectedService.isEnabled());
                    this.updateDataModel(state.getFirewall());
                }
                catch (SecurityException e) {
                    this.handleError(e, this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.services()), "Unable to toggle service status");
                }
                this.servicesTable.getSelectionModel().setSelectionInterval(selectedServiceIndex, selectedServiceIndex);
            }
        });
        this.togglePanel = new JPanel(new GridBagLayout());
        this.togglePanel.add((Component)this.toggleButton, new GridBagConstraints());
    }

    private void setupServicesTable() {
        this.servicesTable = new JTable();
        this.servicesTable.setName(SERVICE_TABLE_NAME);
        this.servicesTable.setModel(this.dataModel);
        this.servicesTable.setShowHorizontalLines(false);
        this.servicesTable.setShowVerticalLines(false);
        this.servicesTable.setAutoCreateRowSorter(true);
        this.servicesTable.setSelectionMode(0);
        this.servicesTable.setPreferredScrollableViewportSize(this.servicesTable.getPreferredSize());
        this.servicesTable.setFillsViewportHeight(true);
        this.servicesTable.getTableHeader().setEnabled(false);
        this.servicesTable.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.servicesTable.setRowHeight(25);
        this.servicesTable.setAutoResizeMode(3);
        TableColumnModel columnModel = this.servicesTable.getColumnModel();
        columnModel.removeColumn(columnModel.getColumn(2));
        this.servicesTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                FirewallService selectedService = this.getSelectedService();
                if (selectedService != null) {
                    this.serviceDescriptionLabel.setText(HTML.html((String)HTML.p((String)selectedService.getDescription())));
                    this.descriptionLabel.setText(this.textResource.description());
                } else {
                    this.serviceDescriptionLabel.setText("");
                    this.descriptionLabel.setText("");
                }
                this.updateToggleButton(selectedService);
            }
        });
        this.servicesTable.getTableHeader().setDefaultRenderer(new ServicesTableHeaderRenderer());
        this.servicesTable.setDefaultRenderer(String.class, new ServicesCellRenderer());
        this.setStatusColumnWidth();
    }

    private void setStatusColumnWidth() {
        int columnWidth = this.calculateStatusColumnWidth();
        TableColumn column = this.servicesTable.getColumnModel().getColumn(0);
        column.setMinWidth(columnWidth);
        column.setMaxWidth(columnWidth);
        column.setPreferredWidth(columnWidth);
    }

    private int calculateStatusColumnWidth() {
        int widest = this.getWidest(this.textResource.servicesStatus(), this.textResource.servicesStatusDisabled(), this.textResource.servicesStatusEnabled());
        return widest + 10;
    }

    private int getWidest(String ... strings) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int result = 0;
        for (String str : strings) {
            int width = metrics.stringWidth(str);
            if (width <= result) continue;
            result = width;
        }
        return result;
    }

    private void updateToggleButton(FirewallService selectedService) {
        boolean visible = selectedService != null;
        boolean enable = selectedService != null && !this.adminLock.isLocked();
        String enableText = selectedService != null && !selectedService.isEnabled() ? this.textResource.enable() : this.textResource.disable();
        this.toggleButton.setVisible(visible);
        this.toggleButton.setEnabled(enable);
        this.toggleButton.setText(enableText);
    }

    private void updateDataModel(Firewall firewall) {
        this.dataModel.setData(firewall.getServices());
    }

    private FirewallService getSelectedService() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0) {
            return this.dataModel.getService(selectedRow);
        }
        return null;
    }

    private int getSelectedRow() {
        return this.servicesTable.getSelectedRow();
    }

    private class ServicesCellRenderer
    extends DefaultTableCellRenderer {
        private ServicesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent cell = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.handleTextStyling(row, cell);
            this.handleTextPlacement();
            this.handleBorder(column, cell);
            return cell;
        }

        private void handleTextPlacement() {
            this.setHorizontalTextPosition(2);
            this.setVerticalTextPosition(0);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        private void handleTextStyling(int row, JComponent cell) {
            FirewallService service = ServicesSettingsPanel.this.dataModel.getService(row);
            if (service.isEnabled()) {
                cell.setForeground(Color.BLACK);
            } else {
                cell.setForeground(Color.LIGHT_GRAY);
            }
        }

        private void handleBorder(int column, JComponent cell) {
            if (column == 0) {
                cell.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, G5LookAndFeel.BETWEEN_CARD_COLOR), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            } else {
                cell.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, G5LookAndFeel.BETWEEN_CARD_COLOR), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            }
        }
    }

    private final class ServicesDataModel
    extends AbstractTableModel {
        private List<FirewallService> serviceDefinitions = Collections.emptyList();
        private final String[] headers;
        private Object[][] data = new Object[0][];

        private ServicesDataModel() {
            this.headers = new String[]{ServicesSettingsPanel.this.textResource.servicesStatus(), ServicesSettingsPanel.this.textResource.servicesInterface(), "HIDDEN ID"};
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<String> result;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    result = String.class;
                    break;
                }
                default: {
                    throw new IllegalStateException("No such column " + columnIndex);
                }
            }
            return result;
        }

        public void setData(List<FirewallService> serviceDefinitions) {
            this.serviceDefinitions = Collections.unmodifiableList(serviceDefinitions);
            this.data = this.toDataArray(serviceDefinitions);
            this.fireTableDataChanged();
        }

        private Object[][] toDataArray(List<FirewallService> serviceDefinitions) {
            Object[][] result = new Object[serviceDefinitions.size()][this.getColumnCount()];
            for (int i = 0; i < serviceDefinitions.size(); ++i) {
                FirewallService serviceDefinition = serviceDefinitions.get(i);
                Object[] row = result[i];
                row[0] = serviceDefinition.isEnabled() ? ServicesSettingsPanel.this.textResource.servicesStatusEnabled() : ServicesSettingsPanel.this.textResource.servicesStatusDisabled();
                row[1] = serviceDefinition.getId();
                row[2] = serviceDefinition.getId();
            }
            return result;
        }

        public FirewallService getService(int rowIndex) {
            return this.serviceDefinitions.get(rowIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }
    }
}

