/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.privilege;

import com.ur.polyscope.security.KickToScreen;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeLevelChangeListener;
import com.ur.swing.ActionInterceptor;
import com.ur.swing.InterceptableAction;
import com.ur.swing.SwingUtil;

class LockEnablingAction
extends ActionInterceptor.Default {
    private final Privilege<LockablePrivilegeLevel> privilege;
    private final KickToScreen locker;
    private final InterceptableAction decorated;
    private boolean enablementAllowed = true;

    LockEnablingAction(InterceptableAction decorated, Privilege<LockablePrivilegeLevel> privilege, KickToScreen locker) {
        super(decorated);
        this.decorated = decorated;
        this.privilege = privilege;
        this.locker = locker;
        privilege.addLevelChangeListener((PrivilegeLevelChangeListener)new PrivilegesChanged());
        this.update();
    }

    public void interceptSetEnabled(boolean enabled) {
        if (this.enablementAllowed != enabled) {
            this.enablementAllowed = enabled;
            this.update();
        }
    }

    private void update() {
        switch ((LockablePrivilegeLevel)this.privilege.getLevel()) {
            case ALLOWED: {
                this.decorated.doSetEnabled(this.enablementAllowed);
                break;
            }
            default: {
                this.decorated.doSetEnabled(false);
                if (!this.decorated.requiresImmediateDenial()) break;
                this.locker.kickToRunScreen();
            }
        }
    }

    private class PrivilegesChanged
    implements PrivilegeLevelChangeListener<LockablePrivilegeLevel> {
        private PrivilegesChanged() {
        }

        public void levelChanged(LockablePrivilegeLevel oldLevel, LockablePrivilegeLevel newLevel) {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LockEnablingAction.this.update();
                }
            });
        }
    }
}

