/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.util.event.EventManager;
import javax.inject.Inject;

public class AccessControlPasswordUpdateListener
implements PasswordUpdateListener {
    private final PasswordManager passwordManager;
    private final UserAccessControl userAccessControl;

    @Inject
    public AccessControlPasswordUpdateListener(EventManager eventManager, PasswordManager passwordManager, UserAccessControl userAccessControl) {
        this.passwordManager = passwordManager;
        this.userAccessControl = userAccessControl;
        eventManager.addStrongListener(PasswordUpdateListener.class, (Object)this);
        this.updateAccessControl();
    }

    public void onPasswordUpdate(PasswordManager.Lock lock) {
        this.updateAccessControl();
    }

    private void updateAccessControl() {
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.GENERAL)) {
            this.userAccessControl.setActive(OperationalModeSource.UI);
        } else {
            this.userAccessControl.setInactive(OperationalModeSource.UI);
        }
    }
}

