/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.impl.roles.UserProfileSettings;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class OperationalModeClearDashboardAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser CLEAR_OPERATOR_PROFILE = new ScriptActionDefinitionParser("clear operational mode");
    private UserAccessControl userAccessControl;
    private UserProfileSettings userProfileSettings;

    @Inject
    public OperationalModeClearDashboardAction(UserAccessControl userAccessControl, UserProfileSettings userProfileSettings) {
        this.userAccessControl = userAccessControl;
        this.userProfileSettings = userProfileSettings;
    }

    public boolean canHandleMessage(String input) {
        return CLEAR_OPERATOR_PROFILE.isMatch(input);
    }

    public String execute(String input) {
        this.userAccessControl.setInactive(OperationalModeSource.DASHBOARD_SERVER);
        this.userProfileSettings.setDashboardOperationalMode("");
        return "No longer controlling the operational mode. Current operational mode: '" + this.getCurrentOperationalModeMessage() + "'.";
    }

    private String getCurrentOperationalModeMessage() {
        OperationalMode operationalMode = this.userAccessControl.getCurrentOperationalMode();
        String response = "";
        switch (operationalMode) {
            case MANUAL: {
                response = response + (this.userAccessControl.getCurrentOperationalModeSource() != OperationalModeSource.NONE ? "MANUAL" : "NONE");
                break;
            }
            case AUTOMATIC: {
                response = response + "AUTOMATIC";
                break;
            }
            default: {
                response = response + "NONE";
            }
        }
        return response;
    }
}

