/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.lang.EnumUtils;
import com.ur.polyscope.security.ClosePopup;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.impl.roles.UserProfileSettings;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class OperationalModeDashboardAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser SET_OPERATIONAL_MODE = new ScriptActionDefinitionParser("set operational mode <arg>");
    private final UserAccessControl userAccessControl;
    private UserProfileSettings userProfileSettings;
    private ClosePopup closePopup;

    @Inject
    OperationalModeDashboardAction(UserAccessControl userAccessControl, UserProfileSettings userProfileSettings, ClosePopup closePopup) {
        this.userAccessControl = userAccessControl;
        this.userProfileSettings = userProfileSettings;
        this.closePopup = closePopup;
        OperationalMode savedOperationalMode = (OperationalMode)EnumUtils.getEnum(OperationalMode.class, (String)userProfileSettings.getDashboardOperationalMode());
        if (savedOperationalMode != null) {
            this.setNewOperationalMode(savedOperationalMode);
        }
    }

    public boolean canHandleMessage(String input) {
        return SET_OPERATIONAL_MODE.isMatch(input);
    }

    public String execute(String input) {
        OperationalMode newOperationalMode = this.getOperationalModeFromInput(input);
        if (!this.isValid(newOperationalMode)) {
            return this.notValidErrorMessage(input);
        }
        this.closeDialogIfAny();
        boolean success = this.setNewOperationalMode(newOperationalMode);
        this.closeDialogIfAny();
        return success ? this.operationalModeChangedMessage(input) : this.failedToSetModeMessage(input);
    }

    private OperationalMode getOperationalModeFromInput(String inputMode) {
        return (OperationalMode)EnumUtils.getEnum(OperationalMode.class, (String)this.desiredMode(inputMode));
    }

    private boolean isValid(OperationalMode newOperationalMode) {
        return newOperationalMode != null && (newOperationalMode == OperationalMode.AUTOMATIC || newOperationalMode == OperationalMode.MANUAL);
    }

    private String notValidErrorMessage(String inputMode) {
        return "Failed setting operational mode to '" + this.desiredMode(inputMode) + "': unknown mode. Possible modes are: [" + OperationalMode.AUTOMATIC.toString() + ", " + OperationalMode.MANUAL.toString() + "]";
    }

    private void closeDialogIfAny() {
        this.closePopup.requestToClose();
    }

    private boolean setNewOperationalMode(OperationalMode operationalMode) {
        boolean wasActive = this.userAccessControl.isActive(OperationalModeSource.DASHBOARD_SERVER);
        this.userAccessControl.setActive(OperationalModeSource.DASHBOARD_SERVER);
        boolean result = false;
        if (this.userAccessControl.canSetOperationalMode(OperationalModeSource.DASHBOARD_SERVER)) {
            this.userAccessControl.setOperationalMode(OperationalModeSource.DASHBOARD_SERVER, operationalMode);
            this.userProfileSettings.setDashboardOperationalMode(operationalMode.name());
            result = true;
        } else if (!wasActive) {
            this.userAccessControl.setInactive(OperationalModeSource.DASHBOARD_SERVER);
        }
        return result;
    }

    private String operationalModeChangedMessage(String inputMode) {
        return "Operational mode '" + this.desiredMode(inputMode) + "' is set";
    }

    private String failedToSetModeMessage(String inputMode) {
        return "Failed to set operational mode to '" + this.desiredMode(inputMode) + "': current operational mode source is '" + this.userAccessControl.getCurrentOperationalModeSource() + "'";
    }

    private String desiredMode(String inputMode) {
        return SET_OPERATIONAL_MODE.getArgument(0, inputMode);
    }
}

