/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.disk.Directories;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PasswordChangedWatcher;
import com.ur.polyscope.security.impl.roles.UserProfileSettings;
import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Properties;
import javax.inject.Singleton;

@Singleton
public final class Settings
implements UserProfileSettings,
PasswordChangedWatcher.AdminSetProperty {
    private static final String DASHBOARD_USER_PROFILE = "dashboardUserProfile";
    private static final String UI_USER_PROFILE = "uiUserProfile";
    private static final String SAFETY_UI_USER_PROFILE = "safetyUiUserProfile";
    private static final String SETTINGS_FILENAME = "gui.properties";
    private static final String SECURITY_PROPERTIES = "security.properties";
    private static final String ADMIN_SET = "adminSet";
    public static final String CLEARED_VALUE = "";
    private static WriteableModuleSettings moduleSettings;

    private static boolean settingsMigrated() {
        String fileNameAndPath = System.getProperty("user.home") + "/.polyscope/" + SECURITY_PROPERTIES;
        File file = new File(fileNameAndPath);
        return file.exists();
    }

    @Override
    public void setDashboardOperationalMode(String profileName) {
        Settings.getProperties().setProperty(DASHBOARD_USER_PROFILE, profileName);
        this.writeSettings();
    }

    @Override
    public String getDashboardOperationalMode() {
        return Settings.getProperties().getProperty(DASHBOARD_USER_PROFILE, CLEARED_VALUE);
    }

    @Override
    public void setSafetyUIOperationalMode(String profileName) {
        Settings.getProperties().setProperty(SAFETY_UI_USER_PROFILE, profileName);
        this.writeSettings();
    }

    @Override
    public String getSafetyUIOperationalMode() {
        return Settings.getProperties().getProperty(SAFETY_UI_USER_PROFILE, CLEARED_VALUE);
    }

    @Override
    public void setUIOperationalMode(String profileName) {
        Settings.getProperties().setProperty(UI_USER_PROFILE, profileName);
        this.writeSettings();
    }

    @Override
    public String getUIOperationalMode() {
        return Settings.getProperties().getProperty(UI_USER_PROFILE, CLEARED_VALUE);
    }

    @Override
    public boolean isAdminSet() {
        return Settings.getProperties().getBoolean(ADMIN_SET, false);
    }

    @Override
    public void enableAdminSet() {
        Settings.getProperties().setProperty(ADMIN_SET, Boolean.toString(true));
        this.writeSettings();
    }

    private static NiceProperties getProperties() {
        if (moduleSettings == null) {
            if (Settings.settingsMigrated()) {
                moduleSettings = new WriteableModuleSettings(SECURITY_PROPERTIES);
            } else {
                NiceProperties properties = new NiceProperties(Settings.readPropertiesFile());
                moduleSettings = new WriteableModuleSettings(SECURITY_PROPERTIES);
                moduleSettings.properties().setProperty(DASHBOARD_USER_PROFILE, properties.getProperty(DASHBOARD_USER_PROFILE, CLEARED_VALUE));
            }
        }
        return moduleSettings.properties();
    }

    private void writeSettings() {
        try {
            moduleSettings.write();
        }
        catch (IOException e) {
            Log.error((String)"Failed to write operational mode setting: ", (Throwable)e);
        }
    }

    private static Properties readPropertiesFile() {
        String fileNameAndPath = Directories.urcontrol() + File.separator + SETTINGS_FILENAME;
        try {
            return FileUtils.readPropertiesFromFile((String)fileNameAndPath);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ex) {
            Log.error((String)("Error while reading configuration file, '" + fileNameAndPath + "': "), (Throwable)ex);
        }
        return new Properties();
    }
}

