/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.polyscope.security.UserRoleManager;
import com.ur.security.Privilege;
import java.util.Collection;

public class UpdatePrivilegeLevel
implements PasswordUpdateListener,
UserRoleManager.RoleChangeListener {
    private final PasswordManager passwordManager;
    private final UserRoleManager roleManager;
    private final Privilege<LockablePrivilegeLevel> privilege;

    public UpdatePrivilegeLevel(Privilege<LockablePrivilegeLevel> privilege, PasswordManager passwordManager, UserRoleManager roleManager) {
        this.privilege = privilege;
        this.passwordManager = passwordManager;
        this.roleManager = roleManager;
    }

    public void onPasswordUpdate(PasswordManager.Lock lock) {
        this.updateLevel(this.privilege);
    }

    public void roleChanged(UserRoleManager.UserRole newRole) {
        this.updateLevel(this.privilege, newRole);
    }

    public void updateLevel(Privilege<LockablePrivilegeLevel> privilege) {
        this.updateLevel(privilege, this.passwordManager);
        this.updateLevel(privilege, this.roleManager.getActiveUserRole());
    }

    private void updateLevel(Privilege<LockablePrivilegeLevel> privilege, PasswordManager passwordManager) {
        PasswordManager.Lock lock = (PasswordManager.Lock)privilege.get(PasswordManager.Lock.class);
        if (lock != null) {
            if (passwordManager.isLocked(lock)) {
                privilege.addMaximumRestriction((Object)lock, (Enum)LockablePrivilegeLevel.LOCKED);
            } else {
                privilege.removeRestrictions((Object)lock);
            }
        }
    }

    private void updateLevel(Privilege<LockablePrivilegeLevel> privilege, UserRoleManager.UserRole activeRole) {
        Collection rolesForWhichAllowed = privilege.getCollection(UserRoleManager.UserRole.class);
        if (activeRole == UserRoleManager.UserRole.NONE || rolesForWhichAllowed != null && rolesForWhichAllowed.contains(activeRole)) {
            privilege.removeRestrictions(UserRoleManager.UserRole.class);
        } else {
            privilege.addMaximumRestriction(UserRoleManager.UserRole.class, (Enum)LockablePrivilegeLevel.DENIED);
        }
    }
}

