/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.roles;

import com.ur.lang.Defense;
import com.ur.lang.EnumUtils;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.monitor.ModelSource;
import com.ur.monitor.Source;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.PrivilegeChangeListener;
import com.ur.polyscope.security.SafetyType;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.impl.roles.UserProfileSettings;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.OperationalMode;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Source(value=UserAccessState.class)
public class UserAccessControlImpl
extends ModelSource<UserAccessState>
implements UserAccessControl {
    private final SortedSet<OperationalModeSource> activeSources;
    private final TextResource textResource;
    private final RobotMessageProducer messageProducer;
    private final EventManager eventManager;
    private final UserProfileSettings userProfileSettings;
    private UserAccessState currentState = UserAccessState.DEFAULT;

    @Inject
    public UserAccessControlImpl(TextResource textResource, RobotMessageProducer messageProducer, EventManager eventManager, UserProfileSettings userProfileSettings) {
        this.textResource = textResource;
        this.messageProducer = messageProducer;
        this.eventManager = eventManager;
        this.userProfileSettings = userProfileSettings;
        this.activeSources = new ConcurrentSkipListSet<OperationalModeSource>();
        this.activeSources.add(OperationalModeSource.NONE);
        this.loadOperationalMode(userProfileSettings);
        eventManager.addStrongListener(AccessControlStateListener.class, (Object)new PrivilegeChangeAdapter());
    }

    private void loadOperationalMode(UserProfileSettings userProfileSettings) {
        OperationalMode savedSafetyUIOperationalMode;
        OperationalMode savedUIOperationalMode = (OperationalMode)EnumUtils.getEnum(OperationalMode.class, (String)userProfileSettings.getUIOperationalMode());
        if (savedUIOperationalMode != null) {
            this.setActive(OperationalModeSource.UI);
            this.setOperationalMode(OperationalModeSource.UI, savedUIOperationalMode);
        }
        if ((savedSafetyUIOperationalMode = (OperationalMode)EnumUtils.getEnum(OperationalMode.class, (String)userProfileSettings.getSafetyUIOperationalMode())) != null) {
            this.setActive(OperationalModeSource.SAFETY_UI);
            this.setOperationalMode(OperationalModeSource.SAFETY_UI, savedSafetyUIOperationalMode);
        }
    }

    public UserAccessState getCurrentState() {
        return this.currentState;
    }

    public OperationalModeSource getCurrentOperationalModeSource() {
        return this.currentState.getOperationalModeSource();
    }

    public OperationalMode getCurrentOperationalMode() {
        return this.currentState.getOperationalMode();
    }

    public boolean isActive(OperationalModeSource operationalModeSource) {
        return this.activeSources.contains(operationalModeSource);
    }

    public void setActive(OperationalModeSource operationalModeSource) {
        Defense.notNull((Object)operationalModeSource, (String)"User profile source cannot be null");
        this.activeSources.add(operationalModeSource);
        this.updateCurrentSource();
    }

    public void setInactive(OperationalModeSource operationalModeSource) {
        Defense.notNull((Object)operationalModeSource, (String)"User profile source cannot be null");
        if (operationalModeSource != OperationalModeSource.NONE) {
            this.activeSources.remove(operationalModeSource);
            this.clearPersistedOperationalModeIfSourceIsUI(operationalModeSource);
        }
        this.updateCurrentSource();
    }

    public boolean canSetOperationalMode(OperationalModeSource operationalModeSource) {
        Defense.notNull((Object)operationalModeSource, (String)"User profile source cannot be null");
        return operationalModeSource != OperationalModeSource.NONE && this.verifySource(operationalModeSource);
    }

    public void setOperationalMode(OperationalModeSource operationalModeSource, OperationalMode targetOperationalMode) {
        Defense.notNull((Object)operationalModeSource, (String)"User profile source cannot be null");
        Defense.notNull((Object)targetOperationalMode, (String)"User profile cannot be null");
        if (this.canSetOperationalMode(operationalModeSource)) {
            UserAccessState.Template newState = new UserAccessState.Template(operationalModeSource, targetOperationalMode, this.getSafetyType());
            this.setActiveState((UserAccessState)newState);
        }
    }

    private void emit(UserAccessState userAccessState) {
        this.broadcaster.next((Object)userAccessState);
    }

    private synchronized void updateCurrentSource() {
        OperationalModeSource highestPriorityActiveSource = this.getHighestPriorityActiveSource();
        OperationalMode newOperationalMode = highestPriorityActiveSource == OperationalModeSource.NONE ? OperationalMode.MANUAL : this.getCurrentOperationalMode();
        UserAccessState.Template newState = new UserAccessState.Template(highestPriorityActiveSource, newOperationalMode, this.getSafetyType());
        this.doSetCurrentState((UserAccessState)newState);
    }

    private synchronized void setActiveState(UserAccessState newState) {
        if (this.verifySource(newState.getOperationalModeSource())) {
            this.doSetCurrentState(newState);
        }
    }

    private SafetyType getSafetyType() {
        if (this.activeSources.contains(OperationalModeSource.SAFETY_UI)) {
            return SafetyType.STRICT;
        }
        return SafetyType.NORMAL;
    }

    private boolean verifySource(OperationalModeSource operationalModeSource) {
        return this.getHighestPriorityActiveSource().equals((Object)operationalModeSource);
    }

    private void doSetCurrentState(UserAccessState newState) {
        UserAccessState oldState = this.currentState;
        Log.info((String)("Changing " + newState));
        if (!newState.equals(this.currentState)) {
            this.currentState = newState;
            OperationalMode oldOperationalMode = oldState.getOperationalMode();
            OperationalMode newOperationalMode = newState.getOperationalMode();
            this.persistOperationalModeIfSourceIsUI(newState);
            this.eventManager.fireEvent(AccessControlStateListener.class, listener -> listener.accessControlStateChanged(oldState, newState));
            this.emit(newState);
            if (oldOperationalMode != newOperationalMode) {
                String message = this.textResource.operationalModeChangedLogMessage((Enum<OperationalMode>)oldOperationalMode, (Enum<OperationalMode>)newOperationalMode);
                this.messageProducer.generateAndNotify(message);
            }
        }
    }

    private void persistOperationalModeIfSourceIsUI(UserAccessState newState) {
        if (OperationalModeSource.UI.equals((Object)newState.getOperationalModeSource())) {
            this.userProfileSettings.setUIOperationalMode(newState.getOperationalMode().name());
        } else if (OperationalModeSource.SAFETY_UI.equals((Object)newState.getOperationalModeSource())) {
            this.userProfileSettings.setSafetyUIOperationalMode(newState.getOperationalMode().name());
        }
    }

    private void clearPersistedOperationalModeIfSourceIsUI(OperationalModeSource operationalModeSource) {
        if (OperationalModeSource.UI.equals((Object)operationalModeSource)) {
            this.userProfileSettings.setUIOperationalMode("");
        } else if (OperationalModeSource.SAFETY_UI.equals((Object)operationalModeSource)) {
            this.userProfileSettings.setSafetyUIOperationalMode("");
        }
    }

    private OperationalModeSource getHighestPriorityActiveSource() {
        return this.activeSources.last();
    }

    private class PrivilegeChangeAdapter
    implements AccessControlStateListener {
        private PrivilegeChangeAdapter() {
        }

        public void accessControlStateChanged(UserAccessState oldState, UserAccessState currentState) {
            UserAccessControlImpl.this.eventManager.fireEvent(PrivilegeChangeListener.class, privilegeChangeListener -> privilegeChangeListener.privilegeChanged(currentState));
        }
    }
}

