/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.lang.Defense;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PasswordChangedWatcher;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

@Singleton
public abstract class EnterPasswordPanel
extends CardPanel {
    public static final String ENTER_PASSWORD_PANEL = "enterPasswordPanel." + EnterPasswordPanel.class.getSimpleName();
    public static final String PASSWORD_FIELD = "passwordField." + EnterPasswordPanel.class.getSimpleName();
    public static final String ACCEPT_PASSWORD = "acceptPassword." + EnterPasswordPanel.class.getSimpleName();
    public static final String CANCEL_PASSWORD = "cancelPassword." + EnterPasswordPanel.class.getSimpleName();
    public static final String ERROR_MESSAGE = "errorMessage." + EnterPasswordPanel.class.getSimpleName();
    private final transient PasswordManager passwordManager;
    private final PasswordChangedWatcher passwordChangedWatcher;
    private final transient URFontFactory fontFactory;
    private final boolean isEditing;
    private final boolean cancelEnabled;
    private final transient TextResource textResource;
    private transient PasswordLoginListener currentListener = null;
    private JPasswordField passwordField;
    private int numOfAttempts;
    private PasswordManager.Lock lockLevel;
    private JLabel errorMessage;

    @Inject
    public EnterPasswordPanel(PasswordManager passwordManager, ViewContext viewContext, EnterPasswordPanelOptions options, PasswordChangedWatcher passwordChangedWatcher) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.passwordManager = passwordManager;
        this.passwordChangedWatcher = passwordChangedWatcher;
        this.cancelEnabled = true;
        this.fontFactory = viewContext.getFontFactory();
        this.isEditing = false;
        this.initComponents(options);
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    private void initComponents(EnterPasswordPanelOptions options) {
        this.numOfAttempts = 0;
        this.setLayout(new BorderLayout());
        this.add(this.createLogonArea(options), "Center");
        this.setName(ENTER_PASSWORD_PANEL);
    }

    private Component createLogonArea(EnterPasswordPanelOptions options) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel lblHeader = new JLabel(options.panelHeader);
        JButton btnOk = new JButton(this.textResource.OK());
        final JButton btnCancel = new JButton(this.textResource.cancel());
        this.errorMessage = new JLabel("");
        this.errorMessage.setName(ERROR_MESSAGE);
        this.errorMessage.setForeground(G5LookAndFeel.ERROR_BORDER_COLOR);
        btnOk.setName(ACCEPT_PASSWORD);
        btnCancel.setName(CANCEL_PASSWORD);
        lblHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.HUGE));
        this.passwordField = new JPasswordField();
        this.passwordField.setName(PASSWORD_FIELD);
        this.passwordField.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        this.passwordField.setPreferredSize(new Dimension(300, 40));
        this.passwordField.setMinimumSize(new Dimension(300, 40));
        this.passwordField.setMaximumSize(new Dimension(300, 40));
        TextFieldUtils.bindEnterEventToButton((JTextField)this.passwordField, (JButton)btnOk);
        TextFieldUtils.bindTextPicker((JComponent)this.passwordField, (TextHolder)new TextHolder(){

            public String getText() {
                return "";
            }

            public void setText(String text) {
                EnterPasswordPanel.this.passwordField.setText(text);
            }
        }, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                EnterPasswordPanel.this.validateUserEnteredPassword();
            }

            public void requestCancel() {
                btnCancel.doClick();
            }
        }, (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
        Dimension dimBtn = new Dimension(200, 70);
        btnOk.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        btnOk.setMinimumSize(dimBtn);
        btnOk.setPreferredSize(dimBtn);
        btnOk.setMaximumSize(dimBtn);
        btnOk.addActionListener(e -> this.validateUserEnteredPassword());
        btnCancel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        btnCancel.setMinimumSize(dimBtn);
        btnCancel.setPreferredSize(dimBtn);
        btnCancel.setMaximumSize(dimBtn);
        btnCancel.addActionListener(e -> this.onCancelClicked());
        mainPanel.add(Box.createVerticalStrut(80));
        JPanel pan2 = new JPanel();
        pan2.setLayout(new BoxLayout(pan2, 0));
        pan2.add(Box.createHorizontalGlue());
        pan2.add(lblHeader);
        pan2.add(Box.createHorizontalGlue());
        mainPanel.add(pan2);
        mainPanel.add(Box.createVerticalGlue());
        pan2 = new JPanel();
        pan2.setLayout(new BoxLayout(pan2, 0));
        pan2.add(this.passwordField);
        pan2.add(Box.createHorizontalStrut(10));
        mainPanel.add(pan2);
        pan2 = new JPanel();
        pan2.setLayout(new BoxLayout(pan2, 0));
        pan2.add(this.errorMessage);
        pan2.add(Box.createHorizontalStrut(10));
        mainPanel.add(pan2);
        mainPanel.add(Box.createVerticalGlue());
        pan2 = new JPanel();
        pan2.setLayout(new BoxLayout(pan2, 0));
        pan2.add(Box.createHorizontalGlue());
        pan2.add(btnOk);
        if (this.isCancelEnabled()) {
            pan2.add(Box.createHorizontalStrut(100));
            pan2.add(btnCancel);
        }
        pan2.add(Box.createHorizontalGlue());
        mainPanel.add(pan2);
        mainPanel.add(Box.createVerticalStrut(100));
        return mainPanel;
    }

    protected void onCancelClicked() {
        this.navigateBack();
        this.fireOnFailureAndReleaseListener();
    }

    public void enter(Object obj) {
        Defense.isInstanceOf((Object)obj, PasswordManager.Lock.class);
        super.enter(obj);
        this.lockLevel = (PasswordManager.Lock)obj;
        if (!this.isEditing) {
            this.errorMessage.setText("");
            this.passwordField.setText("");
            this.numOfAttempts = 0;
        }
        SwingUtil.invokeLater(() -> this.passwordField.requestFocus());
    }

    public void validateUserEnteredPassword() {
        if (this.currentListener == null) {
            return;
        }
        if (this.enforceChangeAdminPassword()) {
            return;
        }
        this.validatePassword();
    }

    private void validatePassword() {
        String strp = new String(this.passwordField.getPassword());
        if (this.passwordManager.verifyPassword(this.lockLevel, strp)) {
            this.navigateBack();
            this.fireOnSuccessAndReleaseListener();
            return;
        }
        this.errorMessage.setText(this.textResource.incorrectPassword());
        this.passwordField.setText("");
        this.passwordField.requestFocus();
        ++this.numOfAttempts;
        if (this.isCancelEnabled() && this.numOfAttempts == 3) {
            this.onCancelClicked();
        }
    }

    private boolean enforceChangeAdminPassword() {
        if (!FeatureToggle.isActive((String)"systemPassword")) {
            return false;
        }
        if (this.lockLevel.equals((Object)PasswordManager.Lock.ADMIN) && this.passwordChangedWatcher.requiresPasswordChange()) {
            this.errorMessage.setText(this.textResource.adminPasswordNotChanged());
            this.passwordField.setText("");
            this.passwordField.requestFocus();
            return true;
        }
        return false;
    }

    public void setPasswordHandlerListener(PasswordLoginListener listener) {
        this.currentListener = listener;
    }

    private void fireOnSuccessAndReleaseListener() {
        if (this.currentListener != null) {
            this.currentListener.onLoginSuccess();
        }
        this.currentListener = null;
    }

    private void fireOnFailureAndReleaseListener() {
        if (this.currentListener != null) {
            this.currentListener.onLoginFailure();
        }
        this.currentListener = null;
    }

    public static class EnterPasswordPanelOptions {
        private final String panelHeader;

        public EnterPasswordPanelOptions(String panelHeader) {
            this.panelHeader = panelHeader;
        }
    }
}

