/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.impl.useraccess.EnterAdminPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterGeneralPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterHardcodedPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterSafetyPasswordPanel;
import com.ur.swing.FlipManager;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class GoToEnterPasswordImpl
implements GoToEnterPassword {
    private Map<Class<?>, EnterPasswordPanel> panels = new HashMap();

    @Inject
    public GoToEnterPasswordImpl(EnterGeneralPasswordPanel generalPasswordPanel, EnterAdminPasswordPanel adminPasswordPanel, EnterHardcodedPasswordPanel hardcodedPasswordPanel, EnterSafetyPasswordPanel safetyPasswordPanel) {
        this.panels.put(EnterGeneralPasswordPanel.class, generalPasswordPanel);
        this.panels.put(EnterAdminPasswordPanel.class, adminPasswordPanel);
        this.panels.put(EnterHardcodedPasswordPanel.class, hardcodedPasswordPanel);
        this.panels.put(EnterSafetyPasswordPanel.class, safetyPasswordPanel);
    }

    public boolean requestPassword(PasswordManager.Lock forLock, PasswordLoginListener listener) {
        Class<? extends EnterPasswordPanel> classType = this.getClassFromLock(forLock);
        if (classType == null) {
            return false;
        }
        EnterPasswordPanel panel = this.panels.get(classType);
        FlipManager flipManager = panel.getFlipManager();
        if (flipManager == null) {
            Log.warning((String)("Not able to show lock screen for: " + forLock));
            return false;
        }
        panel.setPasswordHandlerListener(listener);
        return flipManager.stackCurrentCardAndSwitchTo(classType);
    }

    private Class<? extends EnterPasswordPanel> getClassFromLock(PasswordManager.Lock forLock) {
        switch (forLock) {
            case GENERAL: {
                return EnterGeneralPasswordPanel.class;
            }
            case ADMIN: {
                return EnterAdminPasswordPanel.class;
            }
            case HARDCODED: {
                return EnterHardcodedPasswordPanel.class;
            }
            case SAFETY: {
                return EnterSafetyPasswordPanel.class;
            }
        }
        throw new IllegalArgumentException("Unknown lock: " + forLock);
    }
}

