/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.impl.useraccess.PasswordObjectFactory;
import com.ur.polyscope.security.impl.useraccess.PasswordScrambler;
import com.ur.polyscope.security.impl.useraccess.PersistedPassword;
import com.ur.polyscope.security.impl.useraccess.SimplePassword;
import com.ur.util.persist.Password;
import java.io.File;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PasswordFactory
implements PasswordObjectFactory {
    private static final File SYSTEM_PASSWORD_FILE = new File(System.getProperty("user.home"), ".urpass.file");
    private static final File SAFETY_PASSWORD_FILE = new File(System.getProperty("user.home"), ".ursafetypass.file");
    private final HashMap<PasswordManager.Lock, Password> passwords = new HashMap();
    private final PasswordScrambler passwordScrambler = new PasswordScrambler();

    @Inject
    public PasswordFactory() {
        PersistedPassword persistedPassword = new PersistedPassword(SYSTEM_PASSWORD_FILE, this.passwordScrambler);
        this.passwords.put(PasswordManager.Lock.GENERAL, persistedPassword);
        this.passwords.put(PasswordManager.Lock.GENERAL_WHEN_ENTERING_SET_PASSWORD_PANEL, persistedPassword);
        this.passwords.put(PasswordManager.Lock.SAFETY, new PersistedPassword(SAFETY_PASSWORD_FILE, this.passwordScrambler));
    }

    @Override
    public Password getPassword(PasswordManager.Lock lock) {
        if (this.passwords.containsKey(lock)) {
            return this.passwords.get(lock);
        }
        return new SimplePassword();
    }
}

