/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminPasswordStrategy;
import com.ur.polyscope.security.impl.useraccess.PasswordObjectFactory;
import com.ur.polyscope.security.impl.useraccess.PasswordStrategy;
import com.ur.polyscope.security.impl.useraccess.SimplePassword;
import com.ur.util.event.EventManager;
import java.util.EnumMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PasswordManagerImpl
implements PasswordManager {
    private static final String UROOT = "uroot";
    private static final String LIGHT_BOT = "lightbot";
    private static final String AUTOMATICA_2010 = "Automatica2010";
    private final EnumMap<PasswordManager.Lock, PasswordStrategy> passwordStrategies = new EnumMap(PasswordManager.Lock.class);
    private final EventManager eventManager;

    @Inject
    public PasswordManagerImpl(PasswordObjectFactory passwordFactory, EventManager eventManager, AdminPasswordStrategy adminPasswordStrategy) {
        this.eventManager = eventManager;
        this.passwordStrategies.put(PasswordManager.Lock.GENERAL, new PasswordStrategy.DefaultPasswordStrategy(passwordFactory.getPassword(PasswordManager.Lock.GENERAL), new String[0]));
        this.passwordStrategies.put(PasswordManager.Lock.GENERAL_WHEN_ENTERING_SET_PASSWORD_PANEL, new PasswordStrategy.DefaultPasswordStrategy(passwordFactory.getPassword(PasswordManager.Lock.GENERAL_WHEN_ENTERING_SET_PASSWORD_PANEL), AUTOMATICA_2010));
        this.passwordStrategies.put(PasswordManager.Lock.SAFETY, new PasswordStrategy.DefaultPasswordStrategy(passwordFactory.getPassword(PasswordManager.Lock.SAFETY), new String[0]));
        this.passwordStrategies.put(PasswordManager.Lock.ADMIN, adminPasswordStrategy);
        this.passwordStrategies.put(PasswordManager.Lock.HARDCODED, this.decorate(new PasswordStrategy.HardcodedPasswordOnlyStrategy(new SimplePassword(), LIGHT_BOT, UROOT)));
    }

    private LastVerifiedPasswordStrategyWrapper decorate(PasswordStrategy wrapped) {
        return new LastVerifiedPasswordStrategyWrapper(wrapped);
    }

    public boolean setNewPassword(PasswordManager.Lock lock, String newPassword) {
        boolean result = this.getPasswordStrategy(lock).setPassword(newPassword);
        if (result) {
            this.firePasswordUpdate(lock);
        }
        return result;
    }

    public boolean clearPassword(PasswordManager.Lock lock) {
        boolean result = this.getPasswordStrategy(lock).clearPassword();
        if (result) {
            this.firePasswordUpdate(lock);
        }
        return result;
    }

    private PasswordStrategy getPasswordStrategy(PasswordManager.Lock lock) {
        return this.passwordStrategies.get(lock);
    }

    public boolean verifyPassword(PasswordManager.Lock lock, String password) {
        return this.getPasswordStrategy(lock).verifyPassword(password);
    }

    public boolean isPasswordDefined(PasswordManager.Lock lock) {
        return this.getPasswordStrategy(lock).isPasswordDefined();
    }

    public boolean isLocked(PasswordManager.Lock lock) {
        return this.getPasswordStrategy(lock).isLocked();
    }

    public boolean lock(PasswordManager.Lock lock) {
        this.getPasswordStrategy(lock).lock();
        return true;
    }

    public void setPasswordStrategy(PasswordManager.Lock forLock, PasswordStrategy withStrategy) {
        this.passwordStrategies.put(forLock, this.decorate(withStrategy));
    }

    public boolean expertHardcodedPasswordWasLastEntered() {
        PasswordStrategy passwordStrategy = this.passwordStrategies.get(PasswordManager.Lock.HARDCODED);
        LastVerifiedPasswordStrategyWrapper passwordStrategy1 = (LastVerifiedPasswordStrategyWrapper)passwordStrategy;
        return UROOT.equals(passwordStrategy1.getLastVerifiedPassword());
    }

    private void firePasswordUpdate(PasswordManager.Lock lock) {
        this.eventManager.fireEvent(PasswordUpdateListener.class, listener -> listener.onPasswordUpdate(lock));
    }

    private static class LastVerifiedPasswordStrategyWrapper
    implements PasswordStrategy {
        private final PasswordStrategy wrapped;
        private String lastVerifiedPassword;

        public LastVerifiedPasswordStrategyWrapper(PasswordStrategy wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean setPassword(String password) {
            return this.wrapped.setPassword(password);
        }

        @Override
        public boolean clearPassword() {
            return this.wrapped.clearPassword();
        }

        @Override
        public boolean verifyPassword(String password) {
            boolean result = this.wrapped.verifyPassword(password);
            this.lastVerifiedPassword = result ? password : null;
            return result;
        }

        @Override
        public boolean isPasswordDefined() {
            return this.wrapped.isPasswordDefined();
        }

        @Override
        public boolean lock() {
            return this.wrapped.lock();
        }

        @Override
        public boolean isLocked() {
            return this.wrapped.isLocked();
        }

        public String getLastVerifiedPassword() {
            return this.lastVerifiedPassword;
        }
    }
}

