/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.impl.useraccess.ApplyPasswordStrategy;
import com.ur.polyscope.security.impl.useraccess.CanClear;
import com.ur.polyscope.security.impl.useraccess.PasswordPanelNames;
import com.ur.polyscope.security.impl.useraccess.PasswordPanelOptions;
import com.ur.polyscope.security.impl.useraccess.UserFeedbackMessages;
import com.ur.polyscope.security.internal.ImageResource;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;

class PasswordPanelProvider {
    private final PasswordManager passwordManager;
    private final PasswordPanelNames names;
    private final PasswordManager.Lock lock;
    private final PasswordManager.Lock lockForVerification;
    private final JLabel currentPasswordLabel;
    private final JPasswordField currentPassword;
    private final JPasswordField newPassword;
    private final JPasswordField confirmPassword;
    private final JButton applyPassword;
    private final JButton clearPassword;
    private final JPanel jPanel;
    private final UserFeedbackMessages userFeedback;

    public PasswordPanelProvider(PasswordPanelOptions options, ViewContext viewContext, PasswordManager passwordManager) {
        this.passwordManager = passwordManager;
        this.names = options.names;
        this.lock = options.lock;
        this.lockForVerification = options.lockForVerification;
        this.userFeedback = options.text;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.currentPasswordLabel = widgetFactory.createLabel(textResource.enterCurrentPassword());
        this.currentPassword = widgetFactory.createPasswordField(this.names.currentPassword, (DocumentListener)((Object)new PasswordFieldTextChangedAction()));
        this.newPassword = widgetFactory.createPasswordField(this.names.newPassword, (DocumentListener)((Object)new PasswordFieldTextChangedAction()));
        this.confirmPassword = widgetFactory.createPasswordField(this.names.confirmNewPassword, (DocumentListener)((Object)new PasswordFieldTextChangedAction()));
        this.applyPassword = widgetFactory.createButton((Action)((Object)new ApplyPasswordAction(options.applyPasswordStrategy, textResource)));
        this.clearPassword = widgetFactory.createButton((Action)((Object)new ClearPasswordAction(textResource)));
        FormBuilder formBuilder = viewContext.createFormBuilder().label(options.text.passwordDescription, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(3).label(textResource.enterCurrentPassword(), new FormBuilder.PanelConstraints[0]).spacer().end().component((JComponent)this.currentPassword, new FormBuilder.PanelConstraints[0]).end().label(textResource.enterNewPassword(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.newPassword, new FormBuilder.PanelConstraints[0]).end().label(textResource.confirmNewPassword(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.confirmPassword, new FormBuilder.PanelConstraints[0]).end().end();
        if (options.canClear == CanClear.YES) {
            formBuilder.buttonRow((JComponent)this.applyPassword, (JComponent)this.clearPassword, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end();
        } else {
            formBuilder.buttonRow((JComponent)this.applyPassword, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end();
        }
        if (options.text.adminPasswordWarning != null) {
            formBuilder.label(options.text.adminPasswordWarning, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
        }
        if (options.text.extraWarningText != null) {
            formBuilder.label(ImageResource.warning(), options.text.extraWarningText, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2);
            formBuilder.label(ImageResource.info(), options.text.changePermissionsPages, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2);
        }
        this.jPanel = new JPanel(new BorderLayout());
        this.jPanel.add((Component)formBuilder.getPanel(), "Center");
        this.jPanel.setBorder((Border)new CardBorder(options.text.passwordHeader));
    }

    public JPanel getJPanel() {
        return this.jPanel;
    }

    public void resetPasswordFields() {
        this.currentPassword.setText("");
        this.newPassword.setText("");
        this.confirmPassword.setText("");
    }

    public void setComponentEnablement() {
        boolean isPasswordDefined = this.passwordManager.isPasswordDefined(this.lock);
        this.currentPasswordLabel.setEnabled(isPasswordDefined);
        this.currentPassword.setEnabled(isPasswordDefined);
        boolean enableApplyButton = this.hasAllOfFieldsTextSet(this.newPassword, this.confirmPassword);
        if (isPasswordDefined) {
            enableApplyButton &= this.hasAllOfFieldsTextSet(this.currentPassword);
        }
        this.applyPassword.setEnabled(enableApplyButton);
        boolean enableClearButton = false;
        if (isPasswordDefined) {
            enableClearButton = this.hasAllOfFieldsTextSet(this.currentPassword) && this.hasNoneOfFieldsTextSet(this.newPassword, this.confirmPassword);
        }
        this.clearPassword.setEnabled(enableClearButton);
    }

    private boolean hasAllOfFieldsTextSet(JPasswordField ... fields) {
        for (JPasswordField jPasswordField : fields) {
            if (jPasswordField.getPassword().length != 0) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoneOfFieldsTextSet(JPasswordField ... fields) {
        for (JPasswordField jPasswordField : fields) {
            if (jPasswordField.getPassword().length <= 0) continue;
            return false;
        }
        return true;
    }

    public JPasswordField currentPasswordField() {
        return this.currentPassword;
    }

    public JPasswordField newPasswordField() {
        return this.newPassword;
    }

    public JPasswordField confirmPasswordField() {
        return this.confirmPassword;
    }

    public JButton applyNewPassword() {
        return this.applyPassword;
    }

    private class ClearPasswordAction
    extends AbstractActionDefinition {
        public ClearPasswordAction(TextResource textResource) {
            this.putValue("Name", textResource.clearPassword());
            this.putValue("InternalName", ((PasswordPanelProvider)PasswordPanelProvider.this).names.clearPassword);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent e) {
            if (PasswordPanelProvider.this.passwordManager.verifyPassword(PasswordPanelProvider.this.lockForVerification, String.valueOf(PasswordPanelProvider.this.currentPassword.getPassword()))) {
                PasswordPanelProvider.this.passwordManager.clearPassword(PasswordPanelProvider.this.lock);
            } else {
                PasswordPanelProvider.this.userFeedback.passwordsDoNotMatch(PasswordPanelProvider.this.currentPassword);
            }
            PasswordPanelProvider.this.resetPasswordFields();
            PasswordPanelProvider.this.setComponentEnablement();
        }
    }

    private class ApplyPasswordAction
    extends AbstractActionDefinition {
        private final ApplyPasswordStrategy applyPasswordStrategy;

        public ApplyPasswordAction(ApplyPasswordStrategy applyPasswordStrategy, TextResource textResource) {
            this.applyPasswordStrategy = applyPasswordStrategy;
            this.putValue("Name", textResource.applyPassword());
            this.putValue("InternalName", ((PasswordPanelProvider)PasswordPanelProvider.this).names.applyNewPassword);
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            String currentPasswordValue = String.valueOf(PasswordPanelProvider.this.currentPassword.getPassword());
            String newPasswordValue = String.valueOf(PasswordPanelProvider.this.newPassword.getPassword());
            String confirmPasswordValue = String.valueOf(PasswordPanelProvider.this.confirmPassword.getPassword());
            try {
                PasswordPanelProvider.this.userFeedback.clearMessages(PasswordPanelProvider.this.currentPassword, PasswordPanelProvider.this.newPassword, PasswordPanelProvider.this.confirmPassword, PasswordPanelProvider.this.applyPassword);
                this.setPassword(currentPasswordValue, newPasswordValue, confirmPasswordValue);
            }
            finally {
                PasswordPanelProvider.this.resetPasswordFields();
                PasswordPanelProvider.this.setComponentEnablement();
            }
        }

        private void setPassword(String currentPasswordValue, String newPasswordValue, String confirmPasswordValue) {
            if (!this.isCurrentPasswordValid(currentPasswordValue)) {
                PasswordPanelProvider.this.userFeedback.wrongPassword(PasswordPanelProvider.this.currentPassword);
                return;
            }
            if (!newPasswordValue.equals(confirmPasswordValue)) {
                PasswordPanelProvider.this.userFeedback.passwordsDoNotMatch(PasswordPanelProvider.this.confirmPassword);
                return;
            }
            this.applyPasswordStrategy.applyNewPassword(PasswordPanelProvider.this.passwordManager, PasswordPanelProvider.this.newPassword, PasswordPanelProvider.this.applyPassword);
        }

        private boolean isCurrentPasswordValid(String currentPasswordValue) {
            if (!PasswordPanelProvider.this.passwordManager.isPasswordDefined(PasswordPanelProvider.this.lock)) {
                return true;
            }
            return PasswordPanelProvider.this.passwordManager.verifyPassword(PasswordPanelProvider.this.lockForVerification, currentPasswordValue);
        }
    }

    private class PasswordFieldTextChangedAction
    extends DocumentUpdateListener {
        private PasswordFieldTextChangedAction() {
        }

        public void update() {
            PasswordPanelProvider.this.setComponentEnablement();
        }
    }
}

