/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.lang.EqualsUtil;
import com.ur.util.persist.Password;

public interface PasswordStrategy {
    public boolean setPassword(String var1);

    public boolean clearPassword();

    public boolean verifyPassword(String var1);

    public boolean isPasswordDefined();

    public boolean lock();

    public boolean isLocked();

    public static class HardcodedPasswordOnlyStrategy
    extends DefaultPasswordStrategy {
        public HardcodedPasswordOnlyStrategy(Password password, String ... hardcodedPasswords) {
            super(password, hardcodedPasswords);
        }

        @Override
        public boolean setPassword(String password) {
            return false;
        }

        @Override
        public boolean clearPassword() {
            return false;
        }

        @Override
        public boolean isPasswordDefined() {
            return true;
        }

        @Override
        public boolean verifyPassword(String passwordToVerify) {
            return this.isHardcodedPassword(passwordToVerify);
        }
    }

    public static class DefaultPasswordStrategy
    implements PasswordStrategy {
        protected final Password password;
        protected final String[] hardcodedPasswords;

        public DefaultPasswordStrategy(Password password, String ... hardcodedPasswords) {
            this.password = password;
            this.hardcodedPasswords = hardcodedPasswords;
        }

        @Override
        public boolean clearPassword() {
            this.password.clearPassword();
            return true;
        }

        @Override
        public boolean setPassword(String scrambledPassword) {
            this.password.setPassword(scrambledPassword);
            return true;
        }

        @Override
        public boolean isPasswordDefined() {
            return this.password.isPasswordDefined();
        }

        @Override
        public boolean verifyPassword(String passwordToVerify) {
            if (this.password.verifyPassword(passwordToVerify)) {
                return true;
            }
            return this.isHardcodedPassword(passwordToVerify);
        }

        @Override
        public boolean lock() {
            return true;
        }

        @Override
        public boolean isLocked() {
            return this.isPasswordDefined();
        }

        protected boolean isHardcodedPassword(String passwordToVerify) {
            for (String each : this.hardcodedPasswords) {
                if (!EqualsUtil.equals((Object)each, (Object)passwordToVerify)) continue;
                return true;
            }
            return false;
        }
    }
}

