/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.polyscope.security.impl.useraccess.PasswordScrambler;
import com.ur.util.persist.FileUtils;
import com.ur.util.persist.Password;
import java.io.File;

public class PersistedPassword
implements Password {
    private final File file;
    private String password;
    private final PasswordScrambler passwordScrambler;

    public PersistedPassword(File file, PasswordScrambler passwordScrambler) {
        this.file = file;
        this.passwordScrambler = passwordScrambler;
        this.readFromFile();
    }

    public void setPassword(String password) {
        this.password = this.passwordScrambler.scramblePassword(password);
        this.writeToFile();
    }

    public void clearPassword() {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.password = "";
    }

    public boolean verifyPassword(String passwordInPlainText) {
        String scrambledPassword = this.passwordScrambler.scramblePassword(passwordInPlainText);
        return EqualsUtil.equals((Object)this.password, (Object)scrambledPassword);
    }

    public boolean isPasswordDefined() {
        return !StringUtils.isNullOrEmpty((String)this.password);
    }

    private void writeToFile() {
        FileUtils.writeToFile((String)this.password, (File)this.file);
    }

    private void readFromFile() {
        this.password = this.file.exists() ? FileUtils.readFromFile((File)this.file, (String)"") : "";
    }
}

