/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class SetPasswordPanel
extends CardPanel {
    private static final Dimension PASSWORD_DIMENSIONS = new Dimension(140, 31);
    public static final String NEW_SYSTEM_PASSWORD = "new.system.password";
    public static final String CONFIRM_SYSTEM_PASSWORD = "confirm.new.system.password";
    public static final String APPLY_NEW_SYSTEM_PASSWORD = "apply.new.system.password";
    public static final String OLD_SAFETY_PASSWORD = "old.safety.password";
    public static final String NEW_SAFETY_PASSWORD = "new.safety.password";
    public static final String CONFIRM_SAFETY_PASSWORD = "confirm.new.safety.password";
    public static final String APPLY_NEW_SAFETY_PASSWORD = "apply.new.safety.password";
    private PasswordPanel newPassword;
    private PasswordPanel confirmPassword;
    private JLabel systemPasswordStatus;
    private PasswordPanel oldSafetyPassword;
    private PasswordPanel newSafetyPassword;
    private PasswordPanel confirmSafetyPassword;
    private JLabel safetyPasswordStatus;
    private final PasswordManager passwordManager;
    private final TextResource textResource;

    @Inject
    public SetPasswordPanel(PasswordManager passwordManager, TextResource textResource) {
        this.passwordManager = passwordManager;
        this.textResource = textResource;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.setAlignmentX(0.0f);
        this.systemPasswordStatus = SetPasswordPanel.explanation("");
        this.safetyPasswordStatus = SetPasswordPanel.explanation("");
        this.add(SetPasswordPanel.labelHeader(this.textResource.changePasswordTitle()));
        this.add(Box.createVerticalStrut(20));
        this.add(this.createSystemPasswordPanel());
        this.add(this.createActionButtons(this.systemPasswordStatus, APPLY_NEW_SYSTEM_PASSWORD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetPasswordPanel.this.onSetPasswordClicked(SetPasswordPanel.this.systemPasswordStatus, PasswordManager.Lock.GENERAL, SetPasswordPanel.this.newPassword.getPassword(), SetPasswordPanel.this.confirmPassword.getPassword());
            }
        }));
        this.add(Box.createVerticalStrut(30));
        this.add(SetPasswordPanel.labelHeader(this.textResource.safetyPwSetSafetyPassword()));
        this.add(Box.createVerticalStrut(20));
        this.add(this.createSafetyPasswordPanel());
        this.add(this.createActionButtons(this.safetyPasswordStatus, APPLY_NEW_SAFETY_PASSWORD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetPasswordPanel.this.passwordManager.isPasswordDefined(PasswordManager.Lock.SAFETY)) {
                    if (SetPasswordPanel.this.passwordManager.verifyPassword(PasswordManager.Lock.SAFETY, SetPasswordPanel.this.oldSafetyPassword.getPassword())) {
                        SetPasswordPanel.this.onSetPasswordClicked(SetPasswordPanel.this.safetyPasswordStatus, PasswordManager.Lock.SAFETY, SetPasswordPanel.this.newSafetyPassword.getPassword(), SetPasswordPanel.this.confirmSafetyPassword.getPassword());
                    } else {
                        SetPasswordPanel.this.setTextErr(SetPasswordPanel.this.safetyPasswordStatus, SetPasswordPanel.this.textResource.wrongPassword());
                    }
                } else {
                    SetPasswordPanel.this.onSetPasswordClicked(SetPasswordPanel.this.safetyPasswordStatus, PasswordManager.Lock.SAFETY, SetPasswordPanel.this.newSafetyPassword.getPassword(), SetPasswordPanel.this.confirmSafetyPassword.getPassword());
                }
                SetPasswordPanel.this.oldSafetyPassword.setEnablePassword(SetPasswordPanel.this.passwordManager.isPasswordDefined(PasswordManager.Lock.SAFETY));
            }
        }));
        this.setBorder(BorderFactory.createEmptyBorder(7, 10, 5, 21));
    }

    public void enter(Object o) {
        super.enter(o);
        this.resetFields();
        this.clearSystemPasswordStatus();
        this.clearSafetyPasswordStatus();
        this.oldSafetyPassword.setEnablePassword(this.passwordManager.isPasswordDefined(PasswordManager.Lock.SAFETY));
    }

    private JPanel createActionButtons(JLabel passwordSaveStatus, String name, ActionListener action) {
        JPanel result = new JPanel();
        JButton applyPasswordChange = new JButton(this.textResource.applyPassword());
        applyPasswordChange.addActionListener(action);
        applyPasswordChange.setName(name);
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createHorizontalGlue());
        result.add(passwordSaveStatus);
        result.add(Box.createHorizontalStrut(20));
        result.add(applyPasswordChange);
        result.setAlignmentX(0.0f);
        return result;
    }

    protected void onSetPasswordClicked(JLabel label, PasswordManager.Lock lock, String password, String confirmedPassword) {
        if (lock == PasswordManager.Lock.SAFETY && confirmedPassword.isEmpty()) {
            this.setTextErr(label, this.textResource.passwordCannotBeEmpty());
        } else if (password.equals(confirmedPassword)) {
            this.passwordManager.setNewPassword(lock, password);
            this.setTextOk(label, this.textResource.passwordHasBeenChanged());
        } else {
            this.setTextErr(label, this.textResource.passwordsDoNotMatch());
        }
        this.resetFields();
    }

    private void resetFields() {
        this.newPassword.clear();
        this.confirmPassword.clear();
        this.oldSafetyPassword.clear();
        this.newSafetyPassword.clear();
        this.confirmSafetyPassword.clear();
    }

    private void clearSystemPasswordStatus() {
        this.systemPasswordStatus.setText("");
    }

    private void clearSafetyPasswordStatus() {
        this.safetyPasswordStatus.setText("");
    }

    private void setTextOk(JLabel label, String string) {
        label.setForeground(Color.GREEN.darker().darker());
        label.setText(string);
    }

    private void setTextErr(JLabel label, String string) {
        label.setForeground(Color.red);
        label.setText(string);
    }

    private JPanel createSystemPasswordPanel() {
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new BoxLayout(passwordPanel, 1));
        CompletedListener systemPasswordCompletedListener = new CompletedListener(){

            public void requestApply() {
                SetPasswordPanel.this.clearSystemPasswordStatus();
            }

            public void requestCancel() {
            }
        };
        this.newPassword = new PasswordPanel(this.textResource.enterNewPassword(), NEW_SYSTEM_PASSWORD, systemPasswordCompletedListener);
        this.confirmPassword = new PasswordPanel(this.textResource.confirmNewPassword(), CONFIRM_SYSTEM_PASSWORD, systemPasswordCompletedListener);
        passwordPanel.add(this.newPassword);
        passwordPanel.add(Box.createVerticalStrut(5));
        passwordPanel.add(this.confirmPassword);
        passwordPanel.setAlignmentX(0.0f);
        return passwordPanel;
    }

    private JPanel createSafetyPasswordPanel() {
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new BoxLayout(passwordPanel, 1));
        CompletedListener safetyPasswordCompletedListener = new CompletedListener(){

            public void requestApply() {
                SetPasswordPanel.this.clearSafetyPasswordStatus();
            }

            public void requestCancel() {
            }
        };
        this.oldSafetyPassword = new PasswordPanel(this.textResource.enterCurrentPassword(), OLD_SAFETY_PASSWORD, safetyPasswordCompletedListener);
        this.newSafetyPassword = new PasswordPanel(this.textResource.enterNewPassword(), NEW_SAFETY_PASSWORD, safetyPasswordCompletedListener);
        this.confirmSafetyPassword = new PasswordPanel(this.textResource.confirmNewPassword(), CONFIRM_SAFETY_PASSWORD, safetyPasswordCompletedListener);
        passwordPanel.add(this.oldSafetyPassword);
        passwordPanel.add(Box.createVerticalStrut(15));
        passwordPanel.add(this.newSafetyPassword);
        passwordPanel.add(Box.createVerticalStrut(5));
        passwordPanel.add(this.confirmSafetyPassword);
        passwordPanel.setAlignmentX(0.0f);
        return passwordPanel;
    }

    public static JLabel labelHeader(String text) {
        JLabel result = SetPasswordPanel.label("<h1>" + text + "</h1>");
        return result;
    }

    public static JLabel label(String text) {
        JLabel result = new JLabel("<html>" + text + "</html>");
        result.setAlignmentX(0.0f);
        return result;
    }

    public static JLabel explanation(String explanation) {
        return SetPasswordPanel.label(explanation);
    }

    private static class PasswordPanel
    extends JPanel {
        private final JComponent label;
        private final JPasswordField passwordField;
        private final JLabel stateIcon;
        private BindingRegistration registration;
        private CompletedListener passwordCompletedListener;

        public PasswordPanel(String text, String name, CompletedListener passwordCompletedListener) {
            this.label = SetPasswordPanel.label(text);
            this.passwordField = new JPasswordField();
            this.stateIcon = new JLabel();
            this.passwordCompletedListener = passwordCompletedListener;
            this.passwordField.setName(name);
            this.passwordField.setPreferredSize(PASSWORD_DIMENSIONS);
            this.passwordField.setMaximumSize(PASSWORD_DIMENSIONS);
            this.passwordField.setMinimumSize(PASSWORD_DIMENSIONS);
            this.registration = this.bindTextPicker();
            this.setAlignmentX(0.0f);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(Box.createHorizontalGlue());
            this.add(this.label);
            this.add(Box.createHorizontalGlue());
            this.add(this.passwordField);
            this.add(Box.createHorizontalGlue());
            this.add(this.stateIcon);
        }

        public String getPassword() {
            return new String(this.passwordField.getPassword());
        }

        public void setEnablePassword(boolean enableState) {
            this.label.setEnabled(enableState);
            this.passwordField.setEnabled(enableState);
            if (enableState && this.registration == null) {
                this.registration = this.bindTextPicker();
            } else if (!enableState && this.registration != null) {
                this.registration.removeRegistration();
                this.registration = null;
            }
        }

        public void clear() {
            this.passwordField.setText("");
        }

        private BindingRegistration bindTextPicker() {
            return TextFieldUtils.bindTextPicker((JComponent)this.passwordField, (TextHolder)new TextHolder(){

                public String getText() {
                    return new String(passwordField.getPassword());
                }

                public void setText(String text) {
                    passwordField.setText(text);
                }
            }, (CompletedListener)this.passwordCompletedListener, (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
        }
    }
}

