/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.useraccess;

import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.DisplayMessageFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.java.balloontip.BalloonTip;

public class UserFeedbackMessages {
    private static final Object BALLOON_MESSAGE = DisplayMessageFactory.class;
    private static final String MESSAGE_IS_IGNORED = "";
    private final TextResource textResource;
    public final String passwordHeader;
    public final String passwordDescription;
    public final String extraWarningText;
    public final String adminPasswordWarning;
    public final String changePermissionsPages;
    private final String successBalloonText;

    public UserFeedbackMessages(TextResource textResource, String passwordHeader, String passwordDescription, String successBalloonText, String extraWarningText, String adminPasswordWarning, String changePermissionsPages) {
        this.textResource = textResource;
        this.passwordHeader = passwordHeader;
        this.passwordDescription = passwordDescription;
        this.successBalloonText = successBalloonText;
        this.extraWarningText = extraWarningText;
        this.adminPasswordWarning = adminPasswordWarning;
        this.changePermissionsPages = changePermissionsPages;
    }

    public void passwordSuccessfullySet(JButton applyPassword) {
        if (this.successBalloonText == null) {
            return;
        }
        this.briefMessageToUser(applyPassword, this.successBalloonText);
    }

    public void wrongPassword(JPasswordField currentPassword) {
        this.briefErrorToUser(currentPassword, this.textResource.wrongPassword());
    }

    public void passwordsDoNotMatch(JPasswordField confirmPassword) {
        this.briefErrorToUser(confirmPassword, this.textResource.passwordsDoNotMatch());
    }

    public void failedToSetPassword(JButton applyPassword) {
        this.briefErrorToUser(applyPassword, this.textResource.failedToSetPassword());
    }

    public void clearMessages(JComponent ... components) {
        for (JComponent component : components) {
            component.putClientProperty(BALLOON_MESSAGE, null);
            if (!(component instanceof JTextField)) continue;
            component.setBackground(DisplayMessageFactory.OK_COLOR);
        }
    }

    public void briefMessageToUser(JComponent component, String message) {
        component.putClientProperty(BALLOON_MESSAGE, message);
        BalloonTip.AttachLocation attachLocation = BalloonTip.AttachLocation.EAST;
        DisplayMessageFactory.messageWithTitle((JComponent)component, (String)message, (String)MESSAGE_IS_IGNORED, (BalloonTip.AttachLocation)attachLocation);
    }

    private void briefErrorToUser(JComponent component, String message) {
        component.putClientProperty(BALLOON_MESSAGE, message);
        DisplayMessageFactory.error((JComponent)component, (String)message);
    }

    public void messageToUser(JComponent component, String title, String message) {
        component.putClientProperty(BALLOON_MESSAGE, message);
        BalloonTip.AttachLocation attachLocation = BalloonTip.AttachLocation.EAST;
        DisplayMessageFactory.messageWithTitleCloseOnlyOnClick((JComponent)component, (String)title, (String)message, (BalloonTip.AttachLocation)attachLocation);
    }
}

