/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.ur.lang.Defense;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.impl.XStreamReader;
import com.ur.polyscope.persistence.impl.XStreamWriter;

class ConverterWrapper<T>
implements Converter {
    private final ConversionStrategy<T> conversionStrategy;
    private final Mapper mapper;

    public ConverterWrapper(ConversionStrategy<T> conversionStrategy, Mapper mapper) {
        Defense.notNull(conversionStrategy, (String)"Must provide a ConversionStrategy");
        this.conversionStrategy = conversionStrategy;
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return this.conversionStrategy.getSupportedType().isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.conversionStrategy.marshal(this.conversionStrategy.getSupportedType().cast(source), (PersistWriter)new XStreamWriter(writer, context, this.mapper));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.conversionStrategy.unmarshal((PersistReader)new XStreamReader(reader, context, this.mapper));
    }
}

