/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.InvalidReference;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.UnableToConvertValue;
import com.ur.polyscope.persistence.impl.ConverterWrapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.UUID;

class XStreamReader
implements PersistReader {
    private final HierarchicalStreamReader reader;
    private final UnmarshallingContext context;
    private final Mapper mapper;

    public XStreamReader(HierarchicalStreamReader reader, UnmarshallingContext context, Mapper mapper) {
        this.reader = reader;
        this.context = context;
        this.mapper = mapper;
    }

    public boolean hasMoreNodes() {
        return this.reader.hasMoreChildren();
    }

    public void moveToChildNode() {
        this.reader.moveDown();
    }

    public void moveToParentNode() {
        this.reader.moveUp();
    }

    public void nextNode() {
        this.moveToChildNode();
        this.moveToParentNode();
    }

    public boolean isNode(String named) {
        return EqualsUtil.equals((Object)named, (Object)this.reader.getNodeName());
    }

    public String getNodeName() {
        return this.reader.getNodeName();
    }

    public double getDoubleValue() {
        return PrimitiveUtils.parseDouble((String)this.reader.getValue(), (double)0.0);
    }

    public double[] getDoubleArrayValue() {
        return PrimitiveUtils.parseDoubleArray((String[])this.getArrayValue("double"));
    }

    public boolean[] getBooleanArrayValue() {
        return PrimitiveUtils.parseBooleanArray((String[])this.getArrayValue("boolean"));
    }

    public String[] getStringArrayValue() {
        return this.getArrayValue("string");
    }

    public int[] getIntegerArrayValue() {
        return PrimitiveUtils.parseIntegerArray((String[])this.getArrayValue("int"));
    }

    private String[] getArrayValue(String name) {
        ArrayList<String> result = new ArrayList<String>();
        this.moveToChildNode();
        while (this.isNode(name)) {
            result.add(this.getStringValue());
            this.moveToParentNode();
            if (!this.hasMoreNodes()) continue;
            this.moveToChildNode();
        }
        return result.toArray(new String[0]);
    }

    public boolean getBooleanValue() {
        return PrimitiveUtils.parseBoolean((String)this.reader.getValue(), (boolean)false);
    }

    public char getCharValue() {
        String value = this.reader.getValue();
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new IllegalStateException("Character value must be of length 1 but was of length " + value.length());
    }

    public String getStringValue() {
        return this.reader.getValue();
    }

    public Options getOptionsValue() {
        Options options = new Options();
        options.load((Reader)new StringReader(this.getStringValue()));
        return options;
    }

    public <T extends Enum<T>> T getEnumValue(Class<T> type) {
        String enumValue = this.getStringValue();
        if (StringUtils.isNullOrOnlyWhitespace((String)enumValue)) {
            return null;
        }
        return Enum.valueOf(type, enumValue);
    }

    public int getIntegerValue() {
        String intValue = this.getStringValue();
        return PrimitiveUtils.parseInteger((String)intValue, (int)0);
    }

    public boolean hasOneOfAttributes(String ... names) {
        for (String each : names) {
            if (this.reader.getAttribute(each) == null) continue;
            return true;
        }
        return false;
    }

    public boolean getBooleanAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseBoolean((String)value, (boolean)false);
    }

    public boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        String value = this.reader.getAttribute(attribute);
        return value == null ? defaultValue : PrimitiveUtils.parseBoolean((String)value, (boolean)defaultValue);
    }

    public float getFloatAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseFloat((String)value, (float)0.0f);
    }

    public float getFloatAttribute(String attribute, float defaultValue) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseFloat((String)value, (float)defaultValue);
    }

    public double getDoubleAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseDouble((String)value, (double)0.0);
    }

    public double getDoubleAttribute(String attribute, double defaultValue) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseDouble((String)value, (double)defaultValue);
    }

    public char getCharAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        if (value != null && value.length() == 1) {
            return value.charAt(0);
        }
        throw new IllegalStateException("Character value must be of length 1 but was of length " + (value == null ? "null" : Integer.valueOf(value.length())));
    }

    public String getStringAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        return value;
    }

    public double[] getDoubleArrayValueAttribute() {
        return this.getDoubleArrayAttribute("value");
    }

    public boolean[] getBooleanArrayValueAttribute() {
        return this.getBooleanArrayAttribute("value");
    }

    public int[] getIntegerArrayValueAttribute() {
        return this.getIntegerArrayAttribute("value");
    }

    public String[] getStringValueArray() {
        return this.getStringArray("value");
    }

    public double[] getDoubleArrayAttribute(String attribute) {
        String valuesAsString = this.reader.getAttribute(attribute);
        if (valuesAsString == null) {
            return null;
        }
        String[] values = StringUtils.split((String)", ", (String)valuesAsString);
        return PrimitiveUtils.parseDoubleArray((String[])values);
    }

    public double[] getDoubleArrayAttribute(String attribute, double[] defaultValue) {
        String valuesAsString = this.reader.getAttribute(attribute);
        if (valuesAsString != null) {
            String[] values = StringUtils.split((String)", ", (String)valuesAsString);
            return PrimitiveUtils.parseDoubleArray((String[])values);
        }
        return defaultValue;
    }

    public boolean[] getBooleanArrayAttribute(String attribute) {
        String valuesAsString = this.reader.getAttribute(attribute);
        if (valuesAsString == null) {
            return null;
        }
        String[] values = StringUtils.split((String)", ", (String)valuesAsString);
        return PrimitiveUtils.parseBooleanArray((String[])values);
    }

    public int[] getIntegerArrayAttribute(String attribute) {
        String valuesAsString = this.reader.getAttribute(attribute);
        if (valuesAsString == null) {
            return null;
        }
        String[] values = StringUtils.split((String)", ", (String)valuesAsString);
        return PrimitiveUtils.parseIntegerArray((String[])values);
    }

    public String[] getStringArray(String attribute) {
        return StringUtils.split((String)", ", (String)this.reader.getAttribute(attribute));
    }

    public <T extends Enum<T>> T getEnumAttribute(String attribute, Class<T> type) {
        String enumName = this.reader.getAttribute(attribute);
        try {
            return Enum.valueOf(type, enumName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends Enum<T>> T getEnumAttribute(String attribute, Class<T> type, T defaultValue) {
        String enumName = this.reader.getAttribute(attribute);
        try {
            return enumName != null ? Enum.valueOf(type, enumName) : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public <T extends Enum<T>> T[] getEnumArrayAttribute(Class<T> type) {
        String array = this.reader.getAttribute("value");
        if (array == null) {
            return null;
        }
        String[] values = StringUtils.split((String)", ", (String)array);
        return PrimitiveUtils.parseEnumArray((String[])values, type);
    }

    public UUID getUUIDAttribute(String attribute, UUID defaultUUID) {
        try {
            String value = this.reader.getAttribute(attribute);
            return UUID.fromString(value);
        }
        catch (Exception e) {
            return defaultUUID;
        }
    }

    public int getIntegerAttribute(String attribute) {
        String value = this.reader.getAttribute(attribute);
        return PrimitiveUtils.parseInteger((String)value, (int)0);
    }

    public Class<?> getRequiredType() {
        Class<?> result = this.context.getRequiredType();
        Class<?> nodeType = this.getTypeOfCurrentNode();
        if (nodeType != null && result.isAssignableFrom(nodeType)) {
            result = nodeType;
        }
        return result;
    }

    public <T> T convertContainedValue(Class<T> type) {
        try {
            return this.convertContainedValue(null, type);
        }
        catch (ConversionException ce) {
            if (ce.getShortMessage().contains("Invalid reference")) {
                throw new InvalidReference((RuntimeException)((Object)ce));
            }
            throw new UnableToConvertValue((RuntimeException)((Object)ce), type);
        }
    }

    public <T> T convertContainedValue(Object current, Class<T> type) {
        Class<?> nodeType = this.getTypeOfCurrentNode();
        if (nodeType != null && type.isAssignableFrom(nodeType)) {
            return (T)this.context.convertAnother(current, nodeType);
        }
        return (T)this.context.convertAnother(current, type);
    }

    public <T> T convertContainedValue(Object current, Class<T> type, ConversionStrategy<T> converter) {
        Class<?> nodeType = this.getTypeOfCurrentNode();
        if (nodeType != null && type.isAssignableFrom(nodeType)) {
            return (T)this.context.convertAnother(current, nodeType, new ConverterWrapper<T>(converter, this.mapper));
        }
        return (T)this.context.convertAnother(current, type, new ConverterWrapper<T>(converter, this.mapper));
    }

    public <T> T readValueFromChildNode(Class<T> type) {
        this.moveToChildNode();
        T result = this.convertContainedValue(type);
        this.moveToParentNode();
        return result;
    }

    public <T> T readValueFromChildNode(Object current, Class<T> type) {
        this.moveToChildNode();
        T result = this.convertContainedValue(current, type);
        this.moveToParentNode();
        return result;
    }

    private Class<?> getTypeOfCurrentNode() {
        String alias = this.getStringAttribute("resolves-to");
        if (alias == null) {
            alias = this.getStringAttribute("class");
        }
        if (alias == null) {
            alias = this.reader.getNodeName();
        }
        try {
            return this.mapper.realClass(alias);
        }
        catch (Exception e) {
            return null;
        }
    }
}

