/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.Serialization;
import com.ur.polyscope.persistence.impl.ConverterWrapper;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class XStreamSerialization
implements Serialization {
    private final XStream xstream;
    private final boolean forMarshalling;

    public XStreamSerialization(boolean forMarshalling) {
        this.forMarshalling = forMarshalling;
        this.xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.xstream.allowTypesByWildcard(new String[]{"com.ur.**", "gui.program.**"});
    }

    public void fromClass(Class<?> clazz) {
        this.xstream.setClassLoader(clazz.getClassLoader());
    }

    public <T> void registerConversionStrategy(ConversionStrategy<T> strategy) {
        this.xstream.registerConverter(new ConverterWrapper<T>(strategy, this.xstream.getMapper()));
        for (Map.Entry each : strategy.getClassAliases(this.forMarshalling).entrySet()) {
            this.xstream.alias((String)each.getKey(), (Class)each.getValue());
        }
        for (Map.Entry each : strategy.getTypeAliases(this.forMarshalling).entrySet()) {
            this.xstream.aliasType((String)each.getKey(), (Class)each.getValue());
        }
    }

    @Deprecated
    public void omitField(Class<?> definedIn, String fieldName) {
        this.xstream.omitField(definedIn, fieldName);
    }

    @Deprecated
    public void alias(String name, Class<?> type) {
        this.xstream.alias(name, type);
    }

    public void toXML(Object toMarshal, Writer writer) {
        this.xstream.toXML(toMarshal, writer);
    }

    public String toXML(Object toMarshal) {
        return this.xstream.toXML(toMarshal);
    }

    public Object fromXML(Reader reader) {
        return this.xstream.fromXML(reader);
    }

    public Object fromXML(String xml) {
        return this.xstream.fromXML(xml);
    }
}

