/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.ur.lang.StringUtils;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.impl.ConverterWrapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;

class XStreamWriter
implements PersistWriter {
    public static final String TYPE_ATTRIBUTE = "class";
    public static final String VALUE_ATTRIBUTE = "value";
    private final HierarchicalStreamWriter writer;
    private final MarshallingContext context;
    private final Mapper mapper;

    public XStreamWriter(HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        this.writer = writer;
        this.context = context;
        this.mapper = mapper;
    }

    public void startNode(String name) {
        this.writer.startNode(name);
    }

    public void endNode() {
        this.writer.endNode();
    }

    @Deprecated
    public void addEmptyAttribute(String attribute) {
        this.writer.addAttribute(attribute, "");
    }

    public void addAttribute(String attribute, boolean value) {
        this.writer.addAttribute(attribute, "" + value);
    }

    public void addAttribute(String attribute, double value) {
        this.writer.addAttribute(attribute, "" + value);
    }

    public void addAttribute(String attribute, int value) {
        this.writer.addAttribute(attribute, "" + value);
    }

    public void addAttribute(String attribute, char value) {
        this.writer.addAttribute(attribute, "" + value);
    }

    public void addAttribute(String attribute, String value) {
        if (!StringUtils.isNullOrEmpty((String)value)) {
            this.writer.addAttribute(attribute, value);
        }
    }

    public void addAttribute(String attribute, double[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(attribute, StringUtils.joinStringsWith((String)", ", (double[])values));
    }

    public void addAttribute(String attribute, boolean[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(attribute, StringUtils.joinStringsWith((String)", ", (boolean[])values));
    }

    public void addAttribute(String attribute, int[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(attribute, StringUtils.joinStringsWith((String)", ", (int[])values));
    }

    public void addAttribute(String attribute, String[] values) {
        if (values == null) {
            return;
        }
        this.writer.addAttribute(attribute, StringUtils.joinStringsWith((String)", ", (Object[])values));
    }

    public void addAttribute(String attribute, Enum<?> type) {
        if (type == null) {
            this.writer.addAttribute(attribute, "");
        } else {
            this.writer.addAttribute(attribute, type.name());
        }
    }

    public void addAttribute(String attribute, UUID value) {
        this.writer.addAttribute(attribute, value == null ? "" : value.toString());
    }

    public void createNodeWithValueAttribute(String name, double[] values) {
        if (values == null) {
            return;
        }
        this.startNode(name);
        this.addAttribute(VALUE_ATTRIBUTE, values);
        this.endNode();
    }

    public void createNodeWithValueAttribute(String name, boolean[] values) {
        if (values == null) {
            return;
        }
        this.startNode(name);
        this.addAttribute(VALUE_ATTRIBUTE, values);
        this.endNode();
    }

    public void createNodeWithValueAttribute(String name, int[] values) {
        if (values == null) {
            return;
        }
        this.startNode(name);
        this.addAttribute(VALUE_ATTRIBUTE, values);
        this.endNode();
    }

    public void createNodeWithValueAttribute(String name, String[] values) {
        if (values == null) {
            return;
        }
        this.startNode(name);
        this.addAttribute(VALUE_ATTRIBUTE, values);
        this.endNode();
    }

    public void writeContainedValue(Object toMarshal) {
        this.context.convertAnother(toMarshal);
    }

    public <T> void writeContainedValue(T toMarshal, ConversionStrategy<T> conversionStrategy) {
        this.context.convertAnother(toMarshal, new ConverterWrapper<T>(conversionStrategy, this.mapper));
    }

    public void addValue(String text) {
        this.writer.setValue(text);
    }

    public void addValue(Options options) {
        StringWriter stringWriter = new StringWriter();
        options.save((Writer)stringWriter);
        this.addValue("\n" + ((Object)stringWriter).toString());
    }

    @Deprecated
    public void createNodeWithValue(String nodeName, String value) {
        this.startNode(nodeName);
        this.writer.setValue(value);
        this.endNode();
    }

    public void writeNodeWithValue(Object value) {
        if (value != null) {
            this.startNode(this.mapper.serializedClass(value.getClass()));
            this.writeContainedValue(value);
            this.endNode();
        }
    }

    public void writeNodeWithValue(String elementName, Object value) {
        if (value != null) {
            this.startNode(elementName);
            this.writeContainedValue(value);
            this.endNode();
        }
    }

    public void writeNodeWithTypeAndValue(String elementName, Object value) {
        if (value != null) {
            this.startNode(elementName);
            this.addAttribute(TYPE_ATTRIBUTE, this.mapper.serializedClass(value.getClass()));
            this.writeContainedValue(value);
            this.endNode();
        }
    }
}

