/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl.compressed;

import com.ur.polyscope.persistence.compressed.CompressionFactory;
import com.ur.polyscope.persistence.compressed.DeflateProgress;
import com.ur.polyscope.persistence.compressed.Deflater;
import com.ur.polyscope.persistence.compressed.DeflaterConfiguration;
import com.ur.polyscope.persistence.compressed.DeflaterSource;
import com.ur.polyscope.persistence.impl.compressed.DeflateProgressComposite;
import com.ur.polyscope.persistence.impl.compressed.DeflaterConfigurationImpl;
import com.ur.polyscope.persistence.impl.compressed.DeflaterImpl;
import com.ur.polyscope.persistence.impl.compressed.DeflaterSourceImpl;
import com.ur.polyscope.persistence.impl.compressed.deflaterrunners.DeflaterRunner;
import com.ur.polyscope.persistence.impl.compressed.deflaterrunners.ZipDeflaterRunner;
import java.util.List;

public class CompressionFactoryImpl
implements CompressionFactory {
    public DeflaterConfiguration getDeflaterConfiguration() {
        return new DeflaterConfigurationImpl();
    }

    public DeflaterSource getDeflaterSource() {
        return new DeflaterSourceImpl();
    }

    public Deflater getDeflater(DeflaterConfiguration configuration) {
        DeflaterRunner deflaterRunner;
        DeflaterConfiguration copyConfiguration = this.getDeflaterConfiguration().setCompressionLevel(configuration.getCompressionLevel()).setCompressionType(configuration.getCompressionType()).setIsSynchronous(configuration.isSynchronous()).setOutputStream(configuration.getOutputStream());
        switch (configuration.getCompressionType()) {
            case ZIP: {
                deflaterRunner = new ZipDeflaterRunner();
                break;
            }
            default: {
                deflaterRunner = new DeflaterRunner.Template();
            }
        }
        deflaterRunner.init(copyConfiguration);
        return new DeflaterImpl(copyConfiguration, deflaterRunner);
    }

    public DeflateProgress compositeDeflateProgress(List<DeflateProgress> progresses) {
        DeflateProgressComposite compound = new DeflateProgressComposite();
        for (DeflateProgress progress : progresses) {
            compound.addDeflateProgress(progress);
        }
        return compound;
    }
}

