/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl.compressed;

import com.ur.polyscope.persistence.compressed.CompressionProgressState;
import com.ur.polyscope.persistence.compressed.DeflateProgress;
import java.util.ArrayList;
import java.util.List;

public class DeflateProgressComposite
implements DeflateProgress {
    private final List<DeflateProgress> statusList = new ArrayList<DeflateProgress>();

    void addDeflateProgress(DeflateProgress appendableStatus) {
        this.statusList.add(appendableStatus);
    }

    public CompressionProgressState getProgressState() {
        CompressionProgressState currentStatus = CompressionProgressState.COMPLETED;
        for (DeflateProgress status : this.statusList) {
            currentStatus = this.getPrioritizedStatus(currentStatus, status.getProgressState());
        }
        return currentStatus;
    }

    public int getPercentageComplete() {
        int total = 0;
        for (DeflateProgress status : this.statusList) {
            total += status.getPercentageComplete();
        }
        return total / this.statusList.size();
    }

    private CompressionProgressState getPrioritizedStatus(CompressionProgressState left, CompressionProgressState right) {
        if (left == CompressionProgressState.FAILED || right == CompressionProgressState.FAILED) {
            return CompressionProgressState.FAILED;
        }
        if (left == CompressionProgressState.IN_PROGRESS || right == CompressionProgressState.IN_PROGRESS) {
            return CompressionProgressState.IN_PROGRESS;
        }
        if (left == CompressionProgressState.QUEUED || right == CompressionProgressState.QUEUED) {
            return CompressionProgressState.QUEUED;
        }
        return CompressionProgressState.COMPLETED;
    }
}

