/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl.compressed;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.persistence.compressed.DeflateProgress;
import com.ur.polyscope.persistence.compressed.Deflater;
import com.ur.polyscope.persistence.compressed.DeflaterConfiguration;
import com.ur.polyscope.persistence.compressed.DeflaterSource;
import com.ur.polyscope.persistence.impl.compressed.DeflateProgressImpl;
import com.ur.polyscope.persistence.impl.compressed.DeflaterSourceImpl;
import com.ur.polyscope.persistence.impl.compressed.SameThreadExecutor;
import com.ur.polyscope.persistence.impl.compressed.deflaterrunners.DeflaterRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeflaterImpl
implements Deflater {
    private static final Logger LOG = LogFactory.createLogger(DeflaterImpl.class);
    private static final String SOURCES_DEFLATER_IS_CLOSED = "Cannot append more sources. Deflater is closed!";
    private final DeflaterRunner runner;
    private ExecutorService executor;
    private AtomicBoolean closed = new AtomicBoolean(false);

    DeflaterImpl(DeflaterConfiguration configuration, DeflaterRunner runner) {
        this.runner = runner;
        this.executor = configuration.isSynchronous() ? new SameThreadExecutor() : Executors.newSingleThreadExecutor();
    }

    public DeflateProgress appendSource(DeflaterSource source) {
        this.isNotClosed();
        return this.addTask(source);
    }

    public List<DeflateProgress> appendSources(List<DeflaterSource> sources) {
        this.isNotClosed();
        ArrayList<DeflateProgress> result = new ArrayList<DeflateProgress>();
        for (DeflaterSource source : sources) {
            result.add(this.addTask(source));
        }
        return result;
    }

    private DeflateProgressImpl addTask(DeflaterSource source) {
        DeflateProgressImpl deflateProgress = new DeflateProgressImpl();
        DeflaterSource sourceCopy = new DeflaterSourceImpl().setSource(source.getSource()).setTargetFileName(source.getTargetFileName()).setTargetDirectoryPath(source.getTargetDirectoryPath());
        Runnable runnable = this.runner.appendSource(deflateProgress, sourceCopy);
        this.executor.submit(runnable);
        return deflateProgress;
    }

    private void isNotClosed() {
        if (this.closed.get()) {
            LOG.error(SOURCES_DEFLATER_IS_CLOSED, new Object[0]);
            throw new IllegalStateException(SOURCES_DEFLATER_IS_CLOSED);
        }
    }

    public void close() {
        this.closed.set(true);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                DeflaterImpl.this.runner.done();
            }
        });
    }
}

