/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.persistence.impl.compressed.deflaterrunners;

import com.ur.lang.IOUtil;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.persistence.compressed.CompressionLevel;
import com.ur.polyscope.persistence.compressed.CompressionProgressState;
import com.ur.polyscope.persistence.compressed.DeflaterConfiguration;
import com.ur.polyscope.persistence.compressed.DeflaterSource;
import com.ur.polyscope.persistence.impl.compressed.DeflateProgressImpl;
import com.ur.polyscope.persistence.impl.compressed.deflaterrunners.DeflaterRunner;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipDeflaterRunner
implements DeflaterRunner {
    private static final Map<CompressionLevel, Integer> COMPRESSION_LEVELS = ZipDeflaterRunner.createCompressionLevelMap();
    private static final Logger LOG = LogFactory.createLogger(ZipDeflaterRunner.class);
    private static final int READ_BUFFER_SIZE = 8192;
    private static final int WRITE_BUFFER_SIZE = 65536;
    private final byte[] buffer = new byte[8192];
    private ZipOutputStream zos;

    @Override
    public DeflaterRunner init(DeflaterConfiguration configuration) {
        this.zos = new ZipOutputStream(new BufferedOutputStream(configuration.getOutputStream(), 65536));
        this.zos.setLevel(COMPRESSION_LEVELS.get(configuration.getCompressionLevel()));
        return this;
    }

    @Override
    public void done() {
        IOUtil.close((Closeable)this.zos);
    }

    @Override
    public Runnable appendSource(DeflateProgressImpl deflateProgress, DeflaterSource source) {
        return new ZipDeflaterRunnable(deflateProgress, source);
    }

    private static Map<CompressionLevel, Integer> createCompressionLevelMap() {
        EnumMap<CompressionLevel, Integer> map = new EnumMap<CompressionLevel, Integer>(CompressionLevel.class);
        map.put(CompressionLevel.LOW, 1);
        map.put(CompressionLevel.NORMAL, 5);
        map.put(CompressionLevel.HIGH, 9);
        return map;
    }

    private class ZipDeflaterRunnable
    implements Runnable {
        private final DeflateProgressImpl deflateProgressImpl;
        private final DeflaterSource source;

        ZipDeflaterRunnable(DeflateProgressImpl deflateProgressImpl, DeflaterSource source) {
            this.deflateProgressImpl = deflateProgressImpl;
            this.source = source;
        }

        @Override
        public void run() {
            this.deflateProgressImpl.setProgressStatus(CompressionProgressState.IN_PROGRESS);
            InputStream inputStream = null;
            try {
                int count;
                ZipEntry ze = new ZipEntry(this.source.getTargetDirectoryPath() + File.separator + this.source.getTargetFileName());
                ZipDeflaterRunner.this.zos.putNextEntry(ze);
                int accumulated = 0;
                long streamSize = this.source.getSource().size();
                inputStream = this.source.getSource().openBufferedStream();
                while ((count = inputStream.read(ZipDeflaterRunner.this.buffer)) > 0) {
                    ZipDeflaterRunner.this.zos.write(ZipDeflaterRunner.this.buffer, 0, count);
                    this.updatePercentage(accumulated += count, streamSize);
                }
                this.deflateProgressImpl.setPercentageComplete(100);
                this.deflateProgressImpl.setProgressStatus(CompressionProgressState.COMPLETED);
                IOUtil.close((Closeable)inputStream);
            }
            catch (IOException e) {
                LOG.error("Deflating failed!", (Throwable)e);
                IOUtil.close(inputStream);
                this.deflateProgressImpl.setProgressStatus(CompressionProgressState.FAILED);
            }
        }

        private void updatePercentage(long accumulated, long totalSize) {
            int percentage = (int)(accumulated * 100L / totalSize);
            if (percentage > 100) {
                percentage = 100;
            }
            this.deflateProgressImpl.setPercentageComplete(percentage);
        }
    }
}

