/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry;

import com.google.inject.util.Providers;
import com.ur.controllerinterface.i18n.ControllerTextResource;
import com.ur.controllerinterface.i18n.MessageCodesResource;
import com.ur.controllerinterface.i18n.RuntimeExceptionsResource;
import com.ur.controllerinterface.i18n.impl.ControllerTextResourceImpl;
import com.ur.controllerinterface.i18n.impl.MessageCodesResourceImpl;
import com.ur.controllerinterface.i18n.impl.RuntimeExceptionsResourceImpl;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.resources.LocaleProvider;
import com.ur.log.logentry.internal.ProgramRuntimeMessageProvider;
import com.ur.log.logentry.internal.Settings;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.logging.i18n.TextResource;
import com.ur.polyscope.logging.i18n.impl.TextResourceImpl;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.SafetyMode;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Provider;

@Deprecated
public class LanguagePack
implements ServicesBinder {
    public static final String CODE = "CODE_";
    public static final String A = "A";
    private static MessageCodesResource messageCodesBundle = null;
    private static TextResource textBundle = null;
    private static ControllerTextResource controllerKeyTextBundle = null;
    private static RuntimeExceptionsResource runtimeExceptionsBundle = null;
    private static final Map<SafetyMode, String> safetyModeTextMap = new EnumMap<SafetyMode, String>(SafetyMode.class);

    public void bind(Binder binder) {
        binder.bindProvider(MessageCodesResource.class, (Provider)Providers.of((Object)messageCodesBundle));
        binder.bindProvider(TextResource.class, (Provider)Providers.of((Object)textBundle));
        binder.bindProvider(ControllerTextResource.class, (Provider)Providers.of((Object)controllerKeyTextBundle));
        binder.bindProvider(RuntimeExceptionsResource.class, (Provider)Providers.of((Object)runtimeExceptionsBundle));
        binder.bindInstance(LocaleProvider.class, Locale::getDefault);
    }

    public void load(Builder builder) {
    }

    public static void setLanguage(Locale locale) {
        LanguageFileReaderLocaleProvider provider = new LanguageFileReaderLocaleProvider(locale);
        messageCodesBundle = new MessageCodesResourceImpl(provider);
        textBundle = new TextResourceImpl(provider);
        controllerKeyTextBundle = new ControllerTextResourceImpl(provider);
        runtimeExceptionsBundle = new RuntimeExceptionsResourceImpl(provider);
    }

    public static void testingForceEnglish() {
        Locale.setDefault(Locale.ENGLISH);
        LanguagePack.setLanguage(Locale.ENGLISH);
    }

    public static boolean hasArgumentWithTranslation(ErrorCode code, int argument) {
        String key = CODE + code.getId() + A + argument;
        String string = messageCodesBundle.get(key);
        return !string.startsWith("!");
    }

    public static String getMessageCodeArgument(int code, int argument) {
        String key = CODE + code + A + argument;
        String string = messageCodesBundle.get(key);
        if (string.startsWith("!") && Settings.isRunningInDevelopmentMode()) {
            Log.error((String)("This is an invalid argument code: " + key + "\n\tMake sure this has been added to the ur_gui_message_codes.properties file.\n\tIf the argument is meant as a joint, make sure the RobotMessage.getStringForMessageCode(..) handles this special."));
        }
        return string;
    }

    public static String getMessageCodeArgument(ErrorCode code, int argument) {
        String key = CODE + code.getId() + A + argument;
        String string = messageCodesBundle.get(key);
        if (string.startsWith("!") && Settings.isRunningInDevelopmentMode()) {
            Log.error((String)("This is an invalid argument code: " + key + "\n\tMake sure this has been added to the ur_gui_message_codes.properties file.'\n\tIf the argument is meant as a joint, make sure the RobotMessage.getStringForMessageCode(..) handles this special."));
        }
        return string;
    }

    public static String getMessageCodeArgument(int code, String argument) {
        return messageCodesBundle.get(CODE + code + A + argument);
    }

    public static String getMessageCodeArgument(ErrorCode code, String argument) {
        return messageCodesBundle.get(CODE + code.getId() + A + argument);
    }

    public static String getMessageCode(int code, int argument) {
        return "C" + code + A + argument + ": " + messageCodesBundle.get(CODE + code);
    }

    public static String getMessageCode(ErrorCode code, int argument) {
        return "C" + code.getId() + A + argument + ": " + messageCodesBundle.get(CODE + code.getId());
    }

    public static String getFriendlyMessageCodeExplanation(int code, int argument) {
        String lookupName = CODE + code + A + argument + "_explanation";
        if (messageCodesBundle.contains(lookupName)) {
            return messageCodesBundle.get(lookupName);
        }
        return messageCodesBundle.get(CODE + code + "_explanation");
    }

    public static String getFriendlyMessageCodeSuggestion(int code, int argument) {
        String lookupName = CODE + code + A + argument + "_suggestion";
        if (messageCodesBundle.contains(lookupName)) {
            return messageCodesBundle.get(lookupName);
        }
        return messageCodesBundle.get(CODE + code + "_suggestion");
    }

    public static TextResource getTextResource() {
        return textBundle;
    }

    public static ProgramRuntimeMessageProvider getProgramRuntimeMessageProvider() {
        return new ProgramRuntimeMessageProvider(runtimeExceptionsBundle);
    }

    @Deprecated
    public static String getText(String key) {
        if (key == null) {
            if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
                Log.warning((String)"Key was given that was null", (Throwable)new Exception());
            }
            return "";
        }
        return textBundle.get(key);
    }

    public static String getControllerKeyText(String key) {
        return controllerKeyTextBundle.get(key);
    }

    public static String getMasterboardSafetyStateText(SafetyMode safetyMode) {
        LanguagePack.setupSafetyModeTextMap();
        String safetyModeText = safetyModeTextMap.get(safetyMode);
        if (safetyModeText != null) {
            return safetyModeText;
        }
        throw new IllegalStateException("The following safety mode has not been translated" + safetyMode.name());
    }

    private static void setupSafetyModeTextMap() {
        safetyModeTextMap.put(SafetyMode.NORMAL, LanguagePack.getTextResource().safetyModeNormal());
        safetyModeTextMap.put(SafetyMode.REDUCED, LanguagePack.getTextResource().safetyModeReduced());
        safetyModeTextMap.put(SafetyMode.SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeSafeguardStop());
        safetyModeTextMap.put(SafetyMode.PROTECTIVE_STOP, LanguagePack.getTextResource().safetyModeProtectiveStop());
        safetyModeTextMap.put(SafetyMode.SYSTEM_EMERGENCY_STOP, LanguagePack.getTextResource().safetyModeSystemEmergencyStop());
        safetyModeTextMap.put(SafetyMode.ROBOT_EMERGENCY_STOP, LanguagePack.getTextResource().safetyModeRobotEmergencyStop());
        safetyModeTextMap.put(SafetyMode.VIOLATION, LanguagePack.getTextResource().safetyModeViolation());
        safetyModeTextMap.put(SafetyMode.FAULT, LanguagePack.getTextResource().safetyModeFault());
        safetyModeTextMap.put(SafetyMode.RECOVERY, LanguagePack.getTextResource().safetyModeRecovery());
        safetyModeTextMap.put(SafetyMode.VALIDATE_JOINT_ID, LanguagePack.getTextResource().jointsVerification());
        safetyModeTextMap.put(SafetyMode.UNDEFINED_SAFETY_MODE, "");
        safetyModeTextMap.put(SafetyMode.AUTOMATIC_MODE_SAFEGUARD_STOP, LanguagePack.getTextResource().automaticModeSafeguardStop());
        safetyModeTextMap.put(SafetyMode.SYSTEM_THREE_POSITION_ENABLING_STOP, LanguagePack.getTextResource().systemThreePositionEnablingStop());
        safetyModeTextMap.put(SafetyMode.TP_THREE_POSITION_ENABLING_STOP, LanguagePack.getTextResource().tpThreePositionEnablingStop());
        safetyModeTextMap.put(SafetyMode.IMMI_EMERGENCY_STOP, LanguagePack.getTextResource().safetyModeImmiEmergencyStop());
        safetyModeTextMap.put(SafetyMode.IMMI_SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeImmiSafeguardStop());
        safetyModeTextMap.put(SafetyMode.PROFISAFE_WAITING_FOR_PARAMETERS, LanguagePack.getTextResource().safetyModeProfisafeWaitingForParameters());
        safetyModeTextMap.put(SafetyMode.PROFISAFE_AUTOMATIC_MODE_SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeProfisafeSafeguardStop());
        safetyModeTextMap.put(SafetyMode.PROFISAFE_SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeProfisafeSafeguardStop());
        safetyModeTextMap.put(SafetyMode.PROFISAFE_EMERGENCY_STOP, LanguagePack.getTextResource().safetyModeProfisafeEmergencyStop());
        safetyModeTextMap.put(SafetyMode.BRAKE_PIN_FAILURE, LanguagePack.getTextResource().safetyModeBrakePinFailure());
        safetyModeTextMap.put(SafetyMode.SAFETY_API_SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeSafetyApiSafeguardStop());
        safetyModeTextMap.put(SafetyMode.SAFETY_PLANES_SAFEGUARD_STOP, LanguagePack.getTextResource().safetyModeSafetyPlanesSafeguardStop());
    }

    static {
        LanguagePack.setLanguage(Locale.ENGLISH);
    }

    public static class LanguageFileReaderLocaleProvider
    implements LocaleProvider {
        private final Locale locale;

        public LanguageFileReaderLocaleProvider(Locale localeRegion) {
            this.locale = localeRegion;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

