/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry;

import com.ur.lang.StringUtils;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.LogEntryAttachmentState;
import com.ur.log.logentry.LogEntryExplanationRenderer;
import com.ur.log.logentry.LogEntryVersion;
import com.ur.log.logentry.internal.LogEntryParser;
import com.ur.log.logentry.robotmessage.Attachment;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.logging.i18n.TextResource;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.ReportLevel;

public class LogEntry {
    public static final LogEntryVersion LATEST_VERSION = LogEntryVersion.LATEST;
    private static final int SOURCE_COLUMN_LENGTH = RobotMessage.maxSourceColumnLength();
    protected final RobotMessage message;
    private final String backwardsSupport;
    private final String friendlyTime;
    private final String technicalTime;
    public final LogEntryVersion version;
    private String suggestion = "";
    private LogEntryAttachmentState attachmentState;
    private String displayMessage;
    private Boolean hasDetails;

    public static LogEntry parse(String logLine) {
        return LogEntryParser.parse(logLine);
    }

    public LogEntry(RobotMessage message, String backwardsSupport, String friendlyTime, String technicalTime, LogEntryVersion version) {
        this.message = message;
        this.friendlyTime = friendlyTime;
        this.technicalTime = technicalTime;
        this.backwardsSupport = backwardsSupport;
        this.version = version;
        this.attachmentState = new LogEntryAttachmentState(message);
    }

    public LogEntry(RobotMessage message, String friendlyTime, String technicalTime, LogEntryVersion version) {
        this.message = message;
        this.friendlyTime = friendlyTime;
        this.technicalTime = technicalTime;
        this.backwardsSupport = null;
        this.version = version;
        this.attachmentState = new LogEntryAttachmentState(message);
    }

    public LogEntry(RobotMessage message, String backwardsSupport, LogEntryVersion version) {
        this.message = message;
        this.friendlyTime = null;
        this.technicalTime = null;
        this.backwardsSupport = backwardsSupport;
        this.version = version;
        this.attachmentState = new LogEntryAttachmentState(message);
    }

    public LogEntry(RobotMessage message, String friendlyTime, String technicalTime) {
        this.message = message;
        this.friendlyTime = friendlyTime;
        this.technicalTime = technicalTime;
        this.backwardsSupport = null;
        this.version = LATEST_VERSION;
        this.attachmentState = new LogEntryAttachmentState(message);
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public ReportLevel getWarningLevel() {
        return this.message.warningLevel;
    }

    public String getDisplay(boolean isTechnicalTime) {
        if (!StringUtils.isNullOrOnlyWhitespace((String)this.backwardsSupport)) {
            return this.backwardsSupport;
        }
        if (this.displayMessage == null) {
            this.displayMessage = " " + StringUtils.padRightWith((String)this.message.getSourceString(), (String)" ", (int)SOURCE_COLUMN_LENGTH) + " " + this.message + "\n";
        }
        return (isTechnicalTime ? this.technicalTime : this.friendlyTime) + this.displayMessage;
    }

    public boolean hasDetails() {
        if (this.hasDetails == null) {
            String codeExplanation = this.getFriendlyMessageCodeExplanation();
            String codeSuggestion = this.getFriendlyMessageCodeSuggestion();
            if (StringUtils.startsAndEndsWith((String)"!", (String)codeExplanation)) {
                codeExplanation = "";
            }
            if (StringUtils.startsAndEndsWith((String)"!", (String)codeSuggestion)) {
                codeSuggestion = this.getSuggestion();
            }
            this.hasDetails = !StringUtils.isNullOrOnlyWhitespace((String)codeExplanation) || !StringUtils.isNullOrOnlyWhitespace((String)codeSuggestion);
        }
        return this.hasDetails;
    }

    public String export() {
        Object extraData = this.message.type == RobotMessageType.RUNTIME_EXCEPTION ? this.suggestion : this.message.extraData;
        return StringUtils.joinStringsWith((String)" :: ", (Object[])new Object[]{this.version, this.technicalTime, this.friendlyTime, this.message.source.getId(), "C" + this.ifUnknownPrintRecievedValue() + "A" + this.message.errorArgument + ":" + this.message.type.getId(), this.message.safetyMode == null ? "null" : Integer.valueOf(this.message.safetyMode.getId()), this.message.warningLevel.getId(), this.message.message, this.message.title, extraData}).replaceAll("[\\n]", " ;; ");
    }

    private String ifUnknownPrintRecievedValue() {
        return ErrorCode.UNKNOWN.equals((Object)this.message.errorCode) ? this.message.getRecievedErrorCodeValue() : Integer.toString(this.message.errorCode.getId());
    }

    public String getTechnicalTime() {
        return this.technicalTime;
    }

    public String getFriendlyMessageCodeExplanation() {
        String text = this.message.type == RobotMessageType.RUNTIME_EXCEPTION ? LanguagePack.getTextResource().RuntimeException() : (this.message.type == RobotMessageType.TEXT ? (this.message.extraData instanceof LogEntryExplanationRenderer ? ((LogEntryExplanationRenderer)this.message.extraData).getExplanation() : this.message.message) : LanguagePack.getFriendlyMessageCodeExplanation(this.message.errorCode.getId(), this.message.errorArgument));
        return text;
    }

    public String getFriendlyMessageCodeSuggestion() {
        if (this.message.type == RobotMessageType.RUNTIME_EXCEPTION) {
            return this.suggestion;
        }
        if (this.message.type == RobotMessageType.TEXT) {
            return this.suggestion;
        }
        String suggestion = LanguagePack.getFriendlyMessageCodeSuggestion(this.message.errorCode.getId(), this.message.errorArgument);
        return this.message.insertErrorMessageDataToMessage(suggestion);
    }

    public String getFriendlyMessageCodeSuggestionLabel(TextResource text) {
        return this.message.type == RobotMessageType.RUNTIME_EXCEPTION ? text.details() : text.suggestion();
    }

    public RobotMessage getMessage() {
        return this.message;
    }

    public LogEntryVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getDisplay(true);
    }

    public boolean isRuntimeException() {
        return this.getMessage().type == RobotMessageType.RUNTIME_EXCEPTION;
    }

    public boolean hasAttachment() {
        return this.getMessage().getAttachment() != null;
    }

    public Attachment getAttachment() {
        return this.getMessage().getAttachment();
    }

    public LogEntryAttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    public boolean isValid() {
        return true;
    }
}

