/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry;

import com.ur.log.logentry.robotmessage.RobotMessage;

public class LogEntryAttachmentState {
    private AttachmentStates state = AttachmentStates.None;
    private final RobotMessage message;

    public LogEntryAttachmentState(RobotMessage message) {
        this.message = message;
        this.setInitialState();
    }

    public AttachmentStates getState() {
        return this.state;
    }

    public boolean hasAttachment() {
        return this.state == AttachmentStates.Pending || this.state == AttachmentStates.Available;
    }

    public boolean noAttachment() {
        return !this.hasAttachment();
    }

    public boolean canExport() {
        return this.state == AttachmentStates.Available;
    }

    public boolean attachmentPending() {
        return this.state == AttachmentStates.Pending;
    }

    public void update() {
        switch (this.state) {
            case Pending: {
                if (!this.message.getAttachment().isAvailable()) break;
                this.state = AttachmentStates.Available;
                break;
            }
            case Available: {
                if (this.message.getAttachment().exportFromStream() != null) break;
                this.state = AttachmentStates.Expired;
                break;
            }
        }
    }

    private void setInitialState() {
        if (this.message == null) {
            this.state = AttachmentStates.None;
            return;
        }
        if (this.message.getAttachment() == null) {
            this.state = AttachmentStates.None;
            return;
        }
        this.state = AttachmentStates.Pending;
        if (this.message.getAttachment().isAvailable()) {
            this.state = AttachmentStates.Available;
        }
    }

    public static enum AttachmentStates {
        None,
        Pending,
        Available,
        Expired;

    }
}

