/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry;

import java.util.HashMap;
import java.util.Map;

public enum LogEntryVersion {
    V_1_8("1.8"),
    V_3_0("3.0"),
    V_3_1("3.1"),
    V_3_5("3.5");

    public static final LogEntryVersion LATEST;
    private static final Map<String, LogEntryVersion> idCache;
    private final String version;

    private LogEntryVersion(String version) {
        this.version = version;
    }

    public static LogEntryVersion tryParse(String version) {
        if (idCache.isEmpty()) {
            LogEntryVersion.buildCache();
        }
        if (idCache.containsKey(version)) {
            return idCache.get(version);
        }
        return null;
    }

    private static void buildCache() {
        for (LogEntryVersion each : LogEntryVersion.values()) {
            idCache.put(each.version, each);
        }
    }

    public String toString() {
        return this.version;
    }

    static {
        LATEST = V_3_5;
        idCache = new HashMap<String, LogEntryVersion>();
    }
}

