/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.internal;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.log.logentry.LogEntry;
import com.ur.log.logentry.LogEntryParserException;
import com.ur.log.logentry.LogEntryVersion;
import com.ur.log.logentry.internal.LogEntryParser_1_8;
import com.ur.log.logentry.internal.LogEntryParser_3_0;
import com.ur.log.logentry.internal.LogEntryParser_3_1;
import com.ur.log.logentry.internal.LogEntryParser_3_5;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.view.constants.comm.RobotMessageType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class LogEntryParser {
    public static final int SOURCE_COLUMN_LENGTH = RobotMessage.maxSourceColumnLength();
    public static final String COLUMN_DELIMITER = " :: ";
    public static final String NEW_LINE_DELIMITER = " ;; ";
    private static final Set<LogEntryParser> PARSERS = Collections.unmodifiableSet(new HashSet<LogEntryParser>(){
        {
            this.add(new LogEntryParser_1_8());
            this.add(new LogEntryParser_3_0());
            this.add(new LogEntryParser_3_1());
            this.add(new LogEntryParser_3_5());
        }
    });

    public static LogEntry parse(String logLine) {
        for (LogEntryParser parser : PARSERS) {
            LogEntry logEntry = parser.tryParse(logLine);
            if (logEntry == null) continue;
            return logEntry;
        }
        throw new LogEntryParserException("Cannot parse log entry: " + logLine);
    }

    LogEntry tryParse(String logLine) {
        String[] values = StringUtils.split((String)COLUMN_DELIMITER, (String)logLine.replaceAll(NEW_LINE_DELIMITER, "\n"));
        LogEntryVersion logEntryVersion = this.parseVersion(values);
        if (logEntryVersion != null) {
            LogEntry logEntry = this.parse(values);
            return logEntry;
        }
        return null;
    }

    abstract LogEntry parse(String[] var1);

    abstract LogEntryVersion parseVersion(String[] var1);

    ErrorCode getErrorCode(String string) {
        try {
            String value = string.split("A")[0].substring(1);
            int parsedValue = PrimitiveUtils.parseInteger((String)value, (int)0);
            return ErrorCode.byId((int)parsedValue);
        }
        catch (Exception e) {
            return ErrorCode.NO_ERROR;
        }
    }

    int getErrorArgument(String string) {
        try {
            String value = string.split(":")[0].split("A")[1];
            return PrimitiveUtils.parseInteger((String)value, (int)0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    RobotMessageType getMessageType(String string) {
        try {
            String value = string.split(":")[1];
            int parsedValue = PrimitiveUtils.parseInteger((String)value, (int)0);
            return RobotMessageType.byId((int)parsedValue);
        }
        catch (Exception e) {
            return RobotMessageType.UNDEFINED;
        }
    }

    protected String[] padValues(String[] values, int minimum) {
        if (values.length >= minimum) {
            return values;
        }
        String[] array = new String[minimum];
        for (int index = 0; index < minimum; ++index) {
            array[index] = "";
        }
        System.arraycopy(values, 0, array, 0, values.length);
        return array;
    }
}

