/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.internal;

import com.ur.lang.PrimitiveUtils;
import com.ur.log.logentry.LogEntry;
import com.ur.log.logentry.LogEntryVersion;
import com.ur.log.logentry.internal.LogEntryParser;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

class LogEntryParser_3_1
extends LogEntryParser {
    private final DateFormat technicalTimeFormatter = new SimpleDateFormat("yyDD'd'HH'h'mm'm'ss.SSS");

    LogEntryParser_3_1() {
    }

    @Override
    LogEntry parse(String[] values) {
        values = this.padValues(values, 7);
        String technicalTime = values[0];
        String friendlyTime = values[1];
        String suggestion = "";
        RobotMessage message = new RobotMessage();
        message.source = MessageSource.byId((int)PrimitiveUtils.parseInteger((String)values[2], (int)0));
        message.errorCode = this.getErrorCode(values[3]);
        message.errorArgument = this.getErrorArgument(values[3]);
        message.type = this.getMessageType(values[3]);
        message.warningLevel = ReportLevel.byId((int)PrimitiveUtils.parseInteger((String)values[4], (int)1));
        message.message = values[5];
        message.title = values[6];
        message.extraData = 0;
        if (values.length > 7) {
            message.extraData = "";
            if (message.type == RobotMessageType.RUNTIME_EXCEPTION) {
                suggestion = values[7];
            } else if (message.type == RobotMessageType.SAFETY_MODE) {
                message.safetyMode = SafetyMode.byId((int)PrimitiveUtils.parseInteger((String)values[7], (int)1));
            } else {
                message.extraData = PrimitiveUtils.isInteger((String)values[7]) ? Integer.valueOf(Integer.parseInt(values[7])) : values[7];
            }
        }
        LogEntry logEntry = new LogEntry(message, friendlyTime, technicalTime, LogEntryVersion.V_3_1);
        logEntry.setSuggestion(suggestion);
        return logEntry;
    }

    private boolean isTechnicalDate(String value) {
        try {
            this.technicalTimeFormatter.parse(value);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    @Override
    LogEntryVersion parseVersion(String[] values) {
        return values.length > 1 && this.isTechnicalDate(values[0]) ? LogEntryVersion.V_3_1 : null;
    }
}

