/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.internal;

import com.ur.controllerinterface.i18n.RuntimeExceptionsResource;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProgramRuntimeMessageProvider {
    private static final Pattern findArgumentsToReplace = Pattern.compile("\\{(.*?)\\}");
    private RuntimeExceptionsResource messages;

    public ProgramRuntimeMessageProvider(RuntimeExceptionsResource messages) {
        this.messages = messages;
    }

    public String getMessage(String robotMessageAsString) {
        String wc = robotMessageAsString.replace("$", "");
        if (wc.isEmpty()) {
            return "";
        }
        ArrayList<String> arguments = new ArrayList<String>();
        int start = 0;
        boolean inside_quotes = false;
        for (int i = 0; i < wc.length(); ++i) {
            if (wc.charAt(i) == '\"') {
                inside_quotes = !inside_quotes;
                continue;
            }
            if (wc.charAt(i) != ':' || inside_quotes || (i <= 0 || wc.charAt(i - 1) == '\\') && i != 0) continue;
            arguments.add(wc.substring(start, i).trim());
            start = i + 1;
        }
        if (start < wc.length()) {
            arguments.add(wc.substring(start, wc.length()).trim());
        }
        if (inside_quotes) {
            Log.warning((String)"Quote mismatch in string");
        }
        String result = this.messages.get((String)arguments.get(0));
        List<String> foundArgumentNames = this.fetchAllUniqueArguments(result);
        if (arguments.size() != foundArgumentNames.size() + 1) {
            Log.warning((String)("Require " + (foundArgumentNames.size() + 1) + ", but received: " + arguments.size()));
        } else {
            for (int i = 0; i < foundArgumentNames.size(); ++i) {
                result = result.replaceAll(foundArgumentNames.get(i), (String)arguments.get(i + 1));
            }
        }
        return result;
    }

    private List<String> fetchAllUniqueArguments(String text) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = findArgumentsToReplace.matcher(text);
        while (matcher.find()) {
            String[] paramAndType = this.stripBraces(matcher.group()).split(":");
            String argument = "";
            for (String each : paramAndType) {
                if (!argument.isEmpty()) {
                    argument = argument + "\\:";
                }
                argument = argument + each;
            }
            argument = "\\{" + argument + "\\}";
            if (result.contains(argument)) continue;
            result.add(argument);
        }
        return result;
    }

    private String stripBraces(String group) {
        return group.replaceAll("[\\{\\}]", "");
    }
}

