/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.internal;

import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

@Deprecated
public class Settings {
    public static final String CONFIG_PATH_KEY = "config.path";
    private static final String LANGUAGE = "language";
    private static final String ENGLISH_PROGRAMMING = "englishProgramming";
    private static final String REGION = "region";
    private static final String LOAD_IMAGES_PATH = "loadImagesPath";
    private static final String RUNNING_IN_DEVELOPMENT_MODE = "RunningInDevelopmentMode";
    private static final String SETTINGS_FILENAME = "gui.properties";
    private static final String USER = System.getenv("USER") == null ? "dummy" : System.getenv("USER");
    private static final String CONFIGURATION_AND_SETTINGS_PATH = Settings.loadConfigurationAndSettingsPath();
    private static NiceProperties properties;

    public static NiceProperties getProperties() {
        if (properties == null) {
            properties = new NiceProperties(Settings.readPropertiesFile(SETTINGS_FILENAME));
            Settings.loadLanguage();
        }
        return properties;
    }

    public static Locale getLanguage() {
        return Locale.getDefault();
    }

    public static boolean isRunningInDevelopmentMode() {
        return Settings.getProperties().getBoolean(RUNNING_IN_DEVELOPMENT_MODE, false);
    }

    public static String loadImagesPath() {
        return Settings.getProperties().getProperty(LOAD_IMAGES_PATH, Settings.getHomeDirectory() + "/Pictures/");
    }

    private static String loadConfigurationAndSettingsPath() {
        Log.info((String)("Robot controller user = " + USER));
        String configSettingsPath = Settings.getConfigurationDir().getPath();
        Log.info((String)("Configuration and settings files path: " + configSettingsPath));
        return configSettingsPath;
    }

    private static void loadLanguage() {
        try {
            String language = Settings.getProperties().getProperty(LANGUAGE, null);
            Locale.setDefault(new Locale(language));
            if (language == null && new File(CONFIGURATION_AND_SETTINGS_PATH + File.separator + LANGUAGE).exists()) {
                language = FileUtils.readFromFile((File)new File(CONFIGURATION_AND_SETTINGS_PATH + File.separator + LANGUAGE), null);
            }
        }
        catch (Exception e) {
            Log.warning((String)"Failed to load language file: Possibly corrupted or empty");
        }
    }

    private static Properties readPropertiesFile(String fileName) {
        String fileNameAndPath = CONFIGURATION_AND_SETTINGS_PATH + File.separator + fileName;
        try {
            return FileUtils.readPropertiesFromFile((String)fileNameAndPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Log.error((String)("Error while reading configuration file, '" + fileNameAndPath + "': "), (Throwable)ex);
        }
        return new Properties();
    }

    public static File getProgramDir() {
        if (Settings.isOnRobot()) {
            return new File("/programs");
        }
        return new File(System.getenv("HOME") + "/programs");
    }

    public static File getConfigurationDir() {
        String configSettingsPath = System.getProperty(CONFIG_PATH_KEY);
        if (configSettingsPath == null || !configSettingsPath.startsWith("/")) {
            configSettingsPath = Settings.isOnRobot() ? "/root/.urcontrol" : System.getenv("HOME") + File.separator + ".urcontrol";
        }
        return new File(configSettingsPath);
    }

    public static boolean isOnRobot() {
        return USER.equals("kiosk") || USER.equals("root");
    }

    public static File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }
}

