/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.robotmessage;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.view.constants.dev.JointMode;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;

public enum InitializationMode {
    NONE,
    NO_CONTROLLER,
    DISCONNECTED,
    RECOVERY,
    JOINT_VERIFICATION,
    CONFIRM_SAFETY,
    SAFETY_VIOLATION,
    SAFE_GUARD_STOP,
    BRAKE_RELEASING,
    BACKDRIVE,
    UPDATING,
    WAITING_FOR_PARAMETERS,
    BRAKE_FAILURE;


    public static InitializationMode transformToInitializationMode(RobotMode robotMode, SafetyMode masterSafetyState, int[] jointModes) {
        if (InitializationMode.isBrakePinFailure(masterSafetyState) || InitializationMode.hasJointMode(JointMode.BRAKE_FAILURE, jointModes)) {
            return BRAKE_FAILURE;
        }
        if (InitializationMode.isInSafetyViolation(masterSafetyState)) {
            return SAFETY_VIOLATION;
        }
        if (robotMode == RobotMode.IDLE && InitializationMode.isInSafeguardStop(masterSafetyState)) {
            return SAFE_GUARD_STOP;
        }
        if (masterSafetyState == SafetyMode.VALIDATE_JOINT_ID) {
            return JOINT_VERIFICATION;
        }
        if (RobotModes.isInBreakRelease(jointModes)) {
            return BRAKE_RELEASING;
        }
        if (robotMode == RobotMode.BACKDRIVE || InitializationMode.hasJointMode(JointMode.BACKDRIVE, jointModes)) {
            return BACKDRIVE;
        }
        if (robotMode == RobotMode.DISCONNECTED) {
            return DISCONNECTED;
        }
        if (robotMode == RobotMode.NO_CONTROLLER) {
            return NO_CONTROLLER;
        }
        if (robotMode == RobotMode.UPDATING) {
            return UPDATING;
        }
        if (robotMode == RobotMode.IDLE && InitializationMode.isWaitingForParameters(masterSafetyState)) {
            return WAITING_FOR_PARAMETERS;
        }
        return NONE;
    }

    private static boolean hasJointMode(JointMode expectedJointMode, int[] jointModes) {
        boolean result = false;
        for (int element : jointModes) {
            result |= element == expectedJointMode.getId();
        }
        return result;
    }

    private static boolean isBrakePinFailure(SafetyMode masterSafetyState) {
        return masterSafetyState.equals((Object)SafetyMode.BRAKE_PIN_FAILURE);
    }

    private static boolean isInSafetyViolation(SafetyMode masterSafetyState) {
        return SafetyModes.isSafetyViolation(masterSafetyState);
    }

    private static boolean isWaitingForParameters(SafetyMode masterSafetyState) {
        return SafetyModes.isWaitingForParameters(masterSafetyState);
    }

    private static boolean isInSafeguardStop(SafetyMode masterSafetyState) {
        return SafetyModes.isSafetyStop(masterSafetyState) || EqualsUtil.equalsOneOf((Object)SafetyMode.PROTECTIVE_STOP, (Object[])new SafetyMode[0]);
    }
}

