/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.robotmessage;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.view.constants.errorcodes.ReportDataType;
import java.io.DataInput;
import java.io.IOException;

public class RobotConsumerUtil {
    private static Long readUnsignedFromStream(DataInput dataInputStream) throws IOException {
        int integerValue = dataInputStream.readInt();
        return (long)integerValue & 0xFFFFFFFFL;
    }

    @Deprecated
    public static String readValueFromStream(ReportDataType reportDataType, DataInput dataInputStream) throws IOException {
        RobotMessage dummy = new RobotMessage();
        RobotConsumerUtil.readValueFromStream(reportDataType, dataInputStream, dummy);
        return (String)dummy.extraData;
    }

    private static String readSigned(DataInput dataInput) throws IOException {
        Integer integerValue = dataInput.readInt();
        return integerValue.toString();
    }

    private static String readFloat(DataInput dataInput) throws IOException {
        Float floatValue = Float.valueOf(dataInput.readFloat());
        return floatValue.toString();
    }

    private static String readHex(DataInput dataInput) throws IOException {
        Long longValue = RobotConsumerUtil.readUnsignedFromStream(dataInput);
        String hexString = Long.toHexString(longValue).toUpperCase();
        return hexString.length() > 8 ? hexString.substring(0, 8) : hexString;
    }

    private static String readString(DataInput dataInput, int len) throws IOException {
        byte[] data = new byte[len];
        dataInput.readFully(data);
        return ScriptConverter.fromScriptCode((String)new String(data));
    }

    private static String readUnsigned(DataInput dataInput) throws IOException {
        Long longValue = RobotConsumerUtil.readUnsignedFromStream(dataInput);
        return longValue.toString();
    }

    public static int readValueFromStream(ReportDataType reportDataType, DataInput dataInputStream, RobotMessage robotMessage) throws IOException {
        int parseLen;
        String value;
        switch (reportDataType) {
            case SIGNED: {
                value = RobotConsumerUtil.readSigned(dataInputStream);
                parseLen = 4;
                break;
            }
            case FLOAT: {
                value = RobotConsumerUtil.readFloat(dataInputStream);
                parseLen = 4;
                break;
            }
            case HEXADECIMAL: {
                value = RobotConsumerUtil.readHex(dataInputStream);
                parseLen = 4;
                break;
            }
            case STRING: {
                parseLen = dataInputStream.readShort();
                value = RobotConsumerUtil.readString(dataInputStream, parseLen);
                parseLen += 2;
                break;
            }
            default: {
                value = RobotConsumerUtil.readUnsigned(dataInputStream);
                parseLen = 4;
            }
        }
        robotMessage.extraData = value;
        return parseLen;
    }
}

