/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.robotmessage;

import com.ur.lang.StringUtils;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.robotmessage.Attachment;
import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.log.logentry.robotmessage.RobotMessagePreprocessor;
import com.ur.log.logentry.robotmessage.RobotMessageProgramState;
import com.ur.log.logentry.robotmessage.RobotModes;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.logging.i18n.TextResource;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class RobotMessage {
    static final String ILLEGAL_ROBOT_MESSAGE_TYPE = "ILLEGAL ROBOT MESSAGE TYPE: ";
    private static final Pattern valuePattern = Pattern.compile("\\{(.*?)\\}");
    public long timestamp;
    public String title = "";
    public String message = "";
    public MessageSource source = MessageSource.UNDEFINED;
    public RobotMessageType type = RobotMessageType.UNDEFINED;
    public SafetyMode safetyMode = null;
    public ErrorCode errorCode = ErrorCode.NO_ERROR;
    public int errorArgument = 0;
    public ReportLevel warningLevel = ReportLevel.INFO;
    public Object extraData = null;
    private String recievedErrorCodeValue = String.valueOf(ErrorCode.NO_ERROR);
    @Deprecated
    public int id = -1;
    private LabelInfo labelinfo;
    public String rtdeMessageSource = "";
    public int valueRequestId;
    private RobotMessageProgramState programState = RobotMessageProgramState.PROHIBITED;
    private String toString;
    private Attachment attachment;

    public String getStringForMessageCode() {
        String errormessage = LanguagePack.getMessageCode(this.errorCode, this.errorArgument);
        switch (this.errorCode) {
            case UNKNOWN: {
                String recievedErrorcode = this.getRecievedErrorCodeValue();
                errormessage = "C" + recievedErrorcode + "A" + this.errorArgument + ": " + LanguagePack.getTextResource().RecievedErrorMessageValue(recievedErrorcode);
                break;
            }
            case NO_ERROR: {
                errormessage = "";
                break;
            }
            case IO_OVERCURRENT_DETECTED: {
                errormessage = errormessage + LanguagePack.getMessageCodeArgument(this.errorCode, this.source.getId() > 0 ? "TOOL" : "MASTER");
                break;
            }
            case ROBOT_MODE_CHANGED: {
                errormessage = errormessage + ": " + RobotModes.getString(this.errorArgument);
                break;
            }
            case SELFTEST_NOT_COMPLETED: 
            case ONE_OF_JOINTS_IN_FAULT: 
            case ONE_OF_JOINTS_IS_NOT_BOOTED: 
            case CRC_ERROR_ON_PRIMARY_BUS_POSSIBLY_FROM_JOINT: {
                errormessage = errormessage + ": " + this.getJointOrTool(this.errorArgument);
                break;
            }
            default: {
                errormessage = this.insertErrorMessageDataToMessage(errormessage);
                if (LanguagePack.hasArgumentWithTranslation(this.errorCode, this.errorArgument)) {
                    errormessage = errormessage + ": " + this.getArgumentTranslation();
                    break;
                }
                if (this.errorArgument == 0) break;
                errormessage = errormessage + ": " + this.errorArgument;
            }
        }
        return errormessage;
    }

    private String getArgumentTranslation() {
        String result = LanguagePack.getMessageCodeArgument(this.errorCode, this.errorArgument);
        return this.insertErrorMessageDataToMessage(result);
    }

    private String getJointOrTool(int id) {
        switch (id) {
            case 0: {
                return LanguagePack.getTextResource().joint0Name();
            }
            case 1: {
                return LanguagePack.getTextResource().joint1Name();
            }
            case 2: {
                return LanguagePack.getTextResource().joint2Name();
            }
            case 3: {
                return LanguagePack.getTextResource().joint3Name();
            }
            case 4: {
                return LanguagePack.getTextResource().joint4Name();
            }
            case 5: {
                return LanguagePack.getTextResource().joint5Name();
            }
            case 6: {
                return LanguagePack.getTextResource().Tool();
            }
        }
        return "" + id;
    }

    public String getSourceString() {
        String result;
        TextResource textResource = LanguagePack.getTextResource();
        switch (this.source) {
            case EUROMAP_2: {
                result = StringUtils.truncate((String)textResource.Euromap(), (int)19) + "2";
                break;
            }
            case EUROMAP_1: {
                result = StringUtils.truncate((String)textResource.Euromap(), (int)19) + "1";
                break;
            }
            case TEACH_PENDANT_2: {
                result = StringUtils.truncate((String)textResource.TeachPendant(), (int)19) + "2";
                break;
            }
            case TEACH_PENDANT_1: {
                result = StringUtils.truncate((String)textResource.TeachPendant(), (int)19) + "1";
                break;
            }
            case TOOL: 
            case JOINT_5: 
            case JOINT_4: 
            case JOINT_3: 
            case JOINT_2: 
            case JOINT_1: 
            case JOINT_0: {
                result = StringUtils.truncate((String)this.getJointOrTool(this.source.getId()), (int)20);
                break;
            }
            case UNDEFINED: {
                result = StringUtils.truncate((String)textResource.Undefined(), (int)20);
                break;
            }
            case ROBOTINTERFACE: {
                result = "RobotInterface";
                break;
            }
            case RTMACHINE: {
                result = "RTMachine";
                break;
            }
            case SIMULATED_ROBOT: {
                result = StringUtils.truncate((String)textResource.Simulated(), (int)20);
                break;
            }
            case GUI: {
                result = "PolyScope";
                break;
            }
            case UA: {
                result = StringUtils.truncate((String)textResource.SafetySys(), (int)19) + "A";
                break;
            }
            case UB: {
                result = StringUtils.truncate((String)textResource.SafetySys(), (int)19) + "B";
                break;
            }
            case SCB_FPGA: {
                result = StringUtils.truncate((String)textResource.SafetySys(), (int)19) + "F";
                break;
            }
            case RTDE: {
                result = this.rtdeMessageSource;
                break;
            }
            case JOINT_0_FPGA: 
            case JOINT_0_A: 
            case JOINT_0_B: 
            case JOINT_1_FPGA: 
            case JOINT_1_A: 
            case JOINT_1_B: 
            case JOINT_2_FPGA: 
            case JOINT_2_A: 
            case JOINT_2_B: 
            case JOINT_3_FPGA: 
            case JOINT_3_A: 
            case JOINT_3_B: 
            case JOINT_4_FPGA: 
            case JOINT_4_A: 
            case JOINT_4_B: 
            case JOINT_5_FPGA: 
            case JOINT_5_A: 
            case JOINT_5_B: 
            case TOOL_FPGA: 
            case TOOL_A: 
            case TOOL_B: 
            case IMMI_FPGA: 
            case IMMI_A: 
            case IMMI_B: {
                int device = (this.source.getId() - 100) / 10;
                int id = this.source.getId() - 100 - 10 * device;
                result = id < 7 ? StringUtils.truncate((String)this.getJointOrTool(id), (int)19) : (id == 7 ? StringUtils.truncate((String)textResource.immi(), (int)19) : "U(" + this.source.getId() + ")");
                if (device == 0) {
                    result = result + "F";
                    break;
                }
                if (device == 1) {
                    result = result + "A";
                    break;
                }
                result = result + "B";
                break;
            }
            case TEACH_PENDANT_A: {
                result = StringUtils.truncate((String)textResource.TeachPendant(), (int)19) + "A";
                break;
            }
            case TEACH_PENDANT_B: {
                result = StringUtils.truncate((String)textResource.TeachPendant(), (int)19) + "B";
                break;
            }
            case BFB_A: 
            case BFB_B: {
                result = StringUtils.truncate((String)textResource.BFB(), (int)20);
                break;
            }
            case BFB_FPGA: {
                result = StringUtils.truncate((String)textResource.BFB(), (int)18) + " F";
                break;
            }
            case ExtenderNear_FPGA: {
                result = StringUtils.truncate((String)textResource.ExtenderNear(), (int)18) + " F";
                break;
            }
            case ExtenderNear_MCU: {
                result = StringUtils.truncate((String)textResource.ExtenderNear(), (int)20);
                break;
            }
            case ExtenderFar_FPGA: {
                result = StringUtils.truncate((String)textResource.ExtenderFar(), (int)18) + " F";
                break;
            }
            case ExtenderFar_MCU: {
                result = StringUtils.truncate((String)textResource.ExtenderFar(), (int)20);
                break;
            }
            case CONTROLLER: {
                result = "Controller";
                break;
            }
            default: {
                result = "U(" + this.source.getId() + ")";
            }
        }
        return result;
    }

    public void clearToStringCache() {
        this.toString = null;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        String s = "";
        switch (this.type) {
            case TEXT: 
            case VERSION: 
            case RTDE: 
            case SAFETY_VERSION: {
                s = this.message;
                break;
            }
            case PROGRAM_LABEL: {
                s = "DEPRECATED: " + this.message;
                break;
            }
            case UNDEFINED: {
                s = "UNDEF";
                break;
            }
            case SAFETY_MODE: {
                String safetyModeName = SafetyModes.getSafetyModeName(this.safetyMode);
                s = LanguagePack.getTextResource().switchedSafetyMode(safetyModeName);
                break;
            }
            case ERROR_CODE: {
                s = this.getStringForMessageCode();
                break;
            }
            case KEY: {
                s = this.title + " ";
                break;
            }
            case REQUEST_VALUE: {
                s = LanguagePack.getTextResource().requestValue() + ": " + this.message;
                break;
            }
            case RUNTIME_EXCEPTION: {
                s = LanguagePack.getProgramRuntimeMessageProvider().getMessage(this.message);
                break;
            }
            case PROGRAM_LABEL_THREADS: {
                s = this.labelinfo.toString();
                break;
            }
            default: {
                s = ILLEGAL_ROBOT_MESSAGE_TYPE + this.type;
            }
        }
        this.toString = this.provideErrorMessageIfEmpty(s);
        return this.toString;
    }

    private String provideErrorMessageIfEmpty(String message) {
        if (message.isEmpty()) {
            return "C" + this.errorCode.getId() + "A" + this.errorArgument;
        }
        return message;
    }

    public void notifyAllSubscribers() {
        Runnable doWorkRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    EventNotificationService.notify(RobotMessagePreprocessor.class, (NotificationStrategy)new NotificationStrategy<RobotMessagePreprocessor>(){

                        public void notify(RobotMessagePreprocessor listener) {
                            listener.handleRobotMessage(RobotMessage.this);
                        }
                    });
                    EventNotificationService.notify(RobotMessageListener.class, (NotificationStrategy)new NotificationStrategy<RobotMessageListener>(){

                        public void notify(RobotMessageListener listener) {
                            listener.handleRobotMessage(RobotMessage.this);
                        }
                    });
                }
                catch (Exception e) {
                    Log.error((String)"Failed to notify", (Throwable)e);
                }
            }
        };
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public static int maxSourceColumnLength() {
        RobotMessage message = new RobotMessage();
        int result = 0;
        MessageSource[] messageSourceArray = MessageSource.values();
        int n = messageSourceArray.length;
        for (int i = 0; i < n; ++i) {
            MessageSource each;
            message.source = each = messageSourceArray[i];
            int sourceStringLength = message.getSourceString().length();
            if (result >= sourceStringLength) continue;
            result = sourceStringLength;
        }
        return Math.min(result, 20);
    }

    public String insertErrorMessageDataToMessage(String message) {
        if (this.extraData != null) {
            message = this.replaceArgumentInMessage(message, this.extraData.toString());
        }
        return message;
    }

    private String replaceArgumentInMessage(String message, String argument) {
        String newMessage = message;
        Matcher matcher = valuePattern.matcher(message);
        if (matcher.find()) {
            String valueStringToReplace = message.substring(matcher.start(), matcher.end());
            String replacement = argument;
            if (valueStringToReplace.contains("deviceName")) {
                replacement = this.getJointOrTool(Integer.parseInt(argument));
            }
            newMessage = message.replace(valueStringToReplace, replacement);
        }
        return newMessage;
    }

    public void setAttachment(Attachment extraData) {
        this.attachment = extraData;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setProgramState(RobotMessageProgramState programState) {
        this.programState = programState;
    }

    public RobotMessageProgramState getProgramState() {
        return this.programState;
    }

    public void setLabelinfo(LabelInfo labelinfo) {
        this.labelinfo = labelinfo;
    }

    public LabelInfo getLabelinfo() {
        return this.labelinfo;
    }

    public String getRecievedErrorCodeValue() {
        return this.recievedErrorCodeValue;
    }

    public void setRecievedErrorCodeValue(String recievedErrorCodeValue) {
        this.recievedErrorCodeValue = recievedErrorCodeValue;
    }
}

