/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.robotmessage;

import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.internal.JointName;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.view.constants.dev.JointMode;
import com.ur.view.constants.dev.JointType;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.util.EnumMap;
import java.util.Map;

public class RobotModes {
    private static final Map<RobotMode, String> modeTextMap = new EnumMap<RobotMode, String>(RobotMode.class);

    public static String getString(RobotMode mode) {
        return modeTextMap.getOrDefault(mode, LanguagePack.getTextResource().robotmodeUnknown() + mode + " (??)");
    }

    public static String getString(int id) {
        return RobotModes.getString(RobotMode.byId((int)id));
    }

    public static String getRobotStateString(RobotMode robotMode, SafetyMode safetyMode, int[] jointModes) {
        if (RobotModes.isBrakeFailure(safetyMode) || RobotModes.hasJointMode(JointMode.BRAKE_FAILURE, jointModes)) {
            return RobotModes.getBrakeFailureMessage(jointModes);
        }
        if (RobotModes.showSafetyStateText(robotMode, safetyMode)) {
            return LanguagePack.getMasterboardSafetyStateText(safetyMode);
        }
        if (RobotModes.hasJointMode(JointMode.MOTOR_INITIALISATION, jointModes)) {
            return LanguagePack.getTextResource().robotModeBreakRelease();
        }
        return RobotModes.getString(robotMode);
    }

    private static String getBrakeFailureMessage(int[] jointModes) {
        String message = LanguagePack.getTextResource().safetyModeBrakePinFailure();
        String failedJoint = RobotModes.getFailedJoint(jointModes);
        if (!failedJoint.isEmpty()) {
            message = message + " - " + failedJoint;
        }
        return message;
    }

    private static String getFailedJoint(int[] jointModes) {
        for (int jointId = 0; jointId < jointModes.length; ++jointId) {
            if (jointModes[jointId] != JointMode.BRAKE_FAILURE.getId()) continue;
            JointType jointType = JointType.byId((int)jointId);
            return JointName.getJointName(jointType);
        }
        return "";
    }

    private static boolean isRunning(RobotMode robotMode) {
        return robotMode == RobotMode.RUNNING;
    }

    private static boolean isSafetyViolation(SafetyMode masterSafetyState) {
        return SafetyModes.isSafetyViolation(masterSafetyState);
    }

    private static boolean isBrakeFailure(SafetyMode masterSafetyState) {
        return masterSafetyState == SafetyMode.BRAKE_PIN_FAILURE;
    }

    private static boolean isIdleAndSafetyStopped(RobotMode robotMode, SafetyMode safetyMode) {
        return robotMode == RobotMode.IDLE && SafetyModes.isSafetyStop(safetyMode);
    }

    private static boolean isIdleAndWaitingForParameters(RobotMode robotMode, SafetyMode safetyMode) {
        return robotMode == RobotMode.IDLE && SafetyModes.isWaitingForParameters(safetyMode);
    }

    private static boolean showSafetyStateText(RobotMode robotMode, SafetyMode safetyMode) {
        return RobotModes.isRunning(robotMode) || RobotModes.isSafetyViolation(safetyMode) || RobotModes.isIdleAndSafetyStopped(robotMode, safetyMode) || RobotModes.isIdleAndWaitingForParameters(robotMode, safetyMode);
    }

    private static boolean hasJointMode(JointMode expectedJointMode, int[] jointModes) {
        boolean result = false;
        for (int element : jointModes) {
            result |= element == expectedJointMode.getId();
        }
        return result;
    }

    public static boolean isInBreakRelease(int[] jointModes) {
        return RobotModes.hasJointMode(JointMode.MOTOR_INITIALISATION, jointModes);
    }

    static {
        modeTextMap.put(RobotMode.NO_CONTROLLER, LanguagePack.getTextResource().robotmodeNoController());
        modeTextMap.put(RobotMode.DISCONNECTED, LanguagePack.getTextResource().robotmodeDisconnected());
        modeTextMap.put(RobotMode.CONFIRM_SAFETY, LanguagePack.getTextResource().robotModeConfirmSafety());
        modeTextMap.put(RobotMode.BOOTING, LanguagePack.getTextResource().robotModeBooting());
        modeTextMap.put(RobotMode.POWER_OFF, LanguagePack.getTextResource().robotModePowerOff());
        modeTextMap.put(RobotMode.POWER_ON, LanguagePack.getTextResource().robotModePowerOn());
        modeTextMap.put(RobotMode.IDLE, LanguagePack.getTextResource().robotModeIdle());
        modeTextMap.put(RobotMode.BACKDRIVE, LanguagePack.getTextResource().robotModeBackdrive());
        modeTextMap.put(RobotMode.RUNNING, LanguagePack.getTextResource().robotModeRunning());
        modeTextMap.put(RobotMode.UPDATING, LanguagePack.getTextResource().robotModeUpdatingFirmware());
        modeTextMap.put(RobotMode.POWERING_OFF, LanguagePack.getTextResource().robotModePoweringOff());
        modeTextMap.put(RobotMode.ARM_BOOTING, LanguagePack.getTextResource().robotModeArmBooting());
        modeTextMap.put(RobotMode.ARM_UPDATING, LanguagePack.getTextResource().robotModeArmUpdating());
    }
}

