/*
 * Decompiled with CFR 0.152.
 */
package com.ur.log.logentry.robotmessage;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.polyscope.logging.i18n.TextResource;
import com.ur.view.constants.dev.SafetyMode;
import java.util.EnumMap;

public class SafetyModes {
    private static final TextResource resource = LanguagePack.getTextResource();
    private static final EnumMap<SafetyMode, SafetyModeCategory> converter = new EnumMap(SafetyMode.class);

    static String getSafetyModeName(Integer safetyModeId) {
        return SafetyModes.getSafetyModeName(SafetyMode.byId((int)safetyModeId));
    }

    static String getSafetyModeName(SafetyMode mode) {
        return resource.translateSafetyMode((Enum<SafetyMode>)mode);
    }

    public static boolean isSafetyStop(SafetyMode mode) {
        return SafetyModes.isSafeguardStop(mode) || SafetyModes.isThreePositionStop(mode);
    }

    public static boolean isSafeguardStop(SafetyMode safetyMode) {
        return SafetyModes.getSafetyModeCategory(safetyMode) == SafetyModeCategory.SAFEGUARD_STOP;
    }

    public static boolean isThreePositionStop(SafetyMode safetyMode) {
        return SafetyModes.getSafetyModeCategory(safetyMode) == SafetyModeCategory.THREE_POSITION_ENABLING_STOP;
    }

    public static boolean isSafetyViolation(SafetyMode safetyMode) {
        return EqualsUtil.equalsOneOf((Object)((Object)SafetyModes.getSafetyModeCategory(safetyMode)), (Object[])new SafetyModeCategory[]{SafetyModeCategory.EMERGENCY_STOP, SafetyModeCategory.FAULT, SafetyModeCategory.VIOLATION});
    }

    public static boolean isWaitingForParameters(SafetyMode safetyMode) {
        return SafetyModeCategory.WAITING_FOR_PARAMETERS == SafetyModes.getSafetyModeCategory(safetyMode);
    }

    public static SafetyModeCategory getSafetyModeCategory(SafetyMode safetyMode) {
        if (safetyMode == null) {
            return null;
        }
        return converter.getOrDefault(safetyMode, null);
    }

    static {
        converter.put(SafetyMode.NORMAL, SafetyModeCategory.NORMAL);
        converter.put(SafetyMode.REDUCED, SafetyModeCategory.REDUCED);
        converter.put(SafetyMode.PROTECTIVE_STOP, SafetyModeCategory.PROTECTIVE_STOP);
        converter.put(SafetyMode.RECOVERY, SafetyModeCategory.RECOVERY);
        converter.put(SafetyMode.SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.AUTOMATIC_MODE_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.IMMI_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.PROFISAFE_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.PROFISAFE_AUTOMATIC_MODE_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.SYSTEM_EMERGENCY_STOP, SafetyModeCategory.EMERGENCY_STOP);
        converter.put(SafetyMode.ROBOT_EMERGENCY_STOP, SafetyModeCategory.EMERGENCY_STOP);
        converter.put(SafetyMode.IMMI_EMERGENCY_STOP, SafetyModeCategory.EMERGENCY_STOP);
        converter.put(SafetyMode.PROFISAFE_EMERGENCY_STOP, SafetyModeCategory.EMERGENCY_STOP);
        converter.put(SafetyMode.VIOLATION, SafetyModeCategory.VIOLATION);
        converter.put(SafetyMode.FAULT, SafetyModeCategory.FAULT);
        converter.put(SafetyMode.BRAKE_PIN_FAILURE, SafetyModeCategory.BRAKE_FAILURE);
        converter.put(SafetyMode.VALIDATE_JOINT_ID, SafetyModeCategory.VALIDATE_JOINT_ID);
        converter.put(SafetyMode.UNDEFINED_SAFETY_MODE, SafetyModeCategory.UNDEFINED_SAFETY_MODE);
        converter.put(SafetyMode.SYSTEM_THREE_POSITION_ENABLING_STOP, SafetyModeCategory.THREE_POSITION_ENABLING_STOP);
        converter.put(SafetyMode.TP_THREE_POSITION_ENABLING_STOP, SafetyModeCategory.THREE_POSITION_ENABLING_STOP);
        converter.put(SafetyMode.PROFISAFE_WAITING_FOR_PARAMETERS, SafetyModeCategory.WAITING_FOR_PARAMETERS);
        converter.put(SafetyMode.SAFETY_API_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
        converter.put(SafetyMode.SAFETY_PLANES_SAFEGUARD_STOP, SafetyModeCategory.SAFEGUARD_STOP);
    }
}

