/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Frame;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;

public class FrameWaiter
extends WindowWaiter
implements Timeoutable,
Outputable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private Timeouts timeouts;
    private TestOut output;

    public FrameWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
    }

    public static Frame getFrame(ComponentChooser cc) {
        return (Frame)WindowWaiter.getWindow(new FrameSubChooser(cc));
    }

    public static Frame getFrame(ComponentChooser cc, int index) {
        return (Frame)WindowWaiter.getWindow(new FrameSubChooser(cc), index);
    }

    public static Frame getFrame(String title, boolean ce, boolean cc) {
        return (Frame)WindowWaiter.getWindow(new FrameByTitleChooser(title, ce, cc));
    }

    public static Frame getFrame(String title, boolean ce, boolean cc, int index) {
        return (Frame)WindowWaiter.getWindow(new FrameByTitleChooser(title, ce, cc), index);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts times = timeouts.cloneThis();
        times.setTimeout("WindowWaiter.WaitWindowTimeout", timeouts.getTimeout("FrameWaiter.WaitFrameTimeout"));
        times.setTimeout("WindowWaiter.AfterWindowTimeout", timeouts.getTimeout("FrameWaiter.AfterFrameTimeout"));
        super.setTimeouts(times);
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut output) {
        this.output = output;
        super.setOutput(output);
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    public Frame waitFrame(ComponentChooser ch, int index) throws InterruptedException {
        this.setTimeouts(this.timeouts);
        return (Frame)this.waitWindow(new FrameSubChooser(ch), index);
    }

    public Frame waitFrame(ComponentChooser ch) throws InterruptedException {
        return this.waitFrame(ch, 0);
    }

    public Frame waitFrame(String title, boolean compareExactly, boolean compareCaseSensitive, int index) throws InterruptedException {
        return this.waitFrame(new FrameByTitleChooser(title, compareExactly, compareCaseSensitive), index);
    }

    public Frame waitFrame(String title, boolean compareExactly, boolean compareCaseSensitive) throws InterruptedException {
        return this.waitFrame(title, compareExactly, compareCaseSensitive, 0);
    }

    @Override
    protected String getWaitingStartedMessage() {
        return "Start to wait frame \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    @Override
    protected String getTimeoutExpiredMessage(long timeSpent) {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has not been opened in " + new Long(timeSpent).toString() + " milliseconds";
    }

    @Override
    protected String getActionProducedMessage(long timeSpent, final Object result) {
        String resultToString = null;
        resultToString = result instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            @Override
            public Object launch() {
                return result.toString();
            }
        }) : result.toString();
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has been opened in " + new Long(timeSpent).toString() + " milliseconds" + "\n    " + resultToString;
    }

    @Override
    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait frame \"" + this.getComponentChooser().getDescription() + "\" opened";
    }

    @Override
    protected String getGoldenTimeoutExpiredMessage() {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has not been opened";
    }

    @Override
    protected String getGoldenActionProducedMessage() {
        return "Frame \"" + this.getComponentChooser().getDescription() + "\" has been opened";
    }

    static {
        Timeouts.initDefault("FrameWaiter.WaitFrameTimeout", 60000L);
        Timeouts.initDefault("FrameWaiter.AfterFrameTimeout", 0L);
    }

    private static class FrameByTitleChooser
    implements ComponentChooser {
        String title;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public FrameByTitleChooser(String t, boolean ce, boolean cc) {
            this.title = t;
            this.compareExactly = ce;
            this.compareCaseSensitive = cc;
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof Frame && ((Frame)comp).isShowing() && comp.isVisible() && ((Frame)comp).getTitle() != null) {
                String titleToComp = ((Frame)comp).getTitle();
                String contextToComp = this.title;
                if (this.compareCaseSensitive) {
                    titleToComp = titleToComp.toUpperCase();
                    contextToComp = contextToComp.toUpperCase();
                }
                if (this.compareExactly) {
                    return titleToComp.equals(contextToComp);
                }
                return titleToComp.indexOf(contextToComp) != -1;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.title;
        }
    }

    private static class FrameSubChooser
    implements ComponentChooser {
        private ComponentChooser chooser;

        public FrameSubChooser(ComponentChooser c) {
            this.chooser = c;
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof Frame) {
                return comp.isShowing() && comp.isVisible() && this.chooser.checkComponent(comp);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

