/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.Scenario;
import org.netbeans.jemmy.TestCompletedException;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;

public class Test
extends ActionProducer
implements Timeoutable,
Outputable,
Scenario {
    private static final long WHOLE_TEST_TIMEOUT = 3600000L;
    public static int WRONG_PARAMETERS_STATUS = 101;
    public static int SCENARIO_EXCEPTION_STATUS = 102;
    public static int TEST_PASSED_STATUS = 0;
    protected Timeouts timeouts;
    protected TestOut output;
    private Scenario scenario;
    private static int TEST_FAILED_STATUS = 1;

    public Test(String testClassName) {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.scenario = this.testForName(testClassName);
    }

    public Test(Scenario scenario) {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.scenario = scenario;
    }

    protected Test() {
        super(true);
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
    }

    public static void closeDown(int status) {
        if (status == 0) {
            throw new TestCompletedException(status, "Test passed");
        }
        throw new TestCompletedException(status, "Test failed with status " + Integer.toString(status));
    }

    public static int run(String[] argv) {
        String[] args = argv;
        JemmyProperties.getProperties().init();
        if (argv.length < 1) {
            JemmyProperties.getCurrentOutput().printErrLine("First element of String array should be test classname");
            return WRONG_PARAMETERS_STATUS;
        }
        JemmyProperties.getCurrentOutput().printLine("Executed test " + argv[0]);
        Test test = new Test(argv[0]);
        if (argv.length >= 1) {
            args = Test.shiftArray(args);
        }
        if (argv.length >= 2) {
            JemmyProperties.getCurrentOutput().printLine("Work directory: " + argv[1]);
            System.setProperty("user.dir", argv[1]);
            args = Test.shiftArray(args);
        }
        int status = TEST_FAILED_STATUS;
        if (test != null) {
            status = test.startTest(args);
        }
        JemmyProperties.getCurrentOutput().flush();
        return status;
    }

    public static int run(String[] argv, PrintStream output) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, output, output));
        return Test.run(argv);
    }

    public static int run(String[] argv, PrintStream output, PrintStream errput) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, output, errput));
        return Test.run(argv);
    }

    public static int run(String[] argv, PrintWriter output) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, output, output));
        return Test.run(argv);
    }

    public static int run(String[] argv, PrintWriter output, PrintWriter errput) {
        JemmyProperties.setCurrentOutput(new TestOut(System.in, output, errput));
        return Test.run(argv);
    }

    public static void main(String[] argv) {
        System.exit(Test.run(argv, System.out));
    }

    public Scenario testForName(String testName) {
        try {
            return (Scenario)Class.forName(testName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.output.printErrLine("Class " + testName + " does not exist!");
            this.output.printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            this.output.printErrLine("Class " + testName + " has not constructor!");
            this.output.printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            this.output.printErrLine("Exception inside " + testName + " constructor:");
            this.output.printStackTrace(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            this.output.printErrLine("Cannot access to " + testName + " constructor!");
            this.output.printStackTrace(e);
        }
        catch (InstantiationException e) {
            this.output.printErrLine("Cannot instantiate " + testName + " class!");
            this.output.printStackTrace(e);
        }
        return null;
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts times = timeouts.cloneThis();
        times.setTimeout("ActionProducer.MaxActionTime", timeouts.getTimeout("Test.WholeTestTimeout"));
        super.setTimeouts(times);
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(out);
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    public int startTest(Object param) {
        if (this.scenario != null) {
            this.output.printLine("Test " + this.scenario.getClass().getName() + " has been started");
        } else {
            this.output.printLine("Test " + this.getClass().getName() + " has been started");
        }
        try {
            return (Integer)this.produceAction(param);
        }
        catch (InterruptedException e) {
            this.output.printErrLine("Test was interrupted.");
            this.output.printStackTrace(e);
        }
        catch (TimeoutExpiredException e) {
            this.output.printErrLine("Test was not finished in " + Long.toString(this.timeouts.getTimeout("Test.WholeTestTimeout")) + " milliseconds");
            this.output.printStackTrace(e);
        }
        catch (Exception e) {
            this.output.printStackTrace(e);
        }
        return 1;
    }

    @Override
    public final Object launch(Object obj) {
        this.setTimeouts(this.timeouts);
        try {
            if (this.scenario != null) {
                Test.closeDown(this.scenario.runIt(obj));
            } else {
                Test.closeDown(this.runIt(obj));
            }
        }
        catch (TestCompletedException e) {
            this.output.printStackTrace(e);
            return new Integer(e.getStatus());
        }
        catch (Throwable e) {
            this.output.printStackTrace(e);
            return new Integer(SCENARIO_EXCEPTION_STATUS);
        }
        return new Integer(TEST_PASSED_STATUS);
    }

    public void printSynopsis() {
        this.output.printLine("Here should be a test synopsis.");
    }

    @Override
    public final String getDescription() {
        return "Test " + this.scenario.getClass().getName() + " finished";
    }

    @Override
    public int runIt(Object param) {
        return 0;
    }

    protected void doSleep(long time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String[] shiftArray(String[] orig) {
        String[] result = new String[orig.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = orig[i + 1];
        }
        return result;
    }

    static {
        Timeouts.initDefault("Test.WholeTestTimeout", 3600000L);
    }
}

