/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.FocusDriver;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ComponentOperator
extends Operator
implements Timeoutable,
Outputable {
    public static final String NAME_DPROP = "Name:";
    public static final String IS_VISIBLE_DPROP = "Visible";
    public static final String IS_SHOWING_DPROP = "Showing";
    public static final String X_DPROP = "X";
    public static final String Y_DPROP = "Y";
    public static final String WIDTH_DPROP = "Width";
    public static final String HEIGHT_DPROP = "Height";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long MOUSE_CLICK_TIMEOUT = 0L;
    private static final long BEFORE_DRAG_TIMEOUT = 0L;
    private static final long AFTER_DRAG_TIMEOUT = 0L;
    private static final long WAIT_COMPONENT_TIMEOUT = 60000L;
    private static final long WAIT_COMPONENT_ENABLED_TIMEOUT = 60000L;
    private static final long WAIT_FOCUS_TIMEOUT = 60000L;
    private static final long WAIT_STATE_TIMEOUT = 60000L;
    private Component source;
    private Timeouts timeouts;
    private TestOut output;
    private EventDispatcher dispatcher;
    private KeyDriver kDriver;
    private MouseDriver mDriver;
    private FocusDriver fDriver;

    public ComponentOperator(Component comp) {
        this.source = comp;
        this.kDriver = DriverManager.getKeyDriver(this.getClass());
        this.mDriver = DriverManager.getMouseDriver(this.getClass());
        this.fDriver = DriverManager.getFocusDriver(this.getClass());
        this.setEventDispatcher(new EventDispatcher(comp));
    }

    public ComponentOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this(ComponentOperator.waitComponent((Container)cont.getSource(), chooser, index, cont.getTimeouts(), cont.getOutput()));
        this.copyEnvironment(cont);
    }

    public ComponentOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ComponentOperator(ContainerOperator cont, int index) {
        this(cont, ComponentSearcher.getTrueChooser("Any component"), index);
    }

    public ComponentOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Component findComponent(Container cont, ComponentChooser chooser, int index) {
        return ComponentOperator.findComponent(cont, chooser, index, false);
    }

    public static Component findComponent(Container cont, ComponentChooser chooser) {
        return ComponentOperator.findComponent(cont, chooser, 0);
    }

    public static Component waitComponent(Container cont, ComponentChooser chooser, int index) {
        return ComponentOperator.waitComponent(cont, chooser, index, JemmyProperties.getCurrentTimeouts(), JemmyProperties.getCurrentOutput());
    }

    public static Component waitComponent(Container cont, ComponentChooser chooser) {
        return ComponentOperator.waitComponent(cont, chooser, 0);
    }

    protected static Component waitComponent(ContainerOperator contOper, ComponentChooser chooser, int index) {
        return ComponentOperator.waitComponent((Container)contOper.getSource(), chooser, index, contOper.getTimeouts(), contOper.getOutput());
    }

    protected static Component waitComponent(final Container cont, final ComponentChooser chooser, final int index, Timeouts timeouts, final TestOut output) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                @Override
                public Object actionProduced(Object obj) {
                    return ComponentOperator.findComponent(cont, new VisibleComponentFinder(chooser), index, output.createErrorOutput());
                }

                @Override
                public String getDescription() {
                    return "Wait " + chooser.getDescription() + " loaded";
                }
            });
            waiter.setTimeoutsToCloneOf(timeouts, "ComponentOperator.WaitComponentTimeout");
            waiter.setOutput(output);
            return (Component)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static Component findComponent(Container cont, ComponentChooser chooser, int index, TestOut output) {
        ComponentSearcher searcher = new ComponentSearcher(cont);
        searcher.setOutput(output);
        return searcher.findComponent(new VisibleComponentFinder(chooser), index);
    }

    private static Component findComponent(Container cont, ComponentChooser chooser, int index, boolean supressOutout) {
        return ComponentOperator.findComponent(cont, chooser, index, JemmyProperties.getCurrentOutput().createErrorOutput());
    }

    @Override
    public Component getSource() {
        return this.source;
    }

    public EventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
        if (this.dispatcher != null) {
            this.dispatcher.setOutput(this.output.createErrorOutput());
        }
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
        if (this.dispatcher != null) {
            this.dispatcher.setTimeouts(this.getTimeouts());
        }
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.kDriver = (KeyDriver)DriverManager.getDriver("drivers.key", this.getClass(), anotherOperator.getProperties());
        this.mDriver = (MouseDriver)DriverManager.getDriver("drivers.mouse", this.getClass(), anotherOperator.getProperties());
    }

    public void clickMouse(final int x, final int y, final int clickCount, final int mouseButton, final int modifiers, boolean forPopup) {
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            @Override
            public Object launch() {
                ComponentOperator.this.mDriver.clickMouse(ComponentOperator.this, x, y, clickCount, mouseButton, modifiers, ComponentOperator.this.timeouts.create("ComponentOperator.MouseClickTimeout"));
                return null;
            }
        });
    }

    public void clickMouse(int x, int y, int clickCount, int mouseButton, int modifiers) {
        this.clickMouse(x, y, clickCount, mouseButton, modifiers, false);
    }

    public void clickMouse(int x, int y, int clickCount, int mouseButton) {
        this.clickMouse(x, y, clickCount, mouseButton, 0);
    }

    public void clickMouse(int x, int y, int clickCount) {
        this.clickMouse(x, y, clickCount, ComponentOperator.getDefaultMouseButton());
    }

    public void pressMouse(int x, int y) {
        this.mDriver.pressMouse(this, x, y, ComponentOperator.getDefaultMouseButton(), 0);
    }

    public void releaseMouse(int x, int y) {
        this.mDriver.releaseMouse(this, x, y, ComponentOperator.getDefaultMouseButton(), 0);
    }

    public void moveMouse(int x, int y) {
        this.mDriver.moveMouse(this, x, y);
    }

    public void dragMouse(int x, int y, int mouseButton, int modifiers) {
        this.mDriver.dragMouse(this, x, y, ComponentOperator.getDefaultMouseButton(), 0);
    }

    public void dragMouse(int x, int y, int mouseButton) {
        this.dragMouse(x, y, mouseButton, 0);
    }

    public void dragMouse(int x, int y) {
        this.dragMouse(x, y, ComponentOperator.getDefaultMouseButton());
    }

    public void dragNDrop(int start_x, int start_y, int end_x, int end_y, int mouseButton, int modifiers) {
        this.mDriver.dragNDrop(this, start_x, start_y, end_x, end_y, mouseButton, modifiers, this.timeouts.create("ComponentOperator.BeforeDragTimeout"), this.timeouts.create("ComponentOperator.AfterDragTimeout"));
    }

    public void dragNDrop(int start_x, int start_y, int end_x, int end_y, int mouseButton) {
        this.dragNDrop(start_x, start_y, end_x, end_y, mouseButton, 0);
    }

    public void dragNDrop(int start_x, int start_y, int end_x, int end_y) {
        this.dragNDrop(start_x, start_y, end_x, end_y, ComponentOperator.getDefaultMouseButton(), 0);
    }

    public void clickForPopup(int x, int y, int mouseButton) {
        this.makeComponentVisible();
        this.clickMouse(x, y, 1, mouseButton, 0, true);
    }

    public void clickForPopup(int x, int y) {
        this.clickForPopup(x, y, ComponentOperator.getPopupMouseButton());
    }

    public void clickMouse(final int clickCount, final int mouseButton) {
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

            @Override
            public Object launch() {
                ComponentOperator.this.clickMouse(ComponentOperator.this.getCenterXForClick(), ComponentOperator.this.getCenterYForClick(), clickCount, mouseButton);
                return null;
            }
        });
    }

    public void clickMouse(int clickCount) {
        this.clickMouse(clickCount, ComponentOperator.getDefaultMouseButton());
    }

    public void clickMouse() {
        this.clickMouse(1);
    }

    public void enterMouse() {
        this.mDriver.enterMouse(this);
    }

    public void exitMouse() {
        this.mDriver.exitMouse(this);
    }

    public void pressMouse() {
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

            @Override
            public Object launch() {
                ComponentOperator.this.pressMouse(ComponentOperator.this.getCenterXForClick(), ComponentOperator.this.getCenterYForClick());
                return null;
            }
        });
    }

    public void releaseMouse() {
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

            @Override
            public Object launch() {
                ComponentOperator.this.releaseMouse(ComponentOperator.this.getCenterXForClick(), ComponentOperator.this.getCenterYForClick());
                return null;
            }
        });
    }

    public void clickForPopup(int mouseButton) {
        this.clickForPopup(this.getCenterXForClick(), this.getCenterYForClick(), mouseButton);
    }

    public void clickForPopup() {
        this.clickForPopup(ComponentOperator.getPopupMouseButton());
    }

    public void pressKey(int keyCode, int modifiers) {
        this.kDriver.pressKey(this, keyCode, modifiers);
    }

    public void pressKey(int keyCode) {
        this.pressKey(keyCode, 0);
    }

    public void releaseKey(int keyCode, int modifiers) {
        this.kDriver.releaseKey(this, keyCode, modifiers);
    }

    public void releaseKey(int keyCode) {
        this.releaseKey(keyCode, 0);
    }

    public void pushKey(int keyCode, int modifiers) {
        this.kDriver.pushKey(this, keyCode, modifiers, this.timeouts.create("ComponentOperator.PushKeyTimeout"));
    }

    public void pushKey(int keyCode) {
        this.pushKey(keyCode, 0);
    }

    public void typeKey(int keyCode, char keyChar, int modifiers) {
        this.kDriver.typeKey(this, keyCode, keyChar, modifiers, this.timeouts.create("ComponentOperator.PushKeyTimeout"));
    }

    public void typeKey(char keyChar, int modifiers) {
        this.typeKey(this.getCharKey(keyChar), keyChar, modifiers | this.getCharModifiers(keyChar));
    }

    public void typeKey(char keyChar) {
        this.typeKey(keyChar, 0);
    }

    public void activateWindow() {
        this.getVisualizer().makeVisible(this);
    }

    public void makeComponentVisible() {
        this.getVisualizer().makeVisible(this);
    }

    public void getFocus() {
        this.fDriver.giveFocus(this);
    }

    public int getCenterX() {
        return this.getWidth() / 2;
    }

    public int getCenterY() {
        return this.getHeight() / 2;
    }

    public int getCenterXForClick() {
        return this.getCenterX();
    }

    public int getCenterYForClick() {
        return this.getCenterY();
    }

    public void waitComponentEnabled() throws InterruptedException {
        Waiter waiter = new Waiter(new Waitable(){

            @Override
            public Object actionProduced(Object obj) {
                if (((Component)obj).isEnabled()) {
                    return obj;
                }
                return null;
            }

            @Override
            public String getDescription() {
                return "Component enabled: " + ComponentOperator.this.getSource().getClass().toString();
            }
        });
        waiter.setOutput(this.output);
        waiter.setTimeoutsToCloneOf(this.timeouts, "ComponentOperator.WaitComponentEnabledTimeout");
        waiter.waitAction(this.getSource());
    }

    public void wtComponentEnabled() {
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted!", e);
        }
    }

    public Container[] getContainers() {
        int counter = 0;
        Container cont = this.getSource().getParent();
        if (cont == null) {
            return new Container[0];
        }
        do {
            ++counter;
        } while ((cont = cont.getParent()) != null);
        Container[] res = new Container[counter];
        cont = this.getSource().getParent();
        counter = 0;
        do {
            res[++counter - 1] = cont;
        } while ((cont = cont.getParent()) != null);
        return res;
    }

    public Container getContainer(ComponentChooser chooser) {
        int counter = 0;
        Container cont = this.getSource().getParent();
        if (cont == null) {
            return null;
        }
        do {
            if (chooser.checkComponent(cont)) {
                return cont;
            }
            ++counter;
        } while ((cont = cont.getParent()) != null);
        return null;
    }

    public Window getWindow() {
        if (this.getSource() instanceof Window) {
            return (Window)this.getSource();
        }
        Window window = (Window)this.getContainer(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return comp instanceof Window;
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        if (window == null && this.getSource() instanceof Window) {
            return (Window)this.getSource();
        }
        return window;
    }

    public void waitHasFocus() {
        Waiter focusWaiter = new Waiter(new Waitable(){

            @Override
            public Object actionProduced(Object obj) {
                return ComponentOperator.this.hasFocus() ? "" : null;
            }

            @Override
            public String getDescription() {
                return "Wait component has focus";
            }
        });
        focusWaiter.setTimeoutsToCloneOf(this.timeouts, "ComponentOperator.WaitFocusTimeout");
        focusWaiter.setOutput(this.output.createErrorOutput());
        try {
            focusWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    public void waitComponentVisible(final boolean visibility) {
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return ComponentOperator.this.isVisible() == visibility;
            }

            @Override
            public String getDescription() {
                return "Component is " + (visibility ? "" : " not ") + "visible";
            }
        });
    }

    public void waitComponentShowing(final boolean visibility) {
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return ComponentOperator.this.isShowing() == visibility;
            }

            @Override
            public String getDescription() {
                return "Component is " + (visibility ? "" : " not ") + "showing";
            }
        });
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (this.getSource().getName() != null) {
            result.put(NAME_DPROP, this.getSource().getName());
        }
        result.put(IS_VISIBLE_DPROP, this.getSource().isVisible() ? "true" : "false");
        result.put(IS_SHOWING_DPROP, this.getSource().isShowing() ? "true" : "false");
        result.put(X_DPROP, Integer.toString(this.getSource().getX()));
        result.put(Y_DPROP, Integer.toString(this.getSource().getY()));
        result.put(WIDTH_DPROP, Integer.toString(this.getSource().getWidth()));
        result.put(HEIGHT_DPROP, Integer.toString(this.getSource().getHeight()));
        return result;
    }

    public void add(final PopupMenu popupMenu) {
        this.runMapping(new Operator.MapVoidAction("add"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().add(popupMenu);
            }
        });
    }

    public void addComponentListener(final ComponentListener componentListener) {
        this.runMapping(new Operator.MapVoidAction("addComponentListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addComponentListener(componentListener);
            }
        });
    }

    public void addFocusListener(final FocusListener focusListener) {
        this.runMapping(new Operator.MapVoidAction("addFocusListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addFocusListener(focusListener);
            }
        });
    }

    public void addInputMethodListener(final InputMethodListener inputMethodListener) {
        this.runMapping(new Operator.MapVoidAction("addInputMethodListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addInputMethodListener(inputMethodListener);
            }
        });
    }

    public void addKeyListener(final KeyListener keyListener) {
        this.runMapping(new Operator.MapVoidAction("addKeyListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addKeyListener(keyListener);
            }
        });
    }

    public void addMouseListener(final MouseListener mouseListener) {
        this.runMapping(new Operator.MapVoidAction("addMouseListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addMouseListener(mouseListener);
            }
        });
    }

    public void addMouseMotionListener(final MouseMotionListener mouseMotionListener) {
        this.runMapping(new Operator.MapVoidAction("addMouseMotionListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addMouseMotionListener(mouseMotionListener);
            }
        });
    }

    public void addNotify() {
        this.runMapping(new Operator.MapVoidAction("addNotify"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addNotify();
            }
        });
    }

    public void addPropertyChangeListener(final PropertyChangeListener propertyChangeListener) {
        this.runMapping(new Operator.MapVoidAction("addPropertyChangeListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addPropertyChangeListener(propertyChangeListener);
            }
        });
    }

    public void addPropertyChangeListener(final String string, final PropertyChangeListener propertyChangeListener) {
        this.runMapping(new Operator.MapVoidAction("addPropertyChangeListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().addPropertyChangeListener(string, propertyChangeListener);
            }
        });
    }

    public int checkImage(final Image image, final int i, final int i1, final ImageObserver imageObserver) {
        return this.runMapping(new Operator.MapIntegerAction("checkImage"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().checkImage(image, i, i1, imageObserver);
            }
        });
    }

    public int checkImage(final Image image, final ImageObserver imageObserver) {
        return this.runMapping(new Operator.MapIntegerAction("checkImage"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().checkImage(image, imageObserver);
            }
        });
    }

    public boolean contains(final int i, final int i1) {
        return this.runMapping(new Operator.MapBooleanAction("contains"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().contains(i, i1);
            }
        });
    }

    public boolean contains(final Point point) {
        return this.runMapping(new Operator.MapBooleanAction("contains"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().contains(point);
            }
        });
    }

    public Image createImage(final int i, final int i1) {
        return (Image)this.runMapping(new Operator.MapAction("createImage"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().createImage(i, i1);
            }
        });
    }

    public Image createImage(final ImageProducer imageProducer) {
        return (Image)this.runMapping(new Operator.MapAction("createImage"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().createImage(imageProducer);
            }
        });
    }

    public void dispatchEvent(final AWTEvent aWTEvent) {
        this.runMapping(new Operator.MapVoidAction("dispatchEvent"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().dispatchEvent(aWTEvent);
            }
        });
    }

    public void doLayout() {
        this.runMapping(new Operator.MapVoidAction("doLayout"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().doLayout();
            }
        });
    }

    public void enableInputMethods(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("enableInputMethods"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().enableInputMethods(b);
            }
        });
    }

    public float getAlignmentX() {
        return this.runMapping(new Operator.MapFloatAction("getAlignmentX"){

            @Override
            public float map() {
                return ComponentOperator.this.getSource().getAlignmentX();
            }
        });
    }

    public float getAlignmentY() {
        return this.runMapping(new Operator.MapFloatAction("getAlignmentY"){

            @Override
            public float map() {
                return ComponentOperator.this.getSource().getAlignmentY();
            }
        });
    }

    public Color getBackground() {
        return (Color)this.runMapping(new Operator.MapAction("getBackground"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getBackground();
            }
        });
    }

    public Rectangle getBounds() {
        return (Rectangle)this.runMapping(new Operator.MapAction("getBounds"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getBounds();
            }
        });
    }

    public Rectangle getBounds(final Rectangle rectangle) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getBounds"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getBounds(rectangle);
            }
        });
    }

    public ColorModel getColorModel() {
        return (ColorModel)this.runMapping(new Operator.MapAction("getColorModel"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getColorModel();
            }
        });
    }

    public Component getComponentAt(final int i, final int i1) {
        return (Component)this.runMapping(new Operator.MapAction("getComponentAt"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getComponentAt(i, i1);
            }
        });
    }

    public Component getComponentAt(final Point point) {
        return (Component)this.runMapping(new Operator.MapAction("getComponentAt"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getComponentAt(point);
            }
        });
    }

    public ComponentOrientation getComponentOrientation() {
        return (ComponentOrientation)this.runMapping(new Operator.MapAction("getComponentOrientation"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getComponentOrientation();
            }
        });
    }

    public Cursor getCursor() {
        return (Cursor)this.runMapping(new Operator.MapAction("getCursor"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getCursor();
            }
        });
    }

    public DropTarget getDropTarget() {
        return (DropTarget)this.runMapping(new Operator.MapAction("getDropTarget"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getDropTarget();
            }
        });
    }

    public Font getFont() {
        return (Font)this.runMapping(new Operator.MapAction("getFont"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getFont();
            }
        });
    }

    public FontMetrics getFontMetrics(final Font font) {
        return (FontMetrics)this.runMapping(new Operator.MapAction("getFontMetrics"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getFontMetrics(font);
            }
        });
    }

    public Color getForeground() {
        return (Color)this.runMapping(new Operator.MapAction("getForeground"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getForeground();
            }
        });
    }

    public Graphics getGraphics() {
        return (Graphics)this.runMapping(new Operator.MapAction("getGraphics"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getGraphics();
            }
        });
    }

    public int getHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getHeight"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().getHeight();
            }
        });
    }

    public InputContext getInputContext() {
        return (InputContext)this.runMapping(new Operator.MapAction("getInputContext"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getInputContext();
            }
        });
    }

    public InputMethodRequests getInputMethodRequests() {
        return (InputMethodRequests)this.runMapping(new Operator.MapAction("getInputMethodRequests"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getInputMethodRequests();
            }
        });
    }

    public Locale getLocale() {
        return (Locale)this.runMapping(new Operator.MapAction("getLocale"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getLocale();
            }
        });
    }

    public Point getLocation() {
        return (Point)this.runMapping(new Operator.MapAction("getLocation"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getLocation();
            }
        });
    }

    public Point getLocation(final Point point) {
        return (Point)this.runMapping(new Operator.MapAction("getLocation"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getLocation(point);
            }
        });
    }

    public Point getLocationOnScreen() {
        return (Point)this.runMapping(new Operator.MapAction("getLocationOnScreen"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getLocationOnScreen();
            }
        });
    }

    public Dimension getMaximumSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getMaximumSize"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getMaximumSize();
            }
        });
    }

    public Dimension getMinimumSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getMinimumSize"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getMinimumSize();
            }
        });
    }

    public String getName() {
        return (String)this.runMapping(new Operator.MapAction("getName"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getName();
            }
        });
    }

    public Container getParent() {
        return (Container)this.runMapping(new Operator.MapAction("getParent"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getParent();
            }
        });
    }

    public Dimension getPreferredSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredSize"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getPreferredSize();
            }
        });
    }

    public Dimension getSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getSize"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getSize();
            }
        });
    }

    public Dimension getSize(final Dimension dimension) {
        return (Dimension)this.runMapping(new Operator.MapAction("getSize"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getSize(dimension);
            }
        });
    }

    public Toolkit getToolkit() {
        return (Toolkit)this.runMapping(new Operator.MapAction("getToolkit"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getToolkit();
            }
        });
    }

    public Object getTreeLock() {
        return this.runMapping(new Operator.MapAction("getTreeLock"){

            @Override
            public Object map() {
                return ComponentOperator.this.getSource().getTreeLock();
            }
        });
    }

    public int getWidth() {
        return this.runMapping(new Operator.MapIntegerAction("getWidth"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().getWidth();
            }
        });
    }

    public int getX() {
        return this.runMapping(new Operator.MapIntegerAction("getX"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().getX();
            }
        });
    }

    public int getY() {
        return this.runMapping(new Operator.MapIntegerAction("getY"){

            @Override
            public int map() {
                return ComponentOperator.this.getSource().getY();
            }
        });
    }

    public boolean hasFocus() {
        return this.runMapping(new Operator.MapBooleanAction("hasFocus"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().hasFocus();
            }
        });
    }

    public boolean imageUpdate(final Image image, final int i, final int i1, final int i2, final int i3, final int i4) {
        return this.runMapping(new Operator.MapBooleanAction("imageUpdate"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().imageUpdate(image, i, i1, i2, i3, i4);
            }
        });
    }

    public void invalidate() {
        this.runMapping(new Operator.MapVoidAction("invalidate"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().invalidate();
            }
        });
    }

    public boolean isDisplayable() {
        return this.runMapping(new Operator.MapBooleanAction("isDisplayable"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isDisplayable();
            }
        });
    }

    public boolean isDoubleBuffered() {
        return this.runMapping(new Operator.MapBooleanAction("isDoubleBuffered"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isDoubleBuffered();
            }
        });
    }

    public boolean isEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isEnabled"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isEnabled();
            }
        });
    }

    public boolean isFocusTraversable() {
        return this.runMapping(new Operator.MapBooleanAction("isFocusTraversable"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isFocusTraversable();
            }
        });
    }

    public boolean isLightweight() {
        return this.runMapping(new Operator.MapBooleanAction("isLightweight"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isLightweight();
            }
        });
    }

    public boolean isOpaque() {
        return this.runMapping(new Operator.MapBooleanAction("isOpaque"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isOpaque();
            }
        });
    }

    public boolean isShowing() {
        return this.runMapping(new Operator.MapBooleanAction("isShowing"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isShowing();
            }
        });
    }

    public boolean isValid() {
        return this.runMapping(new Operator.MapBooleanAction("isValid"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isValid();
            }
        });
    }

    public boolean isVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isVisible"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().isVisible();
            }
        });
    }

    public void list() {
        this.runMapping(new Operator.MapVoidAction("list"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().list();
            }
        });
    }

    public void list(final PrintStream printStream) {
        this.runMapping(new Operator.MapVoidAction("list"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().list(printStream);
            }
        });
    }

    public void list(final PrintStream printStream, final int i) {
        this.runMapping(new Operator.MapVoidAction("list"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().list(printStream, i);
            }
        });
    }

    public void list(final PrintWriter printWriter) {
        this.runMapping(new Operator.MapVoidAction("list"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().list(printWriter);
            }
        });
    }

    public void list(final PrintWriter printWriter, final int i) {
        this.runMapping(new Operator.MapVoidAction("list"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().list(printWriter, i);
            }
        });
    }

    public void paint(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("paint"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().paint(graphics);
            }
        });
    }

    public void paintAll(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("paintAll"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().paintAll(graphics);
            }
        });
    }

    public boolean prepareImage(final Image image, final int i, final int i1, final ImageObserver imageObserver) {
        return this.runMapping(new Operator.MapBooleanAction("prepareImage"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().prepareImage(image, i, i1, imageObserver);
            }
        });
    }

    public boolean prepareImage(final Image image, final ImageObserver imageObserver) {
        return this.runMapping(new Operator.MapBooleanAction("prepareImage"){

            @Override
            public boolean map() {
                return ComponentOperator.this.getSource().prepareImage(image, imageObserver);
            }
        });
    }

    public void print(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("print"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().print(graphics);
            }
        });
    }

    public void printAll(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("printAll"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().printAll(graphics);
            }
        });
    }

    public void remove(final MenuComponent menuComponent) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().remove(menuComponent);
            }
        });
    }

    public void removeComponentListener(final ComponentListener componentListener) {
        this.runMapping(new Operator.MapVoidAction("removeComponentListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeComponentListener(componentListener);
            }
        });
    }

    public void removeFocusListener(final FocusListener focusListener) {
        this.runMapping(new Operator.MapVoidAction("removeFocusListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeFocusListener(focusListener);
            }
        });
    }

    public void removeInputMethodListener(final InputMethodListener inputMethodListener) {
        this.runMapping(new Operator.MapVoidAction("removeInputMethodListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeInputMethodListener(inputMethodListener);
            }
        });
    }

    public void removeKeyListener(final KeyListener keyListener) {
        this.runMapping(new Operator.MapVoidAction("removeKeyListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeKeyListener(keyListener);
            }
        });
    }

    public void removeMouseListener(final MouseListener mouseListener) {
        this.runMapping(new Operator.MapVoidAction("removeMouseListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeMouseListener(mouseListener);
            }
        });
    }

    public void removeMouseMotionListener(final MouseMotionListener mouseMotionListener) {
        this.runMapping(new Operator.MapVoidAction("removeMouseMotionListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeMouseMotionListener(mouseMotionListener);
            }
        });
    }

    public void removeNotify() {
        this.runMapping(new Operator.MapVoidAction("removeNotify"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removeNotify();
            }
        });
    }

    public void removePropertyChangeListener(final PropertyChangeListener propertyChangeListener) {
        this.runMapping(new Operator.MapVoidAction("removePropertyChangeListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    public void removePropertyChangeListener(final String string, final PropertyChangeListener propertyChangeListener) {
        this.runMapping(new Operator.MapVoidAction("removePropertyChangeListener"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().removePropertyChangeListener(string, propertyChangeListener);
            }
        });
    }

    public void repaint() {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().repaint();
            }
        });
    }

    public void repaint(final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().repaint(i, i1, i2, i3);
            }
        });
    }

    public void repaint(final long l) {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().repaint(l);
            }
        });
    }

    public void repaint(final long l, final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().repaint(l, i, i1, i2, i3);
            }
        });
    }

    public void requestFocus() {
        this.runMapping(new Operator.MapVoidAction("requestFocus"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().requestFocus();
            }
        });
    }

    public void setBackground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setBackground"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setBackground(color);
            }
        });
    }

    public void setBounds(final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("setBounds"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setBounds(i, i1, i2, i3);
            }
        });
    }

    public void setBounds(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("setBounds"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setBounds(rectangle);
            }
        });
    }

    public void setComponentOrientation(final ComponentOrientation componentOrientation) {
        this.runMapping(new Operator.MapVoidAction("setComponentOrientation"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setComponentOrientation(componentOrientation);
            }
        });
    }

    public void setCursor(final Cursor cursor) {
        this.runMapping(new Operator.MapVoidAction("setCursor"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setCursor(cursor);
            }
        });
    }

    public void setDropTarget(final DropTarget dropTarget) {
        this.runMapping(new Operator.MapVoidAction("setDropTarget"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setDropTarget(dropTarget);
            }
        });
    }

    public void setEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEnabled"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setEnabled(b);
            }
        });
    }

    public void setFont(final Font font) {
        this.runMapping(new Operator.MapVoidAction("setFont"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setFont(font);
            }
        });
    }

    public void setForeground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setForeground"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setForeground(color);
            }
        });
    }

    public void setLocale(final Locale locale) {
        this.runMapping(new Operator.MapVoidAction("setLocale"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setLocale(locale);
            }
        });
    }

    public void setLocation(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setLocation"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setLocation(i, i1);
            }
        });
    }

    public void setLocation(final Point point) {
        this.runMapping(new Operator.MapVoidAction("setLocation"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setLocation(point);
            }
        });
    }

    public void setName(final String string) {
        this.runMapping(new Operator.MapVoidAction("setName"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setName(string);
            }
        });
    }

    public void setSize(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setSize"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setSize(i, i1);
            }
        });
    }

    public void setSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setSize"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setSize(dimension);
            }
        });
    }

    public void setVisible(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setVisible"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().setVisible(b);
            }
        });
    }

    public void transferFocus() {
        this.runMapping(new Operator.MapVoidAction("transferFocus"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().transferFocus();
            }
        });
    }

    public void update(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("update"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().update(graphics);
            }
        });
    }

    public void validate() {
        this.runMapping(new Operator.MapVoidAction("validate"){

            @Override
            public void map() {
                ComponentOperator.this.getSource().validate();
            }
        });
    }

    private void setEventDispatcher(EventDispatcher dispatcher) {
        dispatcher.setOutput(this.getOutput().createErrorOutput());
        dispatcher.setTimeouts(this.getTimeouts());
        this.dispatcher = dispatcher;
    }

    static {
        Timeouts.initDefault("ComponentOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("ComponentOperator.MouseClickTimeout", 0L);
        Timeouts.initDefault("ComponentOperator.BeforeDragTimeout", 0L);
        Timeouts.initDefault("ComponentOperator.AfterDragTimeout", 0L);
        Timeouts.initDefault("ComponentOperator.WaitComponentTimeout", 60000L);
        Timeouts.initDefault("ComponentOperator.WaitComponentEnabledTimeout", 60000L);
        Timeouts.initDefault("ComponentOperator.WaitStateTimeout", 60000L);
        Timeouts.initDefault("ComponentOperator.WaitFocusTimeout", 60000L);
    }

    static class VisibleComponentFinder
    implements ComponentChooser {
        ComponentChooser subFinder;

        public VisibleComponentFinder(ComponentChooser sf) {
            this.subFinder = sf;
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp.isShowing()) {
                return this.subFinder.checkComponent(comp);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }
}

