/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.plaf.MenuBarUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.Operator;

public class JMenuBarOperator
extends JComponentOperator
implements Outputable,
Timeoutable {
    public static final String SUBMENU_PREFIX_DPROP = "Submenu";
    private TestOut output;
    private Timeouts timeouts;
    private MenuDriver driver = DriverManager.getMenuDriver(this.getClass());

    public JMenuBarOperator(JMenuBar b) {
        super(b);
    }

    public JMenuBarOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JMenuBar)cont.waitSubComponent(new JMenuBarFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JMenuBarOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JMenuBarOperator(ContainerOperator cont) {
        this((JMenuBar)JMenuBarOperator.waitComponent(cont, (ComponentChooser)new JMenuBarFinder(), 0));
        this.copyEnvironment(cont);
    }

    public static JMenuBar findJMenuBar(JFrame frame) {
        return JMenuBarOperator.findJMenuBar((Container)frame);
    }

    public static JMenuBar findJMenuBar(JDialog dialog) {
        return JMenuBarOperator.findJMenuBar((Container)dialog);
    }

    public static JMenuBar waitJMenuBar(Container cont) {
        return (JMenuBar)JMenuBarOperator.waitComponent(cont, new JMenuBarFinder());
    }

    public static JMenuBar waitJMenuBar(JFrame frame) {
        return JMenuBarOperator.waitJMenuBar((Container)frame);
    }

    public static JMenuBar waitJMenuBar(JDialog dialog) {
        return JMenuBarOperator.waitJMenuBar((Container)dialog);
    }

    public static JMenuBar findJMenuBar(Container cont) {
        return (JMenuBar)JMenuBarOperator.findComponent(cont, new JMenuBarFinder());
    }

    @Override
    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void setTimeouts(Timeouts times) {
        super.setTimeouts(times);
        this.timeouts = times;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = DriverManager.getMenuDriver(this);
    }

    public JMenuItem pushMenu(final ComponentChooser[] choosers) {
        this.makeComponentVisible();
        return (JMenuItem)this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                JMenuBarOperator.this.getQueueTool().waitEmpty();
                Object result = JMenuBarOperator.this.driver.pushMenu(JMenuBarOperator.this, JMenuOperator.converChoosers(choosers));
                JMenuBarOperator.this.getQueueTool().waitEmpty();
                return result;
            }

            @Override
            public String getDescription() {
                return JMenuOperator.createDescription(choosers);
            }
        }, this.getTimeouts().getTimeout("JMenuOperator.PushMenuTimeout"));
    }

    public void pushMenuNoBlock(final ComponentChooser[] choosers) {
        this.makeComponentVisible();
        this.produceNoBlocking(new Operator.NoBlockingAction("Menu pushing"){

            @Override
            public Object doAction(Object param) {
                JMenuBarOperator.this.getQueueTool().waitEmpty();
                Object result = JMenuBarOperator.this.driver.pushMenu(JMenuBarOperator.this, JMenuOperator.converChoosers(choosers));
                JMenuBarOperator.this.getQueueTool().waitEmpty();
                return result;
            }
        });
    }

    public JMenuItem pushMenu(String[] names, Operator.StringComparator comparator) {
        return this.pushMenu(JMenuItemOperator.createChoosers(names, comparator));
    }

    public JMenuItem pushMenu(String[] names, boolean ce, boolean ccs) {
        return this.pushMenu(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public void pushMenuNoBlock(String[] names, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(JMenuItemOperator.createChoosers(names, comparator));
    }

    public void pushMenuNoBlock(String[] names, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public JMenuItem pushMenu(String[] names) {
        return this.pushMenu(names, this.getComparator());
    }

    public void pushMenuNoBlock(String[] names) {
        this.pushMenuNoBlock(names, this.getComparator());
    }

    public JMenuItem pushMenu(String path, String delim, Operator.StringComparator comparator) {
        return this.pushMenu(this.parseString(path, delim), comparator);
    }

    public JMenuItem pushMenu(String path, Operator.StringComparator comparator) {
        return this.pushMenu(this.parseString(path), comparator);
    }

    public JMenuItem pushMenu(String path, String delim, boolean ce, boolean ccs) {
        return this.pushMenu(this.parseString(path, delim), ce, ccs);
    }

    public void pushMenuNoBlock(String path, String delim, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(this.parseString(path, delim), comparator);
    }

    public void pushMenuNoBlock(String path, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(this.parseString(path), comparator);
    }

    public void pushMenuNoBlock(String path, String delim, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(this.parseString(path, delim), ce, ccs);
    }

    public JMenuItem pushMenu(String path, String delim) {
        return this.pushMenu(this.parseString(path, delim));
    }

    public JMenuItem pushMenu(String path) {
        return this.pushMenu(this.parseString(path));
    }

    public void pushMenuNoBlock(String path, String delim) {
        this.pushMenuNoBlock(this.parseString(path, delim));
    }

    public void pushMenuNoBlock(String path) {
        this.pushMenuNoBlock(this.parseString(path));
    }

    public JMenuItemOperator[] showMenuItems(ComponentChooser[] choosers) {
        if (choosers == null || choosers.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(choosers), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] path, Operator.StringComparator comparator) {
        if (path == null || path.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(path, comparator), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim) {
        return this.showMenuItems(path, delim, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(ComponentChooser[] choosers) {
        ContainerOperator menuCont;
        ComponentChooser[] parentPath = this.getParentPath(choosers);
        if (parentPath.length > 0) {
            JMenu menu = (JMenu)this.pushMenu(this.getParentPath(choosers));
            menuCont = new ContainerOperator(menu.getPopupMenu());
            menuCont.copyEnvironment(this);
        } else {
            menuCont = this;
        }
        JMenuItemOperator result = new JMenuItemOperator(menuCont, choosers[choosers.length - 1]);
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path, Operator.StringComparator comparator) {
        JMenuItemOperator result;
        ContainerOperator menuCont;
        String[] parentPath = this.getParentPath(path);
        if (parentPath.length > 0) {
            JMenu menu = (JMenu)this.pushMenu(this.getParentPath(path), comparator);
            menuCont = new ContainerOperator(menu.getPopupMenu());
            menuCont.copyEnvironment(this);
        } else {
            menuCont = this;
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            ComponentSearcher searcher = new ComponentSearcher((Container)menuCont.getSource());
            searcher.setOutput(this.output);
            Component c = searcher.findComponent(new JMenuItemOperator.JMenuItemByLabelFinder(path[path.length - 1], this.getComparator()));
            result = new JMenuItemOperator((JMenuItem)c);
        } else {
            result = new JMenuItemOperator(menuCont, path[path.length - 1]);
        }
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator showMenuItem(String path, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path), comparator);
    }

    public JMenuItemOperator showMenuItem(String path, String delim) {
        return this.showMenuItem(path, delim, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public void closeSubmenus() {
        JMenu menu = (JMenu)this.findSubComponent(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return comp instanceof JMenu && ((JMenu)comp).isPopupMenuVisible();
            }

            @Override
            public String getDescription() {
                return "Expanded JMenu";
            }
        });
        if (menu != null) {
            JMenuOperator oper = new JMenuOperator(menu);
            oper.copyEnvironment(this);
            oper.push();
        }
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        Object[] items = new String[((JMenuBar)this.getSource()).getMenuCount()];
        for (int i = 0; i < ((JMenuBar)this.getSource()).getMenuCount(); ++i) {
            items[i] = ((JMenuBar)this.getSource()).getMenu(i) != null ? ((JMenuBar)this.getSource()).getMenu(i).getText() : "null";
        }
        this.addToDump(result, SUBMENU_PREFIX_DPROP, items);
        return result;
    }

    public JMenu add(final JMenu jMenu) {
        return (JMenu)this.runMapping(new Operator.MapAction("add"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).add(jMenu);
            }
        });
    }

    public int getComponentIndex(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("getComponentIndex"){

            @Override
            public int map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getComponentIndex(component);
            }
        });
    }

    public JMenu getHelpMenu() {
        return (JMenu)this.runMapping(new Operator.MapAction("getHelpMenu"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getHelpMenu();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getMargin();
            }
        });
    }

    public JMenu getMenu(final int i) {
        return (JMenu)this.runMapping(new Operator.MapAction("getMenu"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getMenu(i);
            }
        });
    }

    public int getMenuCount() {
        return this.runMapping(new Operator.MapIntegerAction("getMenuCount"){

            @Override
            public int map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getMenuCount();
            }
        });
    }

    public SingleSelectionModel getSelectionModel() {
        return (SingleSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public MenuElement[] getSubElements() {
        return (MenuElement[])this.runMapping(new Operator.MapAction("getSubElements"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getSubElements();
            }
        });
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.runMapping(new Operator.MapAction("getUI"){

            @Override
            public Object map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            @Override
            public boolean map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isSelected() {
        return this.runMapping(new Operator.MapBooleanAction("isSelected"){

            @Override
            public boolean map() {
                return ((JMenuBar)JMenuBarOperator.this.getSource()).isSelected();
            }
        });
    }

    public void menuSelectionChanged(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("menuSelectionChanged"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).menuSelectionChanged(b);
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).processKeyEvent(keyEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void processMouseEvent(final MouseEvent mouseEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processMouseEvent"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).processMouseEvent(mouseEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void setBorderPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setBorderPainted(b);
            }
        });
    }

    public void setHelpMenu(final JMenu jMenu) {
        this.runMapping(new Operator.MapVoidAction("setHelpMenu"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setHelpMenu(jMenu);
            }
        });
    }

    public void setMargin(final Insets insets) {
        this.runMapping(new Operator.MapVoidAction("setMargin"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setMargin(insets);
            }
        });
    }

    public void setSelected(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setSelected"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setSelected(component);
            }
        });
    }

    public void setSelectionModel(final SingleSelectionModel singleSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setSelectionModel(singleSelectionModel);
            }
        });
    }

    public void setUI(final MenuBarUI menuBarUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            @Override
            public void map() {
                ((JMenuBar)JMenuBarOperator.this.getSource()).setUI(menuBarUI);
            }
        });
    }

    static {
        JMenuOperator.performInit();
    }

    public static class JMenuBarFinder
    extends Operator.Finder {
        public JMenuBarFinder(ComponentChooser sf) {
            super(JMenuBar.class, sf);
        }

        public JMenuBarFinder() {
            super(JMenuBar.class);
        }
    }
}

