/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JSpinnerOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String VALUE_DPROP = "Value";
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    private JButtonOperator increaseOperator = null;
    private JButtonOperator decreaseOperator = null;

    public JSpinnerOperator(JSpinner b) {
        super(b);
    }

    public JSpinnerOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JSpinner)cont.waitSubComponent(new JSpinnerFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JSpinnerOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JSpinnerOperator(ContainerOperator cont, String text, int index) {
        this((JSpinner)JSpinnerOperator.waitComponent(cont, (ComponentChooser)new JSpinnerByTextFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JSpinnerOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JSpinnerOperator(ContainerOperator cont, int index) {
        this((JSpinner)JSpinnerOperator.waitComponent(cont, (ComponentChooser)new JSpinnerFinder(), index));
        this.copyEnvironment(cont);
    }

    public JSpinnerOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JSpinner findJSpinner(Container cont, ComponentChooser chooser, int index) {
        return (JSpinner)JSpinnerOperator.findComponent(cont, new JSpinnerFinder(chooser), index);
    }

    public static JSpinner findJSpinner(Container cont, ComponentChooser chooser) {
        return JSpinnerOperator.findJSpinner(cont, chooser, 0);
    }

    public static JSpinner findJSpinner(Container cont, int index) {
        return JSpinnerOperator.findJSpinner(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JSpinner instance"), index);
    }

    public static JSpinner findJSpinner(Container cont) {
        return JSpinnerOperator.findJSpinner(cont, 0);
    }

    public static JSpinner waitJSpinner(Container cont, ComponentChooser chooser, int index) {
        return (JSpinner)JSpinnerOperator.waitComponent(cont, (ComponentChooser)new JSpinnerFinder(chooser), index);
    }

    public static JSpinner waitJSpinner(Container cont, ComponentChooser chooser) {
        return JSpinnerOperator.waitJSpinner(cont, chooser, 0);
    }

    public static JSpinner waitJSpinner(Container cont, int index) {
        return JSpinnerOperator.waitJSpinner(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JSpinner instance"), index);
    }

    public static JSpinner waitJSpinner(Container cont) {
        return JSpinnerOperator.waitJSpinner(cont, 0);
    }

    public static void checkModel(JSpinnerOperator oper, Class modelClass) {
        if (!modelClass.isInstance(oper.getModel())) {
            throw new SpinnerModelException("JSpinner model is not a " + modelClass.getName(), oper.getSource());
        }
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public NumberSpinnerOperator getNumberSpinner() {
        return new NumberSpinnerOperator(this);
    }

    public ListSpinnerOperator getListSpinner() {
        return new ListSpinnerOperator(this);
    }

    public DateSpinnerOperator getDateSpinner() {
        return new DateSpinnerOperator(this);
    }

    public void scrollTo(final ScrollAdjuster adj) {
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                JSpinnerOperator.this.driver.scroll(JSpinnerOperator.this, adj);
                return null;
            }

            @Override
            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                JSpinnerOperator.this.driver.scrollToMaximum(JSpinnerOperator.this, 1);
                return null;
            }

            @Override
            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToMinimum() {
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                JSpinnerOperator.this.driver.scrollToMinimum(JSpinnerOperator.this, 1);
                return null;
            }

            @Override
            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSpinnerOperator.WholeScrollTimeout"));
    }

    public void scrollToObject(Object value, int direction) {
        this.scrollTo(new ExactScrollAdjuster(this, value, direction));
    }

    public void scrollToString(String pattern, Operator.StringComparator comparator, int direction) {
        this.scrollTo(new ToStringScrollAdjuster(this, pattern, comparator, direction));
    }

    public void scrollToString(String pattern, int direction) {
        this.scrollToString(pattern, this.getComparator(), direction);
    }

    public JButtonOperator getIncreaseOperator() {
        if (this.increaseOperator == null) {
            this.increaseOperator = (JButtonOperator)this.createSubOperator(new JButtonOperator.JButtonFinder(), 0);
            this.increaseOperator.copyEnvironment(this);
            this.increaseOperator.setOutput(this.getOutput().createErrorOutput());
        }
        return this.increaseOperator;
    }

    public JButtonOperator getDecreaseOperator() {
        if (this.decreaseOperator == null) {
            this.decreaseOperator = (JButtonOperator)this.createSubOperator(new JButtonOperator.JButtonFinder(), 1);
            this.decreaseOperator.copyEnvironment(this);
            this.decreaseOperator.setOutput(this.getOutput().createErrorOutput());
        }
        return this.decreaseOperator;
    }

    public Object getMinimum() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getMinimum();
        }
        if (model instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)model).getEnd();
        }
        if (model instanceof SpinnerListModel) {
            List<?> list = ((SpinnerListModel)model).getList();
            return list.get(list.size() - 1);
        }
        return null;
    }

    public Object getMaximum() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getMaximum();
        }
        if (model instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)model).getEnd();
        }
        if (model instanceof SpinnerListModel) {
            List<?> list = ((SpinnerListModel)model).getList();
            return list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(VALUE_DPROP, ((JSpinner)this.getSource()).getValue().toString());
        return result;
    }

    public Object getValue() {
        return this.runMapping(new Operator.MapAction("getValue"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getValue();
            }
        });
    }

    public void setValue(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setValue(object);
            }
        });
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.runMapping(new Operator.MapAction("getUI"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getUI();
            }
        });
    }

    public void setUI(final SpinnerUI spinnerUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setUI(spinnerUI);
            }
        });
    }

    public void setModel(final SpinnerModel spinnerModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setModel(spinnerModel);
            }
        });
    }

    public SpinnerModel getModel() {
        return (SpinnerModel)this.runMapping(new Operator.MapAction("getModel"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getModel();
            }
        });
    }

    public Object getNextValue() {
        return this.runMapping(new Operator.MapAction("getNextValue"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getNextValue();
            }
        });
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.runMapping(new Operator.MapAction("getChangeListeners"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getChangeListeners();
            }
        });
    }

    public Object getPreviousValue() {
        return this.runMapping(new Operator.MapAction("getPreviousValue"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getPreviousValue();
            }
        });
    }

    public void setEditor(final JComponent jComponent) {
        this.runMapping(new Operator.MapVoidAction("setEditor"){

            @Override
            public void map() {
                ((JSpinner)JSpinnerOperator.this.getSource()).setEditor(jComponent);
            }
        });
    }

    public JComponent getEditor() {
        return (JComponent)this.runMapping(new Operator.MapAction("getEditor"){

            @Override
            public Object map() {
                return ((JSpinner)JSpinnerOperator.this.getSource()).getEditor();
            }
        });
    }

    public void commitEdit() {
        this.runMapping(new Operator.MapVoidAction("commitEdit"){

            @Override
            public void map() throws ParseException {
                ((JSpinner)JSpinnerOperator.this.getSource()).commitEdit();
            }
        });
    }

    static {
        Timeouts.initDefault("JSpinnerOperator.WholeScrollTimeout", 60000L);
    }

    public static class SpinnerModelException
    extends JemmyException {
        public SpinnerModelException(String message, Component comp) {
            super(message, comp);
        }
    }

    public class DateSpinnerOperator
    extends JSpinnerOperator {
        private DateSpinnerOperator(JSpinnerOperator spinner) {
            super((JSpinner)spinner.getSource());
            this.copyEnvironment(spinner);
            DateSpinnerOperator.checkModel(this, SpinnerDateModel.class);
        }

        public SpinnerDateModel getDateModel() {
            return (SpinnerDateModel)this.getModel();
        }

        public void scrollToDate(Date date) {
            this.scrollTo(new DateScrollAdjuster(this, date));
        }
    }

    public class ListSpinnerOperator
    extends JSpinnerOperator {
        private ListSpinnerOperator(JSpinnerOperator spinner) {
            super((JSpinner)spinner.getSource());
            this.copyEnvironment(spinner);
            ListSpinnerOperator.checkModel(this, SpinnerListModel.class);
        }

        public SpinnerListModel getListModel() {
            return (SpinnerListModel)this.getModel();
        }

        public int findItem(String pattern, Operator.StringComparator comparator) {
            List<?> list = this.getListModel().getList();
            for (int i = 0; i < list.size(); ++i) {
                if (!comparator.equals(list.get(i).toString(), pattern)) continue;
                return i;
            }
            return -1;
        }

        public int findItem(String pattern) {
            return this.findItem(pattern, this.getComparator());
        }

        public void scrollToIndex(int index) {
            this.scrollTo(new ListScrollAdjuster((JSpinnerOperator)this, index));
        }

        public void scrollToString(String pattern, Operator.StringComparator comparator) {
            int index = this.findItem(pattern, comparator);
            if (index == -1) {
                throw new JemmyException("No \"" + pattern + "\" item in JSpinner", this.getSource());
            }
            this.scrollToIndex(index);
        }

        public void scrollToString(String pattern) {
            this.scrollToString(pattern, this.getComparator());
        }
    }

    public class NumberSpinnerOperator
    extends JSpinnerOperator {
        private NumberSpinnerOperator(JSpinnerOperator spinner) {
            super((JSpinner)spinner.getSource());
            this.copyEnvironment(spinner);
            NumberSpinnerOperator.checkModel(this, SpinnerNumberModel.class);
        }

        public SpinnerNumberModel getNumberModel() {
            return (SpinnerNumberModel)this.getModel();
        }

        public void scrollToValue(double value) {
            this.scrollTo(new NumberScrollAdjuster((JSpinnerOperator)this, value));
        }

        public void scrollToValue(Number value) {
            this.scrollTo(new NumberScrollAdjuster((JSpinnerOperator)this, value));
        }
    }

    public static class ToStringScrollAdjuster
    extends ObjectScrollAdjuster {
        String pattern;
        Operator.StringComparator comparator;

        public ToStringScrollAdjuster(JSpinnerOperator oper, String pattern, Operator.StringComparator comparator, int direction) {
            super(oper, direction);
            this.pattern = pattern;
            this.comparator = comparator;
        }

        public ToStringScrollAdjuster(JSpinnerOperator oper, String pattern, int direction) {
            this(oper, pattern, oper.getComparator(), direction);
        }

        @Override
        public boolean equals(Object curvalue) {
            return this.comparator.equals(curvalue.toString(), this.pattern);
        }

        @Override
        public String getDescription() {
            return "Spin to \"" + this.pattern + "\" value";
        }

        @Override
        public int getScrollOrientation() {
            return 1;
        }
    }

    public static class ExactScrollAdjuster
    extends ObjectScrollAdjuster {
        Object obj;

        public ExactScrollAdjuster(JSpinnerOperator oper, Object obj, int direction) {
            super(oper, direction);
            this.obj = obj;
        }

        @Override
        public boolean equals(Object curvalue) {
            return curvalue.equals(this.obj);
        }

        @Override
        public String getDescription() {
            return "Spin to " + this.obj.toString() + " value";
        }

        @Override
        public int getScrollOrientation() {
            return 1;
        }
    }

    public static abstract class ObjectScrollAdjuster
    implements ScrollAdjuster {
        SpinnerModel model;
        int direction;

        public ObjectScrollAdjuster(JSpinnerOperator oper, int direction) {
            this.direction = direction;
            this.model = oper.getModel();
        }

        @Override
        public int getScrollDirection() {
            if (this.equals(this.model.getValue())) {
                return 0;
            }
            if (this.direction == 1 && this.model.getNextValue() != null || this.direction == -1 && this.model.getPreviousValue() != null) {
                return this.direction;
            }
            return 0;
        }

        public abstract boolean equals(Object var1);

        @Override
        public int getScrollOrientation() {
            return 1;
        }
    }

    public static class DateScrollAdjuster
    implements ScrollAdjuster {
        Date date;
        SpinnerDateModel model;

        public DateScrollAdjuster(JSpinnerOperator oper, Date date) {
            this.date = date;
            JSpinnerOperator.checkModel(oper, SpinnerDateModel.class);
            this.model = (SpinnerDateModel)oper.getModel();
        }

        @Override
        public int getScrollDirection() {
            if (this.date.after(this.model.getDate())) {
                return 1;
            }
            if (this.date.before(this.model.getDate())) {
                return -1;
            }
            return 0;
        }

        @Override
        public int getScrollOrientation() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Spin to " + this.date.toString() + " date";
        }
    }

    public static class ListScrollAdjuster
    implements ScrollAdjuster {
        SpinnerListModel model;
        int itemIndex;
        List elements;

        private ListScrollAdjuster(JSpinnerOperator oper) {
            JSpinnerOperator.checkModel(oper, SpinnerListModel.class);
            this.model = (SpinnerListModel)oper.getModel();
            this.elements = this.model.getList();
        }

        public ListScrollAdjuster(JSpinnerOperator oper, Object value) {
            this(oper);
            this.itemIndex = this.elements.indexOf(value);
        }

        public ListScrollAdjuster(JSpinnerOperator oper, int itemIndex) {
            this(oper);
            this.itemIndex = itemIndex;
        }

        @Override
        public int getScrollDirection() {
            int curIndex = this.elements.indexOf(this.model.getValue());
            if (this.itemIndex > curIndex) {
                return 1;
            }
            if (this.itemIndex < curIndex) {
                return -1;
            }
            return 0;
        }

        @Override
        public int getScrollOrientation() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Spin to " + Integer.toString(this.itemIndex) + "'th item";
        }
    }

    public static class NumberScrollAdjuster
    implements ScrollAdjuster {
        SpinnerNumberModel model;
        double value;

        public NumberScrollAdjuster(JSpinnerOperator oper, double value) {
            this.value = value;
            JSpinnerOperator.checkModel(oper, SpinnerNumberModel.class);
            this.model = (SpinnerNumberModel)oper.getModel();
        }

        public NumberScrollAdjuster(JSpinnerOperator oper, Number value) {
            this(oper, value.doubleValue());
        }

        @Override
        public int getScrollDirection() {
            if (this.value > this.model.getNumber().doubleValue()) {
                return 1;
            }
            if (this.value < this.model.getNumber().doubleValue()) {
                return -1;
            }
            return 0;
        }

        @Override
        public int getScrollOrientation() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Spin to " + this.value + " value";
        }
    }

    public static class JSpinnerFinder
    extends Operator.Finder {
        public JSpinnerFinder(ComponentChooser sf) {
            super(JSpinner.class, sf);
        }

        public JSpinnerFinder() {
            super(JSpinner.class);
        }
    }

    public static class JSpinnerByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JSpinnerByTextFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public JSpinnerByTextFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof JSpinner && ((JSpinner)comp).getValue() != null) {
                return this.comparator.equals(((JSpinner)comp).getValue().toString(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JSpinner with text \"" + this.label + "\"";
        }
    }
}

