/*
 * Decompiled with CFR 0.152.
 */
package com.ur.monitor;

import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.StreamedModel;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointSpeedVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.JointMode;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import com.ur.view.constants.runtime.SpeedMode;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;

@Deprecated
public class RobotState
implements Cloneable,
StreamedModel {
    private static final Logger LOG = LogFactory.createLogger(RobotState.class);
    private static final int NO_OF_JOINTS = 6;
    public static final int NUMBER_OF_IO_DIGITAL_PORTS = 8;
    public static final int NUMBER_OF_TOOL_DIGITAL_IO = 2;
    public static final int NUMBER_OF_CONFIGURABLE_DIGITAL_IO = 8;
    public static final int NUMBER_OF_TOOL_ANALOG_INPUTS = 2;
    public static final int NUMBER_OF_STANDARD_ANALOG_INPUTS = 2;
    public static final int NUMBER_OF_STANDARD_ANALOG_OUTPUTS = 2;
    public static final int NUMBER_OF_ALL_ANALOG_INPUTS = 4;
    public static final int EUROMAP67_NUMBER_OF_INPUT_BITS = 21;
    public static final int EUROMAP67_NUMBER_OF_OUTPUT_BITS = 16;
    private static RobotState latestRobotState = new RobotState(true);
    public long timestamp;
    public RobotMode robotMode;
    public ControlMode controlMode;
    public boolean teachButtonEnabled;
    public boolean teachButtonPressed;
    public boolean freedriveIOPressed;
    public int[] jointMode;
    public float[] jointCurrent = new float[6];
    public float[] jointVoltage = new float[6];
    public float[] jointMotorTemperature = new float[6];
    public float[] jointMicroTemperature = new float[6];
    public float toolVoltage48V;
    public float toolTemperature;
    public int toolOutputVoltage;
    public JointMode toolMode;
    public float toolCurrent;
    public float masterTemperature;
    public float robotVoltage48V;
    public float robotCurrent;
    public float masterIOCurrent;
    public SafetyMode aggregatedSafetyMode = SafetyMode.NORMAL;
    public SafetyMode masterSafetyState = SafetyMode.NORMAL;
    public boolean reducedModeActive;
    public JointPositionVector jointPosition = new JointPositionVector();
    public JointSpeedVector jointSpeed = JointSpeedVector.UNDEFINED;
    public Pose6d tool = new Pose6d();
    public Pose6d tcpOffset = new Pose6d();
    public JointPositionVector targetJointPosition = new JointPositionVector();
    public boolean hasReceivedPositionData = false;
    public byte[] digitalIn = new byte[8];
    public byte[] digitalOut = new byte[8];
    public byte[] toolIn = new byte[2];
    public byte[] toolOut = new byte[2];
    public byte[] configurableIn = new byte[8];
    public byte[] configurableOut = new byte[8];
    public byte[] analogInputRange = new byte[4];
    public byte[] analogOutputDomain = new byte[2];
    public double[] analogIn = new double[4];
    public double[] analogOut = new double[2];
    public byte[] euromapInput = new byte[21];
    public byte[] euromapOutput = new byte[16];
    public float euromap24V_voltage;
    public float euromap24V_current;
    public double speedFraction = 1.0;
    public double speedScaling = 1.0;
    public double speedFractionLimit = 1.0;
    public SpeedMode speedMode = SpeedMode.UNRESTRICTED;
    public boolean real = false;
    @Deprecated
    public boolean robotPowerOn = false;
    public boolean emergencyStopped = false;
    public boolean securityStopped = false;
    public boolean programRunning = false;
    public boolean programPaused = false;
    public double[] force_mode_frame = new double[6];
    public double robot_dexterity;
    public double robotEnergyConsumed = 0.0;
    public double robotEnergyProduced = 0.0;
    private String currentProgramName = "";

    public RobotState(boolean real) {
        this.real = real;
        this.robotMode = RobotMode.NO_CONTROLLER;
        for (int i = 0; i < 6; ++i) {
            this.jointPosition.setJoint(i, 0.0);
        }
        this.jointMode = PrimitiveUtils.initArray((int[])new int[6], (int)JointMode.NOT_RESPONDING.getId());
        this.toolMode = JointMode.NOT_RESPONDING;
    }

    public RobotState clone() {
        try {
            RobotState clone = (RobotState)super.clone();
            clone.jointMode = (int[])this.jointMode.clone();
            clone.jointCurrent = (float[])this.jointCurrent.clone();
            clone.jointVoltage = (float[])this.jointVoltage.clone();
            clone.jointMotorTemperature = (float[])this.jointMotorTemperature.clone();
            clone.jointMicroTemperature = (float[])this.jointMicroTemperature.clone();
            clone.jointPosition = this.jointPosition.clone();
            clone.tool = new Pose6d(clone.tool);
            clone.tcpOffset = new Pose6d(this.tcpOffset);
            clone.targetJointPosition = this.targetJointPosition.clone();
            clone.digitalIn = (byte[])this.digitalIn.clone();
            clone.digitalOut = (byte[])this.digitalOut.clone();
            clone.toolIn = (byte[])this.toolIn.clone();
            clone.toolOut = (byte[])this.toolOut.clone();
            clone.configurableIn = (byte[])this.configurableIn.clone();
            clone.configurableOut = (byte[])this.configurableOut.clone();
            clone.analogInputRange = (byte[])this.analogInputRange.clone();
            clone.analogOutputDomain = (byte[])this.analogOutputDomain.clone();
            clone.analogIn = (double[])this.analogIn.clone();
            clone.analogOut = (double[])this.analogOut.clone();
            clone.euromapInput = (byte[])this.euromapInput.clone();
            clone.euromapOutput = (byte[])this.euromapOutput.clone();
            clone.force_mode_frame = (double[])this.force_mode_frame.clone();
            return clone;
        }
        catch (Exception e) {
            Log.error((String)"Could not clone: ", (Throwable)e);
            return new RobotState(this.real);
        }
    }

    public void setDigitalIn(int bits) {
        RobotState.setBits(this.digitalIn, bits);
        RobotState.setBits(this.configurableIn, bits >> 8);
        RobotState.setBits(this.toolIn, bits >> 16);
    }

    public void setDigitalOut(int bits) {
        RobotState.setBits(this.digitalOut, bits);
        RobotState.setBits(this.configurableOut, bits >> 8);
        RobotState.setBits(this.toolOut, bits >> 16);
    }

    public void setEuromapInput(long bits) {
        RobotState.setBits(this.euromapInput, bits);
    }

    public void setEuromapOutput(long bits) {
        RobotState.setBits(this.euromapOutput, bits);
    }

    private static void setBits(byte[] bitArray, long bits) {
        long bitmask = 1L;
        for (int i = 0; i < bitArray.length; ++i) {
            bitArray[i] = (bits & bitmask) == bitmask ? (byte)1 : 0;
            bitmask <<= 1;
        }
    }

    public String getCurrentProgramName() {
        return this.currentProgramName;
    }

    public void setCurrentProgramName(String programName) {
        this.currentProgramName = programName;
    }

    public boolean isTeachButtonPressed() {
        return this.teachButtonPressed;
    }

    public void notifyAllSubscribers() {
        PostMan.send(this);
    }

    public static int getUnhandledEventsCount() {
        return PostMan.undeliveredMessages();
    }

    public static RobotState getLatestRobotState() {
        return latestRobotState;
    }

    private static void setLatestRobotState(RobotState robotState) {
        latestRobotState = robotState;
    }

    public static final class PostMan {
        private static final BlockingQueue<RobotState> inboxSlotOfOne = new LinkedBlockingQueue<RobotState>(1);
        private static int undeliveredMessages;
        private static final int UNDELIVERED_MSG_LIMIT = 2;

        private PostMan() {
        }

        public static int undeliveredMessages() {
            return undeliveredMessages;
        }

        public static void send(RobotState robotState) {
            undeliveredMessages = inboxSlotOfOne.offer(robotState.clone()) ? 0 : ++undeliveredMessages;
        }

        private static void work() {
            try {
                RobotState.setLatestRobotState(PostMan.inboxSlotOfOne.take());
                if (undeliveredMessages > 2) {
                    LOG.error("RobotState messages are queued up: " + undeliveredMessages, new Object[0]);
                }
                PostMan.deliver(RobotState.getLatestRobotState());
            }
            catch (InterruptedException var2) {
                Thread.currentThread().interrupt();
            }
            catch (Exception var3) {
                LOG.warn("", (Throwable)var3);
            }
        }

        private static void deliver(RobotState message) throws InvocationTargetException, InterruptedException {
            SwingUtilities.invokeAndWait(() -> EventNotificationService.notify(RobotStateListener.class, listener -> listener.updateRobotState(message)));
        }

        static {
            Thread thread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    PostMan.work();
                }
            });
            thread.setName("RobotState - PostMan");
            thread.setDaemon(true);
            thread.start();
        }
    }
}

