/*
 * Decompiled with CFR 0.152.
 */
package com.ur.monitor.model;

import com.ur.lang.Defense;
import com.ur.lang.HashCodeBuilder;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.JointType;
import com.ur.util.logging.Log;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.inject.Inject;

@Deprecated
public class JointPositionVector
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 41L;
    private boolean isUndefined;
    private final double[] joint;

    @Inject
    public JointPositionVector() {
        this(PrimitiveUtils.initArray((double[])new double[6], (double)Double.NaN));
    }

    public JointPositionVector(double j0, double j1, double j2, double j3, double j4, double j5) {
        this(new double[]{j0, j1, j2, j3, j4, j5});
    }

    public JointPositionVector(JointPositionVector jointPositionVector) {
        this(jointPositionVector.joint);
    }

    public JointPositionVector(double[] joint) {
        this.joint = Arrays.copyOf(joint, 6);
    }

    public JointPositionVector clone() {
        return new JointPositionVector(this);
    }

    public boolean isUndefined() {
        for (int i = 0; i < 6; ++i) {
            if (!Double.isNaN(this.joint[i])) continue;
            return true;
        }
        return false;
    }

    public void set(JointPositionVector jpv) {
        Defense.notNull((Object)jpv);
        for (JointType each : JointType.values()) {
            this.setJoint(each, jpv.getJoint(each));
        }
    }

    public double getJoint(int i) {
        return this.joint[i];
    }

    public double getJoint(JointType jointType) {
        return this.joint[jointType.getJointNumber()];
    }

    public void setJoint(int i, double jointPosition) {
        this.joint[i] = jointPosition;
    }

    public void setJoint(JointType jointType, double jointPosition) {
        this.joint[jointType.getJointNumber()] = jointPosition;
    }

    public void add(JointPositionVector jpv) {
        if (!this.isUndefined() && !jpv.isUndefined()) {
            for (JointType each : JointType.values()) {
                int n = each.getJointNumber();
                this.joint[n] = this.joint[n] + jpv.getJoint(each);
            }
        } else {
            Log.error((String)"Adding undefined JointPositionVector");
        }
    }

    public void sub(JointPositionVector jpv) {
        if (!this.isUndefined() && !jpv.isUndefined()) {
            for (JointType each : JointType.values()) {
                int n = each.getJointNumber();
                this.joint[n] = this.joint[n] - jpv.getJoint(each);
            }
        } else {
            Log.error((String)"Subtracting undefined JointPositionVector");
        }
    }

    public double getNorm() {
        double norm = 0.0;
        for (JointType each : JointType.values()) {
            norm += this.joint[each.getJointNumber()] * this.joint[each.getJointNumber()];
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public void scale(double factor) {
        int i = 0;
        while (i < JointType.values().length) {
            int n = i++;
            this.joint[n] = this.joint[n] * factor;
        }
    }

    public boolean equals(JointPositionVector jpv) {
        if (this.isUndefined()) {
            return jpv.isUndefined();
        }
        for (JointType each : JointType.values()) {
            if (this.getJoint(each) == jpv.getJoint(each)) continue;
            return false;
        }
        return true;
    }

    public boolean epsilonEquals(JointPositionVector targetPosition, double epsilon) {
        if (this.isUndefined() || targetPosition == null || targetPosition.isUndefined()) {
            return false;
        }
        return JointPositionVector.epsilonEquals(this.joint, targetPosition.getJoints(), epsilon);
    }

    public static boolean epsilonEquals(double[] joint1, double[] joint2, double epsilon) {
        for (int i = 0; i < JointType.values().length; ++i) {
            if (!(Math.abs(joint1[i] - joint2[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public void setNearTo(JointPositionVector nearTo) {
        for (JointType each : JointType.values()) {
            while (this.getJoint(each) - nearTo.getJoint(each) > Math.PI) {
                this.setJoint(each, this.getJoint(each) - Math.PI * 2);
            }
            while (this.getJoint(each) - nearTo.getJoint(each) < -Math.PI) {
                this.setJoint(each, this.getJoint(each) + Math.PI * 2);
            }
        }
    }

    public double[] getJoints() {
        return Arrays.copyOf(this.joint, 6);
    }

    public static String prettyPrintToString(JointPositionVector jps) {
        if (jps.isUndefined()) {
            return " -- Undefined --";
        }
        StringBuilder s = new StringBuilder("(");
        for (int i = 0; i < 6; ++i) {
            double degrees = 180.0 * jps.getJoint(i) / Math.PI;
            s.append("" + (int)degrees);
            s.append("." + (int)((degrees * 10.0 + 0.5) % 10.0));
            if (i != 5) {
                s.append(", ");
                continue;
            }
            s.append(")");
        }
        return s.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(100000).append(this.joint).toHashCode();
    }

    public boolean equals(Object jointPositionVector) {
        if (jointPositionVector instanceof JointPositionVector) {
            return this.equals((JointPositionVector)jointPositionVector);
        }
        return false;
    }

    public String toString() {
        if (this.isUndefined()) {
            return "-- Undefined robot configuration --";
        }
        return Arrays.toString(this.joint);
    }

    public String toString(DecimalFormat f) {
        if (this.isUndefined()) {
            return "-- Undefined robot configuration --";
        }
        return f.format(this.joint[0]) + " " + f.format(this.joint[1]) + " " + f.format(this.joint[2]) + " " + f.format(this.joint[3]) + " " + f.format(this.joint[4]) + " " + f.format(this.joint[5]);
    }

    public void transform(LinkTransform[] link) {
        for (int i = 0; i < this.joint.length; ++i) {
            link[i].acceptCoordinateTransformation(this.getJoint(i));
        }
    }

    public static interface LinkTransform {
        public void acceptCoordinateTransformation(double var1);
    }
}

